jQuery(document).ready(function($) {
	function isScrolledTo(elem,top) {
		var docViewTop = jQuery(window).scrollTop(); //num of pixels hidden above current screen
		var docViewBottom = docViewTop + jQuery(window).height();

		var elemTop = jQuery(elem).offset().top - top; //num of pixels above the elem
		var elemBottom = elemTop + jQuery(elem).height();

		return ((elemTop <= docViewTop));
	}

	function stickThatMenu(sticky,catcher,top) {
		if(isScrolledTo(sticky,top)) {
			sticky.addClass('sticky-navigation-active');
			catcher.height(sticky.height());
		} 
		var stopHeight = catcher.offset().top;
		if ( stopHeight > sticky.offset().top) {
			sticky.removeClass('sticky-navigation-active');
			catcher.height(0);
		}
	}

	var catcher = jQuery('#catcher'),
		sticky  = jQuery('.sticky-navigation'),
		bodyTop = jQuery('body').offset().top;

	if ( sticky.length ) {
	
		jQuery(window).scroll(function() {
			stickThatMenu(sticky,catcher,bodyTop);
		});
		jQuery(window).resize(function() {
			stickThatMenu(sticky,catcher,bodyTop);
		});
	}

	/*----------------------------------------------------
	/* Social button scripts
	/*---------------------------------------------------*/
	function mtsInitFloatingSocialIcons() {
		$('.catchersocial').each(function() {

			var catcherSocial   = $(this),
				catcherSocial2  = $(this).closest('.single_post').find('.catchersocial2'),
				stickySocial	= $(this).closest('.single_post').find('.shareit'),
				stickyNavHeight = 0,
				stickySocialTop = 0;

			if ( sticky.length ) {
				stickyNavHeight = sticky.height();
			}

			stickySocialTop = stickyNavHeight + bodyTop + 10;

			$(window).scroll(function() {

				if ( isScrolledTo( catcherSocial, stickySocialTop ) || ( isScrolledTo( catcherSocial2, stickySocialTop + stickySocial.height() ) && stickySocial.css('bottom') == '0' ) ) {
					stickySocial.css( 'position', 'fixed' );
					stickySocial.css( 'top', stickySocialTop );
					stickySocial.css( 'bottom', 'auto' );
				}

				var stopHeight  = catcherSocial.offset().top + catcherSocial.height();
				if ( stopHeight > stickySocial.offset().top) {
					stickySocial.css('position','absolute');
					stickySocial.css('top', '0');
					stickySocial.css('bottom', 'auto');
				}

				var stopHeight2 = catcherSocial2.offset().top + catcherSocial2.height();
				if ( stopHeight2 < stickySocial.offset().top + stickySocial.height() ) {
					stickySocial.css('position','absolute');
					stickySocial.css('top', 'auto');
					stickySocial.css('bottom', '0');
				}
				
			});
		});
	}

	mtsInitFloatingSocialIcons();

	$( document ).ajaxComplete(function( event ) {
		mtsInitFloatingSocialIcons();
	});

	if ( $('.sticky-navigation-up-down').length ) {

		// Hide Header on scroll down
		var didScroll;
		var lastScrollTop = 0;
		var delta = 5;
		var navbarHeight = $('.sticky-navigation-up-down').outerHeight();

		$(window).scroll(function(event){
		    didScroll = true;
		});

		setInterval(function() {
		    if (didScroll) {
		        hasScrolled();
		        didScroll = false;
		    }
		}, 250);

		function hasScrolled() {
		    var st = $(this).scrollTop();
		    
		    // Make sure they scroll more than delta
		    if(Math.abs(lastScrollTop - st) <= delta)
		        return;
		    
		    // If they scrolled down and are past the navbar, add class .nav-up.
		    // This is necessary so you never see what is "behind" the navbar.
		    if (st > lastScrollTop && st > navbarHeight){
		        // Scroll Down
		        $('.sticky-navigation-up-down').removeClass('nav-down').addClass('nav-up').css('top', -navbarHeight);
		    } else {
		        // Scroll Up
		        if(st + $(window).height() < $(document).height()) {
		            $('.sticky-navigation-up-down').removeClass('nav-up').addClass('nav-down').css('top', bodyTop);
		        }
		    }
		    
		    lastScrollTop = st;
		}
	}
});