<?php
/**
 * The template for displaying the header.
 *
 * Displays everything from the doctype declaration down to the navigation.
 */
?>
<!DOCTYPE html>
<?php $mts_options = get_option(MTS_THEME_NAME); ?>
<html class="no-js" <?php language_attributes(); ?>>
<head itemscope itemtype="http://schema.org/WebSite">
	<meta charset="<?php bloginfo('charset'); ?>">
	<!-- Always force latest IE rendering engine (even in intranet) & Chrome Frame -->
	<!--[if IE ]>
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<![endif]-->
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<?php mts_meta(); ?>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<?php wp_head(); ?>
</head>
<body id="blog" <?php body_class('main'); ?> itemscope itemtype="http://schema.org/WebPage"> 
	<header id="site-header" role="banner" itemscope itemtype="http://schema.org/WPHeader">
		<?php if ( $mts_options['mts_top_navigation'] == '1' ) { ?>			
			<?php if( $mts_options['mts_sticky_nav'] == '1' ) { ?>
				<div id="catcher" class="clear" ></div>
				<div id="primary-navigation" class="sticky-navigation" role="navigation" itemscope itemtype="http://schema.org/SiteNavigationElement">
			<?php } else { ?>
		    <div id="primary-navigation" role="navigation" itemscope itemtype="http://schema.org/SiteNavigationElement">
		    <?php } ?>
		    	<div class="primary-menu-wrap primary-navigation clearfix">
				<?php if ( $mts_options['mts_sec_navigation'] !== '1' ) {?><a href="#" id="pull" class="toggle-mobile-menu"><?php _e('Menu', 'truepixel' ); ?></a><?php } ?>
					<nav id="navigation" class="navigation clearfix<?php if ( $mts_options['mts_sec_navigation'] !== '1' ) echo ' mobile-menu-wrapper'; ?>">
						<?php if ( has_nav_menu( 'primary-menu' ) ) { ?>
							<?php wp_nav_menu(  array( 'theme_location' => 'primary-menu', 'menu_class' => 'menu clearfix', 'container' => '', 'walker' => new mts_menu_walker ) ); ?>
						<?php } else { ?>
							<ul class="menu clearfix">
								<?php wp_list_pages('title_li='); ?>
							</ul>
						<?php } ?>
					</nav>
		        	<?php mts_cart(); ?>
		        </div>
			</div>
		<?php } ?>
		<div class="container">
			<div id="header">
				<div class="logo-wrap">
					<?php if ($mts_options['mts_logo'] != '') { ?>
						<?php if( is_front_page() || is_home() || is_404() ) { ?>
							<h1 id="logo" class="image-logo" itemprop="headline">
								<a href="<?php echo esc_url( home_url() ); ?>"><img src="<?php echo esc_url( $mts_options['mts_logo'] ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>"<?php if (!empty($mts_options['mts_logo2x'])) { echo ' data-at2x="'.esc_attr( $mts_options['mts_logo2x'] ).'"'; } ?>></a>
							</h1><!-- END #logo -->
						<?php } else { ?>
							<h2 id="logo" class="image-logo" itemprop="headline">
								<a href="<?php echo esc_url( home_url() ); ?>"><img src="<?php echo esc_url( $mts_options['mts_logo'] ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>"<?php if (!empty($mts_options['mts_logo2x'])) { echo ' data-at2x="'.esc_attr( $mts_options['mts_logo2x'] ).'"'; } ?>></a>
							</h2><!-- END #logo -->
						<?php } ?>
					<?php } else { ?>
						<?php if( is_front_page() || is_home() || is_404() ) { ?>
							<h1 id="logo" class="text-logo" itemprop="headline">
								<a href="<?php echo esc_url( home_url() ); ?>"><?php bloginfo( 'name' ); ?></a>
							</h1><!-- END #logo -->
						<?php } else { ?>
							<h2 id="logo" class="text-logo" itemprop="headline">
								<a href="<?php echo esc_url( home_url() ); ?>"><?php bloginfo( 'name' ); ?></a>
							</h2><!-- END #logo -->
						<?php } ?>
					<?php } ?>
				</div>
				<?php dynamic_sidebar('widget-header'); ?>
				<?php if ( $mts_options['mts_sec_navigation'] == '1' ) { ?>
					<div id="secondary-navigation" class="secondary-navigation" role="navigation" itemscope itemtype="http://schema.org/SiteNavigationElement">
						<a href="#" id="pull" class="toggle-mobile-menu"><?php _e('Menu', 'truepixel' ); ?></a>
						<?php if ( has_nav_menu( 'mobile' ) ) { ?>
							<nav id="navigation" class="navigation clearfix">
								<?php if ( has_nav_menu( 'secondary-menu' ) ) { ?>
									<?php wp_nav_menu( array( 'theme_location' => 'secondary-menu', 'menu_class' => 'menu clearfix', 'container' => '', 'walker' => new mts_menu_walker ) ); ?>
								<?php } else { ?>
									<ul class="menu clearfix">
										<?php wp_list_categories('title_li='); ?>
									</ul>
								<?php } ?>
							</nav>
							<nav class="navigation mobile-only clearfix mobile-menu-wrapper">
								<?php wp_nav_menu( array( 'theme_location' => 'mobile', 'menu_class' => 'menu clearfix', 'container' => '', 'walker' => new mts_menu_walker ) ); ?>
							</nav>
						<?php } else { ?>
							<nav id="navigation" class="navigation clearfix mobile-menu-wrapper">
								<?php if ( has_nav_menu( 'secondary-menu' ) ) { ?>
									<?php wp_nav_menu( array( 'theme_location' => 'secondary-menu', 'menu_class' => 'menu clearfix', 'container' => '', 'walker' => new mts_menu_walker ) ); ?>
								<?php } else { ?>
									<ul class="menu clearfix">
										<?php wp_list_categories('title_li='); ?>
									</ul>
								<?php } ?>
							</nav>
						<?php } ?>
					</div>
				<?php } ?>            
			</div><!--#header-->
		</div><!--.container-->
	</header>      
	<div class="main-container">