<?php get_header();

$showcase_type = get_post_meta( get_the_ID(), '_mts_project_showcase_type', true );
$showcase_parallax = get_post_meta( get_the_ID(), '_mts_project_showcase_parallax', true );
$info_title = get_post_meta( get_the_ID(), '_mts_project_info_title', true );
$info_des = get_post_meta( get_the_ID(), '_mts_project_info_des', true );
$entries = get_post_meta( get_the_ID(), '_mts_project_info_group', true );
$parallax_class = ( 'on' == $showcase_parallax ) ? 'parallax' : 'non-parallax';
$btn_text = get_post_meta( get_the_ID(), '_mts_project_info_btn_text', true );
$btn_link = get_post_meta( get_the_ID(), '_mts_project_info_btn_link', true );

if($parallax_class == 'parallax') {
	$image_size = 'full';
} else {
	$image_size = 'pointpro-slider';
}

if ( 'image' == $showcase_type ) {
	if( has_post_thumbnail() ) { ?>
        <div id="<?php echo $parallax_class; ?>" class="project-showcase project-showcase-image" style="background-image: url(<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id(), $image_size ); echo $image[0]; ?>);">
        </div>
        <?php
    }
} else {
	$args = array(
		'post_type'   => 'attachment',
		'numberposts' => -1,
		'post_parent' => get_the_ID(),
		'order' => 'ASC',
		'orderby' => 'menu_order',
		'post_mime_type' => 'image',
		'exclude' => get_post_thumbnail_id(get_the_ID())
		);

	$attachments = get_posts( $args );
	if ( $attachments ){
		?>
		<div class="project-showcase project-showcase-slider bg-slider loading">
		<?php
		foreach ( $attachments as $attachment ){
			$id = $attachment->ID;
			$src =  wp_get_attachment_image_src( $id, 'pointpro-slider' ); ?>
			<div class="bg-slide project-showcase-image" style="background-image: url(<?php echo $src[0];?>);"></div>
			<?php
		}
		?>
		</div>
	<?php }
} ?>
<div id="page" class="single single-project">
	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
		<article id="post-<?php the_ID(); ?>" class="<?php if(empty($entries) && empty($info_title) && empty($info_des) && empty($btn_text)) { echo 'ss-full-width'; } else { echo 'article'; } ?>">
			<div class="inner-page-header border-bottom clearfix">	
				<h1 class="inner-page-title"><?php the_title(); ?></h1>
			</div>

			<div class="clearfix">
				<div class="portfolio-content">
					<div class="thecontent description">
                        <?php the_content(); ?>
					</div>
					<?php wp_link_pages(array('before' => '<div class="pagination">', 'after' => '</div>', 'link_before'  => '<span class="current"><span class="currenttext">', 'link_after' => '</span></span>', 'next_or_number' => 'next_and_number', 'nextpagelink' => __('Next','mythemeshop'), 'previouspagelink' => __('Previous','mythemeshop'), 'pagelink' => '%','echo' => 1 )); ?>
				</div>
			</div>
		</article>
		<aside id="sidebar" class="sidebar c-4-12" role="complementary" itemscope itemtype="http://schema.org/WPSideBar">
			<?php if(!empty($entries) || !empty($info_title) || !empty($info_des) || !empty($btn_text)) { ?>
				<div class="portfolio-sidebar full-border">
					<?php
					if( ! empty( $info_title ) ) {
						echo '<h3 class="project-info-title">' . esc_html( $info_title ) .'</h3>';
					}

					if( ! empty( $info_des ) ){
						echo '<div class="description">' . wpautop( $info_des ) .'</div>';
					}

					if ( !empty( $entries ) ) { ?>
						<div class="project-info panel">
							<dl>
							<?php foreach ( (array) $entries as $key => $entry ) {

								$name = $value = $link = '';
								if ( isset( $entry['key'] ) ) $name = esc_html( $entry['key'] );
							    if ( isset( $entry['value'] ) ) $value = esc_html( $entry['value'] );
							    if ( isset( $entry['link'] ) ) $link = esc_url( $entry['link'] );

							    if ( !empty( $name ) ) {
							    	echo '<dt>'.$name.'</dt>';
							    	if( $link ){
							    		echo '<dd><a href="'. $link .'">'. $value.'</a></dd>';
							    	}else{
							    		echo '<dd>'.$value.'</dd>';
							    	}
							    	
							    }
							} ?>
							</dl>
						</div><!--.project-info-->
					<?php } 
					if( $btn_text && $btn_link ){
						echo '<a href="'. esc_url( $btn_link ) .'" class="header-button project-btn">'. esc_html( $btn_text ).'</a>';
					} ?>
				</div>
			<?php } ?>
		</aside>
	<?php endwhile; endif; /* end loop */ ?>
</div>
<?php get_footer(); ?>