<?php $mts_options = get_option(MTS_THEME_NAME);
get_header();
if ( !is_paged() && $mts_options['mts_featured_slider'] == '1' ) { ?>
    <div class="featuredBox">
        <?php $i = 1;
        // prevent implode error
        if ( empty( $mts_options['mts_featured_slider_cat'] ) || !is_array( $mts_options['mts_featured_slider_cat'] ) ) {
            $mts_options['mts_featured_slider_cat'] = array('0');
        }
        $slider_cat = implode( ",", $mts_options['mts_featured_slider_cat'] );
        $slider_query = new WP_Query('cat='.$slider_cat.'&posts_per_page=4&ignore_sticky_posts=1'); 
        while ($slider_query->have_posts()) : $slider_query->the_post();
            if($i == 1){ ?> 
                <div class="firstpost excerpt">
                    <a href="<?php echo esc_url( get_the_permalink() ); ?>" title="<?php echo esc_attr( get_the_title() ); ?>" id="first-thumbnail">
                        <?php echo '<div class="featured-thumbnail">'; the_post_thumbnail('pointpro-bigthumb',array('title' => '')); echo '</div>'; ?>
                        <p class="featured-excerpt">
                            <span class="featured-title"><?php the_title(); ?></span>
                            <span class="f-excerpt"><?php echo mts_excerpt(10);?></span>
                        </p>
                    </a>
                </div><!--.post excerpt-->
            <?php } elseif($i == 2) { ?>
                <div class="secondpost excerpt">
                    <a href="<?php echo esc_url( get_the_permalink() ); ?>" title="<?php echo esc_attr( get_the_title() ); ?>" id="second-thumbnail">
                        <?php echo '<div class="featured-thumbnail">'; the_post_thumbnail('pointpro-mediumthumb',array('title' => '')); echo '</div>'; ?>
                        <p class="featured-excerpt">
                            <span class="featured-title"><?php the_title(); ?></span>
                        </p>
                    </a>
                </div><!--.post excerpt-->
            <?php } elseif($i == 3 || $i == 4) { ?>
                <div class="thirdpost excerpt">
                    <a href="<?php echo esc_url( get_the_permalink() ); ?>" title="<?php echo esc_attr( get_the_title() ); ?>" id="third-thumbnail">
                        <?php echo '<div class="featured-thumbnail">'; the_post_thumbnail('pointpro-smallthumb',array('title' => '')); echo '</div>'; ?>
                        <p class="featured-excerpt">
                            <span class="featured-title"><?php the_title(); ?></span>
                        </p>
                    </a>
                </div><!--.post excerpt-->
            <?php }
        $i++; endwhile; wp_reset_query(); ?> 
    </div>
<?php } ?>
<div id="page">
    <div class="article <?php echo ($mts_options['mts_full_posts'] == '1') ? 'index-2' : ''; ?>">
        <div id="content_box">
            <?php if ( !is_paged() ) {
                $featured_categories = array();
                if ( !empty( $mts_options['mts_featured_categories'] ) ) {
                    foreach ( $mts_options['mts_featured_categories'] as $section ) {
                        $category_id = $section['mts_featured_category'];
                        $featured_categories[] = $category_id;
                        $posts_num = $section['mts_featured_category_postsnum'];
                        if ( 'latest' == $category_id ) { ?>
                            <h3 class="featured-category-title"><?php _e('Latest', 'pointpro' ); ?></h3>
                            <?php $j = 0; if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
                                <article class="latestPost excerpt <?php echo (++$j % 3 == 0) ? 'last' : ''; ?> <?php echo (++$j % 3 == 0) ? 'full-post' : ''; ?>">
                                    <?php mts_archive_post(); ?>
                                </article>
                            <?php endwhile; endif; ?>
                            
                            <?php if ( $j !== 0 ) { // No pagination if there is no posts
                                mts_pagination();
                            } ?>
                            
                        <?php } else { // if $category_id != 'latest': ?>
                            <h3 class="featured-category-title"><a href="<?php echo esc_url( get_category_link( $category_id ) ); ?>" title="<?php echo esc_attr( get_cat_name( $category_id ) ); ?>"><?php echo esc_html( get_cat_name( $category_id ) ); ?></a></h3>
                            <?php
                            $j = 0;
                            $cat_query = new WP_Query('cat='.$category_id.'&posts_per_page='.$posts_num);
                            if ( $cat_query->have_posts() ) : while ( $cat_query->have_posts() ) : $cat_query->the_post(); ?>
                                <article class="latestPost excerpt <?php echo (++$j % 3 == 0) ? 'last' : ''; ?>">
                                    <?php mts_archive_post(); ?>
                                </article>
                            <?php endwhile; endif; wp_reset_postdata();
                        }
                    }
                }
            } else { //Paged
                $j = 0; if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
                <article class="latestPost excerpt <?php echo (++$j % 3 == 0) ? 'last' : ''; ?>">
                    <?php mts_archive_post(); ?>
                </article>
                <?php endwhile; endif; ?>

                <?php if ( $j !== 0 ) { // No pagination if there is no posts
                    mts_pagination();
                }
            } ?>
        </div>
    </div>
    <?php get_sidebar(); ?>
</div>
<?php get_footer(); ?>