<?php
$mts_options = get_option(MTS_THEME_NAME);
$mts_homepage_projects_title = $mts_options['mts_homepage_projects_title'];
$mts_projects_num    = empty ( $mts_options['mts_projects_count_home'] ) ? '3' : $mts_options['mts_projects_count_home'];
$mts_projects_layout = $mts_options['mts_projects_layout'];

if ( '1' == $mts_projects_layout ) {
	$cols    = ' one-fourth';
	$thumb_size = 'pointpro-project-4';
} else {
	$cols    = ' one-third';
	$thumb_size = 'pointpro-project-3';
} ?>

<div id="projects" class="section clearfix">
	<div id="page">
		<?php if ( !empty( $mts_homepage_projects_title ) ) { ?>
			<h2 class="section-title"><span><?php echo $mts_homepage_projects_title; ?></span></h2>
		<?php }?>
		<a href="<?php echo get_post_type_archive_link( 'project' ); ?>" class="btn-archive-link"><?php _e( 'All projects', 'pointpro' ); ?></a>
		<div class="grid">
			<?php
			$query = new WP_Query();
			$query->query('post_type=project&ignore_sticky_posts=1&posts_per_page='.$mts_projects_num);
			while ( $query->have_posts() ) : $query->the_post(); ?>
				<article class="project-item grid-box<?php echo $cols; ?>">
					<div class="grid-inner project-box-inner">
						<a class="project-image" href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>">
							<?php the_post_thumbnail( $thumb_size, array('title' => '')); ?>
							<h3 class="project-title title"><?php the_title(); ?></h3>
						</a>
						<div class="project-description description"><?php echo mts_excerpt(18); ?></div>	
					</div>
				</article>

	        <?php endwhile; ?>
	        <?php wp_reset_query(); ?>
		</div>
	</div>
</div>