<?php
$mts_options = get_option(MTS_THEME_NAME);

$mts_homepage_features_title = $mts_options['mts_homepage_features_title'];
$columns = ( $mts_options['mts_homepage_features_columns'] ) ? 'one-fourth' : 'one-third';
?>
<div id="features" class="section clearfix">
    <div id="page">
        <?php if ( !empty( $mts_homepage_features_title ) ) { ?>
            <h2 class="section-title"><span><?php echo $mts_homepage_features_title; ?></span></h2>
        <?php }
        if ( ! empty( $mts_options['mts_homepage_features'] ) ) {
            ?>
            <div class="grid">
            <?php
            foreach ( $mts_options['mts_homepage_features'] as $key => $section ) {
                $feature_title       = $section['mts_homepage_feature_title'];
                $feature_icon        = $section['mts_homepage_feature_icon'];
                $feature_description = $section['mts_homepage_feature_description'];
                ?>
                <div class="grid-box <?php echo $columns; ?>">
                    <div class="grid-box-inner">
                        <h3 class="title feature-title"><?php if ( !empty( $feature_icon ) ) { ?><i class="feature-icon fa fa-<?php echo $feature_icon; ?>"></i><?php } ?><?php echo $feature_title; ?></h3>
                        <div class="feature-description">
                            <?php echo $feature_description; ?>
                        </div>
                    </div>
                </div>
            <?php } ?>
            </div>
            <?php
        } ?>
    </div>
</div>