<?php
/**
 * The template for displaying Project archive.
 */

get_header();

$mts_options = get_option(MTS_THEME_NAME);
$mts_homepage_projects_title = $mts_options['mts_homepage_projects_title'];
$mts_projects_layout = $mts_options['mts_projects_layout'];

if ( '1' == $mts_projects_layout ) {
	$cols    = ' one-fourth';
	$thumb_size = 'pointpro-project-4';
} else {
	$cols    = ' one-third';
	$thumb_size = 'pointpro-project-3';
} ?>

<div id="page">
	<div class="project-header inner-page-header border-bottom clearfix">		
		<h1 class="inner-page-title section-title"><span><?php echo $mts_homepage_projects_title; ?></span></h1>
		<div class="btn-archive-link project-categories">
			<?php echo '<a href="' . esc_url( get_post_type_archive_link( 'project' ) ) . '" class="btn active">' . __('All','pointpro') . '</a>';
			$terms = get_terms( 'mts_categories' );
			foreach ( $terms as $term ) {
			    $term_link = get_term_link( $term );
			    if ( is_wp_error( $term_link ) ) {
			        continue;
			    }
			    echo '<a href="' . esc_url( $term_link ) . '" class="outline-btn">' . $term->name . '</a>';
			} ?>
		</div>
	</div>
	
	<div id="projects-archive" class="grid cpt-archive">
		<?php $paged = ( get_query_var('paged') > 1 ) ? get_query_var('paged') : 1;
		$args = array(
			'post_type' => 'project',
			'post_status' => 'publish',
			'paged' => $paged,
			'ignore_sticky_posts'=> 1,
			'posts_per_page' => empty ( $mts_options['mts_projects_count'] ) ? '12' : $mts_options['mts_projects_count']
		);
		$project_posts = new WP_Query( $args );
		$j = 0; if ( $project_posts->have_posts() ) : while ( $project_posts->have_posts() ) : $project_posts->the_post(); ?>
			<article class="project-item grid-box<?php echo $cols; ?>">
				<div class="grid-inner project-box-inner">
					<a class="project-image" href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>">
						<?php the_post_thumbnail( $thumb_size, array('title' => '')); ?>			
						<h2 class="project-title title"><?php the_title(); ?></h2>
					</a>
					<div class="project-description description"><?php echo mts_excerpt(18); ?></div>	
				</div>
			</article>
		<?php $j++; endwhile; endif; ?>
	</div>
	<?php if ( $j !== 0 ) { // No pagination if there is no results ?>
		<!--Start Pagination-->
		<?php mts_pagination('', 3, 'mts_project_pagenavigation_type'); ?>
		<!--End Pagination-->
	<?php } ?>
</div>
<?php get_footer(); ?>