<?php

defined('ABSPATH') or die;

/*
 * 
 * Require the framework class before doing anything else, so we can use the defined urls and dirs
 *
 */
require_once( dirname( __FILE__ ) . '/options/options.php' );

/*
 * 
 * Add support tab
 *
 */
if ( ! defined('MTS_THEME_WHITE_LABEL') || ! MTS_THEME_WHITE_LABEL ) {
	require_once( dirname( __FILE__ ) . '/options/support.php' );
	$mts_options_tab_support = MTS_Options_Tab_Support::get_instance();
}

/*
 * 
 * Custom function for filtering the sections array given by theme, good for child themes to override or add to the sections.
 * Simply include this function in the child themes functions.php file.
 *
 * NOTE: the defined constansts for urls, and dir will NOT be available at this point in a child theme, so you must use
 * get_template_directory_uri() if you want to use any of the built in icons
 *
 */
function add_another_section($sections){
	
	//$sections = array();
	$sections[] = array(
				'title' => __('A Section added by hook', 'pointpro' ),
				'desc' => '<p class="description">' . __('This is a section created by adding a filter to the sections array, great to allow child themes, to add/remove sections from the options.', 'pointpro' ) . '</p>',
				//all the glyphicons are included in the options folder, so you can hook into them, or link to your own custom ones.
				//You dont have to though, leave it blank for default.
				'icon' => trailingslashit(get_template_directory_uri()).'options/img/glyphicons/glyphicons_062_attach.png',
				//Lets leave this as a blank section, no options just some intro text set above.
				'fields' => array()
				);
	
	return $sections;
	
}//function
//add_filter('nhp-opts-sections-twenty_eleven', 'add_another_section');


/*
 * 
 * Custom function for filtering the args array given by theme, good for child themes to override or add to the args array.
 *
 */
function change_framework_args($args){
	
	//$args['dev_mode'] = false;
	
	return $args;
	
}//function
//add_filter('nhp-opts-args-twenty_eleven', 'change_framework_args');

/*
 * This is the meat of creating the optons page
 *
 * Override some of the default values, uncomment the args and change the values
 * - no $args are required, but there there to be over ridden if needed.
 *
 *
 */

function setup_framework_options(){
$args = array();

//Set it to dev mode to view the class settings/info in the form - default is false
$args['dev_mode'] = false;
//Remove the default stylesheet? make sure you enqueue another one all the page will look whack!
//$args['stylesheet_override'] = true;

//Add HTML before the form
//$args['intro_text'] = __('<p>This is the HTML which can be displayed before the form, it isnt required, but more info is always better. Anything goes in terms of markup here, any HTML.</p>', 'pointpro' );

//Setup custom links in the footer for share icons
if ( ! MTS_THEME_WHITE_LABEL ) {
	//Setup custom links in the footer for share icons
	$args['share_icons']['twitter'] = array(
		'link' => 'http://twitter.com/mythemeshopteam',
		'title' => __( 'Follow Us on Twitter', 'pointpro' ),
		'img' => 'fa fa-twitter-square'
	);
	$args['share_icons']['facebook'] = array(
		'link' => 'http://www.facebook.com/mythemeshop',
		'title' => __( 'Like us on Facebook', 'pointpro' ),
		'img' => 'fa fa-facebook-square'
	);
}

//Choose to disable the import/export feature
//$args['show_import_export'] = false;

//Choose a custom option name for your theme options, the default is the theme name in lowercase with spaces replaced by underscores
$args['opt_name'] = MTS_THEME_NAME;

//Custom menu icon
//$args['menu_icon'] = '';

//Custom menu title for options page - default is "Options"
$args['menu_title'] = __('Theme Options', 'pointpro' );

//Custom Page Title for options page - default is "Options"
$args['page_title'] = __('Theme Options', 'pointpro' );

//Custom page slug for options page (wp-admin/themes.php?page=***) - default is "nhp_theme_options"
$args['page_slug'] = 'theme_options';

//Custom page capability - default is set to "manage_options"
//$args['page_cap'] = 'manage_options';

//page type - "menu" (adds a top menu section) or "submenu" (adds a submenu) - default is set to "menu"
//$args['page_type'] = 'submenu';

//parent menu - default is set to "themes.php" (Appearance)
//the list of available parent menus is available here: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
//$args['page_parent'] = 'themes.php';

//custom page location - default 100 - must be unique or will override other items
$args['page_position'] = 62;

//Custom page icon class (used to override the page icon next to heading)
//$args['page_icon'] = 'icon-themes';
		
//Set ANY custom page help tabs - displayed using the new help tab API, show in order of definition		
if ( ! MTS_THEME_WHITE_LABEL ) {
	//Set ANY custom page help tabs - displayed using the new help tab API, show in order of definition
	$args['help_tabs'][] = array(
		'id' => 'nhp-opts-1',
		'title' => __('Support', 'pointpro' ),
		'content' => '<p>' . sprintf( __('If you are facing any problem with our theme or theme option panel, head over to our %s.', 'pointpro' ), '<a href="http://community.mythemeshop.com/">'. __( 'Support Forums', 'pointpro' ) . '</a>' ) . '</p>'
	);
	$args['help_tabs'][] = array(
		'id' => 'nhp-opts-2',
		'title' => __('Earn Money', 'pointpro' ),
		'content' => '<p>' . sprintf( __('Earn 55%% commision on every sale by refering your friends and readers. Join our %s.', 'pointpro' ), '<a href="http://mythemeshop.com/affiliate-program/">' . __( 'Affiliate Program', 'pointpro' ) . '</a>' ) . '</p>'
	);
}

//Set the Help Sidebar for the options page - no sidebar by default										
//$args['help_sidebar'] = __('<p>This is the sidebar content, HTML is allowed.</p>', 'pointpro' );

$mts_patterns = array(
	'nobg' => array('img' => NHP_OPTIONS_URL.'img/patterns/nobg.png'),
	'pattern0' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern0.png'),
	'pattern1' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern1.png'),
	'pattern2' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern2.png'),
	'pattern3' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern3.png'),
	'pattern4' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern4.png'),
	'pattern5' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern5.png'),
	'pattern6' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern6.png'),
	'pattern7' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern7.png'),
	'pattern8' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern8.png'),
	'pattern9' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern9.png'),
	'pattern10' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern10.png'),
	'pattern11' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern11.png'),
	'pattern12' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern12.png'),
	'pattern13' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern13.png'),
	'pattern14' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern14.png'),
	'pattern15' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern15.png'),
	'pattern16' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern16.png'),
	'pattern17' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern17.png'),
	'pattern18' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern18.png'),
	'pattern19' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern19.png'),
	'pattern20' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern20.png'),
	'pattern21' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern21.png'),
	'pattern22' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern22.png'),
	'pattern23' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern23.png'),
	'pattern24' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern24.png'),
	'pattern25' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern25.png'),
	'pattern26' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern26.png'),
	'pattern27' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern27.png'),
	'pattern28' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern28.png'),
	'pattern29' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern29.png'),
	'pattern30' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern30.png'),
	'pattern31' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern31.png'),
	'pattern32' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern32.png'),
	'pattern33' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern33.png'),
	'pattern34' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern34.png'),
	'pattern35' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern35.png'),
	'pattern36' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern36.png'),
	'pattern37' => array('img' => NHP_OPTIONS_URL.'img/patterns/pattern37.png'),
	'hbg' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg.png'),
	'hbg2' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg2.png'),
	'hbg3' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg3.png'),
	'hbg4' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg4.png'),
	'hbg5' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg5.png'),
	'hbg6' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg6.png'),
	'hbg7' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg7.png'),
	'hbg8' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg8.png'),
	'hbg9' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg9.png'),
	'hbg10' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg10.png'),
	'hbg11' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg11.png'),
	'hbg12' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg12.png'),
	'hbg13' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg13.png'),
	'hbg14' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg14.png'),
	'hbg15' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg15.png'),
	'hbg16' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg16.png'),
	'hbg17' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg17.png'),
	'hbg18' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg18.png'),
	'hbg19' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg19.png'),
	'hbg20' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg20.png'),
	'hbg21' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg21.png'),
	'hbg22' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg22.png'),
	'hbg23' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg23.png'),
	'hbg24' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg24.png'),
	'hbg25' => array('img' => NHP_OPTIONS_URL.'img/patterns/hbg25.png')
);

$sections = array();

$sections[] = array(
				'icon' => 'fa fa-cogs',
				'title' => __('General Settings', 'pointpro' ),
				'desc' => __('This tab contains common setting options which will be applied to the whole theme.', 'pointpro' ),
				'fields' => array(
					array(
						'id' => 'mts_logo',
						'type' => 'upload',
						'title' => __('Logo Image', 'pointpro' ), 
						'sub_desc' => __('Upload your logo using the Upload Button or insert image URL.', 'pointpro' )
						),
					array(
						'id' => 'mts_footer_logo',
						'type' => 'upload',
						'title' => __('Footer Logo Image', 'pointpro' ), 
						'sub_desc' => __('Upload your footer logo using the Upload Button or insert image URL.', 'pointpro' )
						),
					array(
						'id' => 'mts_favicon',
						'type' => 'upload',
						'title' => __('Favicon', 'pointpro' ), 
						'sub_desc' => sprintf( __('Upload a %s image that will represent your website\'s favicon.', 'pointpro' ), '<strong>32 x 32 px</strong>' )
						),
					array(
						'id' => 'mts_touch_icon',
						'type' => 'upload',
						'title' => __('Touch icon', 'pointpro' ), 
						'sub_desc' => sprintf( __('Upload a %s image that will represent your website\'s touch icon for iOS 2.0+ and Android 2.1+ devices.', 'pointpro' ), '<strong>152 x 152 px</strong>' )
						),
					array(
						'id' => 'mts_metro_icon',
						'type' => 'upload',
						'title' => __('Metro icon', 'pointpro' ), 
						'sub_desc' => sprintf( __('Upload a %s image that will represent your website\'s IE 10 Metro tile icon.', 'pointpro' ), '<strong>144 x 144 px</strong>' )

						),
					array(
						'id' => 'mts_twitter_username',
						'type' => 'text',
						'title' => __('Twitter Username', 'pointpro' ),
						'sub_desc' => __('Enter your Username here. Will be used for twitter share button.', 'pointpro' ),
						),
					array(
						'id' => 'mts_feedburner',
						'type' => 'text',
						'title' => __('FeedBurner URL', 'pointpro' ),
						'sub_desc' => sprintf( __('Enter your FeedBurner\'s URL here, ex: %s and your main feed (http://example.com/feed) will get redirected to the FeedBurner ID entered here.)', 'pointpro' ), '<strong>http://feeds.feedburner.com/mythemeshop</strong>' ),
						'validate' => 'url'
						),
					array(
						'id' => 'mts_header_code',
						'type' => 'textarea',
						'title' => __('Header Code', 'pointpro' ), 
						'sub_desc' => wp_kses( __('Enter the code which you need to place <strong>before closing &lt;/head&gt; tag</strong>. (ex: Google Webmaster Tools verification, Bing Webmaster Center, BuySellAds Script, Alexa verification etc.)', 'pointpro' ), array( 'strong' => array() ) )
						),
					array(
						'id' => 'mts_analytics_code',
						'type' => 'textarea',
						'title' => __('Footer Code', 'pointpro' ), 
						'sub_desc' => wp_kses( __('Enter the codes which you need to place in your footer. <strong>(ex: Google Analytics, Clicky, STATCOUNTER, Woopra, Histats, etc.)</strong>.', 'pointpro' ), array( 'strong' => array() ) )
						),
                    array(
                        'id' => 'mts_ajax_search',
                        'type' => 'button_set',
                        'title' => __('AJAX Quick search', 'pointpro' ), 
						'options' => array( '0' => __( 'Off', 'pointpro' ), '1' => __( 'On', 'pointpro' ) ),
						'sub_desc' => __('Enable or disable search results appearing instantly below the search form', 'pointpro' ),
						'std' => '0'
                        ),
					array(
						'id' => 'mts_responsive',
						'type' => 'button_set',
						'title' => __('Responsiveness', 'pointpro' ),
						'options' => array( '0' => __( 'Off', 'pointpro' ), '1' => __( 'On', 'pointpro' ) ),
						'sub_desc' => __('MyThemeShop themes are responsive, which means they adapt to tablet and mobile devices, ensuring that your content is always displayed beautifully no matter what device visitors are using. Enable or disable responsiveness using this option.', 'pointpro' ),
						'std' => '1'
						),
					array(
						'id' => 'mts_rtl',
						'type' => 'button_set',
						'title' => __('Right To Left Language Support', 'pointpro' ), 
						'options' => array( '0' => __( 'Off', 'pointpro' ), '1' => __( 'On', 'pointpro' ) ),
						'sub_desc' => __('Enable this option for right-to-left sites.', 'pointpro' ),
						'std' => '0'
						),
					array(
						'id' => 'mts_shop_products',
						'type' => 'text',
						'title' => __('No. of Products', 'pointpro' ),
						'sub_desc' => __('Enter the total number of products which you want to show on shop page (WooCommerce plugin must be enabled).', 'pointpro' ),
						'validate' => 'numeric',
						'std' => '9',
						'class' => 'small-text'
						),
					)
				);

$sections[] = array(
				'icon' => 'fa fa-bolt',
				'title' => __('Performance', 'pointpro' ),
				'desc' => '<p class="description">' . __('This tab contains performance-related options which can help speed up your website.', 'pointpro' ) . '</p>',
				'fields' => array(
					array(
						'id' => 'mts_prefetching',
						'type' => 'button_set',
						'title' => __('Prefetching', 'pointpro' ),
						'options' => array( '0' => __( 'Off', 'pointpro' ), '1' => __( 'On', 'pointpro' ) ),
						'sub_desc' => __('Enable or disable prefetching. If user is on homepage, then single page will load faster and if user is on single page, homepage will load faster in modern browsers.', 'pointpro' ),
						'std' => '0'
						),
					array(
						'id' => 'mts_lazy_load',
						'type' => 'button_set_hide_below',
						'title' => __('Lazy Load', 'pointpro' ),
						'options' => array( '0' => __( 'Off', 'pointpro' ), '1' => __( 'On', 'pointpro' ) ),
						'sub_desc' => __('Delay loading of images outside of viewport, until user scrolls to them.', 'pointpro' ),
						'std' => '0',
						'args' => array('hide' => 2),
						'reset_at_version' => '2.0'
						),
					array(
						'id' => 'mts_lazy_load_thumbs',
						'type' => 'button_set',
						'title' => __('Lazy load featured images', 'pointpro' ),
						'options' => array( '0' => __( 'Off', 'pointpro' ), '1' => __( 'On', 'pointpro' ) ),
						'sub_desc' => __('Enable or disable Lazy load of featured images across site.', 'pointpro' ),
						'std' => '0',
						'reset_at_version' => '2.0'
						),
					array(
						'id' => 'mts_lazy_load_content',
						'type' => 'button_set',
						'title' => __('Lazy load post content images', 'pointpro' ),
						'options' => array( '0' => __( 'Off', 'pointpro' ), '1' => __( 'On', 'pointpro' ) ),
						'sub_desc' => __('Enable or disable Lazy load of images inside post/page content.', 'pointpro' ),
						'std' => '0',
						'reset_at_version' => '2.0'
						),
					array(
						'id' => 'mts_async_js',
						'type' => 'button_set',
						'title' => __('Async JavaScript', 'pointpro' ),
						'options' => array( '0' => __( 'Off', 'pointpro' ), '1' => __( 'On', 'pointpro' ) ),
						'sub_desc' => sprintf( __('Add %s attribute to script tags to improve page download speed.', 'pointpro' ), '<code>async</code>' ),
						'std' => '1',
						'reset_at_version' => '2.0'
						),
					array(
						'id' => 'mts_remove_ver_params',
						'type' => 'button_set',
						'title' => __('Remove ver parameters', 'pointpro' ),
						'options' => array( '0' => __( 'Off', 'pointpro' ), '1' => __( 'On', 'pointpro' ) ),
						'sub_desc' => sprintf( __('Remove %s parameter from CSS and JS file calls. It may improve speed in some browsers which do not cache files having the parameter.', 'pointpro' ), '<code>ver</code>' ),
						'std' => '1',
						'reset_at_version' => '2.0'
						),
					array(
						'id' => 'mts_optimize_wc',
						'type' => 'button_set',
						'title' => __('Optimize WooCommerce scripts', 'pointpro' ),
						'options' => array( '0' => __( 'Off', 'pointpro' ), '1' => __( 'On', 'pointpro' ) ),
						'sub_desc' => __('Load WooCommerce scripts and styles only on WooCommerce pages (WooCommerce plugin must be enabled).', 'pointpro' ),
						'std' => '1',
						'reset_at_version' => '2.0'
						),
					'cache_message' => array(
						'id' => 'mts_cache_message',
						'type' => 'info',
						'title' => __('Use Cache', 'pointpro' ),
						/*
							Translators: %1$s = popup link to W3 Total Cache, %2$s = popup link to WP Super Cache
						 */
						'desc' => sprintf(
							__('A cache plugin can increase page download speed dramatically. We recommend using %1$s or %2$s.', 'pointpro' ),
							'<a href="https://community.mythemeshop.com/tutorials/article/8-make-your-website-load-faster-using-w3-total-cache-plugin/" target="_blank" title="W3 Total Cache">W3 Total Cache</a>',
							'<a href="'.admin_url( 'plugin-install.php?tab=plugin-information&plugin=wp-super-cache&TB_iframe=true&width=772&height=574' ).'" class="thickbox" title="WP Super Cache">WP Super Cache</a>'
						),
					),
				)
			);

// Hide cache message on multisite or if a chache plugin is active already
if ( is_multisite() || strstr( join( ';', get_option( 'active_plugins' ) ), 'cache' ) ) {
	unset( $sections[1]['fields']['cache_message'] );
}

$sections[] = array(
				'icon' => 'fa fa-adjust',
				'title' => __('Styling Options', 'pointpro' ),
				'desc' => __('Control the visual appearance of your theme, such as colors, layout and patterns, from here.', 'pointpro' ),
				'fields' => array(
					array(
						'id' => 'mts_color_scheme',
						'type' => 'color',
						'title' => __('Color Scheme', 'pointpro' ), 
						'sub_desc' => __('The theme comes with unlimited color schemes for your theme\'s styling.', 'pointpro' ),
						'std' => '#38B7EE'
						),
					array(
						'id' => 'mts_layout',
						'type' => 'radio_img',
						'title' => __('Layout Style', 'pointpro' ), 
						'sub_desc' => wp_kses( __('Choose the <strong>default sidebar position</strong> for your site. The position of the sidebar for individual posts can be set in the post editor.', 'pointpro' ), array( 'strong' => array() ) ),
						'options' => array(
										'cslayout' => array('img' => NHP_OPTIONS_URL.'img/layouts/cs.png'),
										'sclayout' => array('img' => NHP_OPTIONS_URL.'img/layouts/sc.png')
											),
						'std' => 'cslayout'
						),
					array(
						'id' => 'mts_background',
						'type' => 'background',
						'title' => __('Background', 'pointpro' ), 
						'sub_desc' => __('Configure background.', 'pointpro' ),
						'options' => array(
							'color'         => '',            // false to disable, not needed otherwise
							'image_pattern' => $mts_patterns, // false to disable, array of options otherwise ( required !!! )
							'image_upload'  => '',            // false to disable, not needed otherwise
							'repeat'        => array(),       // false to disable, array of options to override default ( optional )
							'attachment'    => array(),       // false to disable, array of options to override default ( optional )
							'position'      => array(),       // false to disable, array of options to override default ( optional )
							'size'          => array(),       // false to disable, array of options to override default ( optional )
							'gradient'      => '',            // false to disable, not needed otherwise
							'parallax'      => array(),       // false to disable, array of options to override default ( optional )
						),
						'std' => array(
							'color'         => '#E7E5E6',
							'use'           => 'pattern',
							'image_pattern' => 'nobg',
							'image_upload'  => '',
							//'repeat'        => 'repeat',
							//'attachment'    => 'scroll',
							//'position'      => 'left top',
							//'size'          => 'cover',
							//'gradient'      => array('from' => '#ffffff', 'to' => '#000000', 'direction' => 'horizontal' ),
							//'parallax'      => '0',
						)
					),
					array(
						'id' => 'mts_custom_css',
						'type' => 'textarea',
						'title' => __('Custom CSS', 'pointpro' ), 
						'sub_desc' => __('You can enter custom CSS code here to further customize your theme. This will override the default CSS used on your site.', 'pointpro' )
						),
					array(
						'id' => 'mts_lightbox',
						'type' => 'button_set',
						'title' => __('Lightbox', 'pointpro' ),
						'options' => array( '0' => __( 'Off', 'pointpro' ), '1' => __( 'On', 'pointpro' ) ),
						'sub_desc' => __('A lightbox is a stylized pop-up that allows your visitors to view larger versions of images without leaving the current page. You can enable or disable the lightbox here.', 'pointpro' ),
						'std' => '0'
						),
					)
				);
$sections[] = array(
				'icon' => 'fa fa-credit-card',
				'title' => __('Header', 'pointpro' ),
				'desc' => __('From here, you can control the elements of header section.', 'pointpro' ),
				'fields' => array(
					array(
						'id' => 'mts_trending_articles',
						'type' => 'button_set_hide_below',
						'title' => __('Trending', 'pointpro' ), 
						'options' => array('0' => __('Off','pointpro'),'1' => __('On','pointpro')),
						'sub_desc' => wp_kses( __('<strong>Enable or Disable</strong> a top trending section by using this check box.', 'pointpro' ), array( 'strong' => array() ) ),
						'std' => '1',
                        'args' => array('hide' => 2)
						),
						array(
						'id' => 'mts_trending_articles_cat',
						'type' => 'cats_multi_select',
						'title' => __('Trending Category(s)', 'pointpro' ), 
						'sub_desc' => __('Select a category from the drop-down menu, latest four articles from this category will be shown in trending section.', 'nhp-opts'),
						),
                        array(
						'id' => 'mts_trending_articles_num',
						'type' => 'text',
                        'class' => 'small-text',
						'title' => __('Number of posts', 'pointpro' ), 
						'sub_desc' => __('Enter the number of posts to show in the Trending Section', 'pointpro' ),
                        'std' => '4',
                        'args' => array('type' => 'number')
						),
                    array(
						'id' => 'mts_show_nav',
						'type' => 'button_set',
						'title' => __('Show Navigation Menu', 'pointpro' ), 
						'options' => array( '0' => __( 'Off', 'pointpro' ), '1' => __( 'On', 'pointpro' ) ),
						'sub_desc' => sprintf( __('Use this button to enable %s.', 'pointpro' ), '<strong>' . __( 'Navigation Menu', 'pointpro' ) . '</strong>' ),
						'std' => '1'
						),
					array(
						'id' => 'mts_header_section2',
						'type' => 'button_set',
						'title' => __('Show Logo', 'pointpro' ), 
						'options' => array( '0' => __( 'Off', 'pointpro' ), '1' => __( 'On', 'pointpro' ) ),
						'sub_desc' => wp_kses( __('Use this button to Show or Hide the <strong>Logo</strong> completely.', 'pointpro' ), array( 'strong' => array() ) ),
						'std' => '1'
						),
					)
				);
$sections[] = array(
				'icon' => 'fa fa-table',
				'title' => __('Footer', 'pointpro' ),
				'desc' => '<p class="description">' . __('From here, you can control the elements of Footer section.', 'pointpro' ) . '</p>',
				'fields' => array(
					array(
						'id' => 'mts_first_footer',
						'type' => 'button_set_hide_below',
						'title' => __('Footer Widgets', 'pointpro' ), 
						'sub_desc' => __('Enable or disable footer widget area with this option.', 'pointpro' ),
						'options' => array( '0' => __( 'Off', 'pointpro' ), '1' => __( 'On', 'pointpro' ) ),
						'std' => '0'
						),
                        array(
						'id' => 'mts_first_footer_num',
						'type' => 'button_set',
                        'class' => 'green',
						'title' => __('Footer Widgets Layout', 'pointpro' ), 
						'sub_desc' => __('Choose the number of widget areas in the <strong>footer</strong>', 'pointpro' ),
						'options' => array(
								'3' => __('3 Widgets', 'pointpro' ),
								'4' => __('4 Widgets', 'pointpro' )
							),
						'std' => '3'
						),
					array(
						'id' => 'mts_featured_carousel',
						'type' => 'button_set_hide_below',
						'title' => __('Footer Carousel', 'pointpro' ), 
						'options' => array('0' => __('Off','pointpro'),'1' => __('On','pointpro')),
						'sub_desc' => sprintf( __('<strong>Enable or Disable</strong> a Footer Carousel section by using this check box. This section will show 6 recent articles from the selected category.', 'pointpro' ) ),
						'std' => '1'
						),
                    	array(
						'id' => 'mts_featured_carousel_cat',
						'type' => 'cats_multi_select',
						'title' => __('Carousel Category(s)', 'pointpro' ), 
						'sub_desc' => __('Select a category from the menu, latest 6 articles from this category will be shown <strong>in footer carousel section</strong>.', 'pointpro' ),
						),
					array(
						'id' => 'mts_copyrights',
						'type' => 'textarea',
						'title' => __('Copyrights Text', 'pointpro' ),
						'sub_desc' => __( 'You can change or remove our link from footer and use your own custom text.', 'pointpro' ) . ( MTS_THEME_WHITE_LABEL ? '' : wp_kses( __('(You can also use your affiliate link to <strong>earn 55% of sales</strong>. Ex: <a href="https://mythemeshop.com/go/aff/aff" target="_blank">https://mythemeshop.com/?ref=username</a>)', 'pointpro' ), array( 'strong' => array(), 'a' => array( 'href' => array(), 'target' => array() ) ) ) ),
						'std' => MTS_THEME_WHITE_LABEL ? null : sprintf( __( 'Theme by %s', 'pointpro' ), '<a href="http://mythemeshop.com/" rel="nofollow">MyThemeShop</a>' )
						),
					)
				);
$sections[] = array(
				'icon' => '',
				'title' => __('Home Layout', 'pointpro'),
				'desc' => __('From here, you can control the elements of the homepage.', 'pointpro'),
				'fields' => array(
					array(
						'id'      => 'mts_homepage_layout',
						'type'    => 'layout',
						'title'   => __('Homepage Layout Manager', 'pointpro'),
						'sub_desc'    => __('Organize how you want the layout to appear on the homepage', 'pointpro'),
						'options' => array(
							'enabled'  => array(
							),
							'disabled' => array(
								'slider'    => __('Slider', 'pointpro'),
								'callout'   => __('Callout', 'pointpro'),
								'features'  => __('Features', 'pointpro'),		
								'projects'  => __('Projects', 'pointpro'),
								'employees' => __('Employees', 'pointpro'),
								'blog'  	=> __('Blog Feed', 'pointpro'),
								'gallery'  	=> __('Gallery', 'pointpro')
							)
						)
					),
				)
			);

$sections[] = array(
				'icon' => '',
				'title' => __('Slider', 'pointpro'),
				'desc' => __('From here, you can control the slider.', 'pointpro'),
				'fields' => array(
					array(
						'id'        => 'mts_custom_slider_2',
						'type'      => 'group',
						'title'     => __('Custom Slider', 'pointpro'), 
						'sub_desc'  => __('You can set up a slider with custom image and text.', 'pointpro'),
						'groupname' => __('Slider', 'pointpro'), // Group name
						'subfields' => array(
							array(
								'id' => 'mts_custom_slider_title',
								'type' => 'text',
								'title' => __('Title', 'pointpro'), 
								'sub_desc' => __('Enter the title of the slide.', 'pointpro'),
							),
							array(
								'id' => 'mts_custom_slider_image',
								'type' => 'upload',
								'title' => __('Image', 'pointpro'), 
								'sub_desc' => __('Upload or select an image for this slide.', 'pointpro'),
								'return' => 'id'
							),
							array('id' => 'mts_custom_slider_text',
								'type' => 'textarea',
								'title' => __('Slide Description', 'pointpro'), 
								'sub_desc' => __('Enter the description of the slide.', 'pointpro'),
							),
							array('id' => 'mts_custom_slider_url',
								'type' => 'text',
								'title' => __('Slide URL', 'pointpro'), 
								'sub_desc' => __('Enter the URL of the slide.', 'pointpro'),
							)
						),
					),
				)
			);

$sections[] = array(
			'icon' => '',
			'title' => __('Callout', 'pointpro'),
			'desc' => __('Manage your callout section from here.', 'pointpro'),
			'fields' => array(
				array(
					'id' => 'mts_homepage_callout_title',
					'type' => 'text',
					'title' => __( 'Title', 'pointpro' ),
					'sub_desc' => __( 'Section Title', 'pointpro' ),
				),
				array(
					'id' => 'mts_homepage_callout_description',
					'type' => 'textarea',
					'title' => __('Description', 'pointpro'), 
				),
				array('id' => 'mts_homepage_callout_button_label',
					'type' => 'text',
					'title' => __('Button Label', 'pointpro'), 
					'sub_desc' => __('Slide button text', 'pointpro'),
				), 
				array('id' => 'mts__homepage_callout_button_link',
					'type' => 'text',
					'title' => __('Button Link', 'pointpro'), 
					'sub_desc' => __('Insert a link URL for the slide button', 'pointpro'),
					'std' => '#'
				),
			)
		);

$sections[] = array(
				'icon' => '',
				'title' => __('Features', 'pointpro'),
				'desc' => __('Add your homepage features from here', 'pointpro'),
				'fields' => array(
					array(
						'id' => 'mts_homepage_features_title',
						'type' => 'text',
						'title' => __( 'Title', 'pointpro' ),
						'sub_desc' => __( 'Section Title', 'pointpro' ),
						'std' => 'Features'
					),
					array(
						'id' => 'mts_homepage_features_columns',
						'type' => 'button_set',
						'title' => __('No of Columns', 'pointpro'), 
						'options' => array('0' => __('3 Columns', 'pointpro'),'1' => __('4 Columns', 'pointpro')),
						'sub_desc' => __('Choose column layout.', 'pointpro'),
						'std' => '0',
						'class' => 'green'
						),
					array(
						'id' => 'mts_homepage_features',
						'title' => __('Features', 'pointpro'),
						'sub_desc' => __( 'Add "features" to your homepage to promote specifics of your company, service, brand, etc.', 'pointpro' ),
						'type' => 'group',
						'groupname' => __('Feature', 'pointpro'), // Group name
						'subfields' => array(
							array(
								'id' => 'mts_homepage_feature_title',
								'type' => 'text',
								'title' => __('Title', 'pointpro'), 
							),
							array(
								'id' => 'mts_homepage_feature_icon',
								'type' => 'icon_select',
								'title' => __('Icon', 'pointpro')
							),
							array(
								'id' => 'mts_homepage_feature_description',
								'type' => 'textarea',
								'title' => __('Description', 'pointpro'), 
							),
						),
					)
				)
			);

$sections[] = array(
			'icon' => '',
			'title' => __('Projects', 'pointpro'),
			'desc' => __('Manage the content displayed on the Projects section. You can manage portfolio items in the <a target="_blank" href="'.admin_url("edit.php?post_type=portfolio").'">Projects</a> section of your WordPress dashboard.', 'pointpro'),
			'fields' => array(
				array(
					'id' => 'mts_homepage_projects_title',
					'type' => 'text',
					'title' => __( 'Title', 'pointpro' ),
					'sub_desc' => __( 'Section Title', 'pointpro' ),
					'std' => 'Projects'
				),
				array(
					'id' => 'mts_projects_layout',
					'type' => 'button_set',
					'title' => __('No of Columns', 'pointpro'), 
					'options' => array('0' => __('3 Columns', 'pointpro'),'1' => __('4 Columns', 'pointpro')),
					'sub_desc' => __('Choose column layout.', 'pointpro'),
					'std' => '1',
					'class' => 'green'
					),
				array(
					'id' => 'mts_projects_count_home',
					'type' => 'text',
					'title' => __('No. of Projects - Homepage', 'pointpro'),
					'sub_desc' => __('Enter the total number of projects you want to show on homepage.', 'pointpro'),
					'validate' => 'numeric',
					'std' => '4',
					'class' => 'small-text'
				),
				array(
					'id' => 'mts_projects_count',
					'type' => 'text',
					'class' => 'small-text',
					'title' => __( 'No. of Projects - Projects page', 'pointpro' ),
					'sub_desc' => __( 'Enter the number of projects you want to show per page on Projects page', 'pointpro' ),
					'std' => '12',
					'args' => array('type' => 'number')
				),
				array(
					'id' => 'mts_project_pagenavigation_type',
					'type' => 'radio',
					'title' => __('Pagination Type - Projects page', 'pointpro'),
					'sub_desc' => __('Select pagination type for projects page.', 'pointpro'),
					'options' => array(
						'0'=> __('Default (Next / Previous)', 'pointpro'),
						'1' => __('Numbered (1 2 3 4...)', 'pointpro')
						),
					'std' => '1'
				)
			)
		);

$sections[] = array(
			'icon' => '',
			'title' => __('Team', 'pointpro'),
			'desc' => __('Manage your team members and their contact information.', 'pointpro'),
			'fields' => array(
				array(
					'id' => 'mts_homepage_team_title',
					'type' => 'text',
					'title' => __( 'Title', 'pointpro' ),
					'sub_desc' => __( 'Section Title', 'pointpro' ),
					'std' => 'Our Team'
				),
				array(
					'id' => 'mts_homepage_team_col',
					'type' => 'button_set',
					'title' => __('No of Columns', 'pointpro'), 
					'options' => array('0' => '3 Columns','1' => '4 Columns'),
					'sub_desc' => __('Choose column layout.', 'pointpro'),
					'std' => '0',
					'class' => 'green'
					),
				array(
					'id' => 'mts_homepage_team',
					'title' => __('Team', 'pointpro'),
					'sub_desc' => __( 'Add employees or team members for display on the homepage.', 'pointpro' ),
					'type' => 'group',
					'groupname' => __('Team Member', 'pointpro'), // Group name
					'subfields' => array(
						array(
							'id' => 'mts_homepage_team_name',
							'type' => 'text',
							'title' => __('Name', 'pointpro'), 
						),
						array(
							'id' => 'mts_homepage_team_member_job',
							'type' => 'text',
							'title' => __('Job', 'pointpro'), 
						),
						array(
							'id' => 'mts_homepage_team_image',
							'type' => 'upload',
							'title' => __('Photo', 'pointpro'),
							'desc' => __('Recommended size: 75x75px', 'pointpro' )
						),
						array(
							'id' => 'mts_homepage_team_info',
							'type' => 'textarea',
							'title' => __('Info', 'pointpro'), 
						),
						array(
							'id' => 'mts_homepage_team_facebook',
							'type' => 'text',
							'title' => __('Facebook', 'pointpro'), 
						),
						array(
							'id' => 'mts_homepage_team_twitter',
							'type' => 'text',
							'title' => __('Twitter', 'pointpro'), 
						),
						array(
							'id' => 'mts_homepage_team_google',
							'type' => 'text',
							'title' => __('Google Plus', 'pointpro'), 
						),
						array(
							'id' => 'mts_homepage_team_instagram',
							'type' => 'text',
							'title' => __('Instagram', 'pointpro'), 
						),
			        ),
			    ),
			)
		);

$sections[] = array(
			'icon' => '',
			'title' => __('Blog Feed', 'pointpro'),
			'desc' => __('Control blog settings from here.', 'pointpro'),
			'fields' => array(
				array(
					'id' => 'mts_homepage_blog_title',
					'type' => 'text',
					'title' => __( 'Title', 'pointpro' ),
					'sub_desc' => __( 'Section Title', 'pointpro' ),
					'std' => __('Blog Feed','pointpro'),
				),
				array(
					'id' => 'mts_home_blog_col',
					'type' => 'button_set',
					'title' => __('No of Columns', 'pointpro'), 
					'options' => array('0' => '3 Columns','1' => '4 Columns'),
					'sub_desc' => __('Choose column layout.', 'pointpro'),
					'std' => '1',
					'class' => 'green'
					),
				array(
					'id' => 'mts_blog_count_home',
					'type' => 'text',
					'title' => __('No. of Posts - Homepage', 'pointpro'),
					'sub_desc' => __('Enter the total number of blog posts you want to show on homepage.', 'pointpro'),
					'validate' => 'numeric',
					'std' => '4',
					'class' => 'small-text'
				),
			)
		);

$sections[] = array(
			'icon' => '',
			'title' => __('Gallery', 'pointpro'),
			'desc' => __('Manage the content displayed on the gallery section. You can manage gallery items in the <a target="_blank" href="'.admin_url("edit.php?post_type=gallery").'">Gallery</a> section of your WordPress dashboard.', 'pointpro'),
			'fields' => array(
				array(
					'id' => 'mts_homepage_gallery_title',
					'type' => 'text',
					'title' => __( 'Title', 'pointpro' ),
					'sub_desc' => __( 'Section Title', 'pointpro' ),
					'std' => __('Gallery','pointpro'),
				),
				array(
					'id' => 'mts_gallery_layout',
					'type' => 'button_set',
					'title' => __('No of Columns', 'pointpro'), 
					'options' => array('0' => '3 Columns','1' => '4 Columns'),
					'sub_desc' => __('Choose column layout.', 'pointpro'),
					'std' => '0',
					'class' => 'green'
					),
				array(
					'id' => 'mts_gallery_count_home',
					'type' => 'text',
					'title' => __('No. of Gallery - Homepage', 'pointpro'),
					'sub_desc' => __('Enter the total number of gallery posts you want to show on homepage.', 'pointpro'),
					'validate' => 'numeric',
					'std' => '6',
					'class' => 'small-text',
					'args' => array('type' => 'number')
				),
				array(
					'id' => 'mts_gallery_count',
					'type' => 'text',
					'class' => 'small-text',
					'title' => __( 'No. of Gallery - Gallery page', 'pointpro' ),
					'sub_desc' => __( 'Enter the number of gallery posts you want to show per page on gallery page', 'pointpro' ),
					'std' => '9',
					'args' => array('type' => 'number')
				),
				array(
					'id' => 'mts_gallery_pagenavigation_type',
					'type' => 'radio',
					'title' => __('Pagination Type - Gallery page', 'pointpro'),
					'sub_desc' => __('Select pagination type for gallery page.', 'pointpro'),
					'options' => array(
						'0'=> __('Default (Next / Previous)','pointpro'),
						'1' => __('Numbered (1 2 3 4...)','pointpro')
						),
					'std' => '1'
				)
			)
		);

$sections[] = array(
			'icon' => '',
			'title' => __('Blog Page', 'pointpro' ),
			'desc' => __('From here, you can control the elements of the Blog page.', 'pointpro' ),
			'fields' => array(
				array(
					'id' => 'mts_featured_slider',
					'type' => 'button_set_hide_below',
					'title' => __('Featured Posts', 'pointpro' ), 
					'options' => array('0' => __('Off','pointpro'),'1' => __('On','pointpro')),
					'sub_desc' => wp_kses( __('<strong>Enable or Disable</strong> blog featured section with this button. The featured area will show recent articles from the selected categories.', 'pointpro' ), array( 'strong' => array() ) ),
					'std' => '0',
                    'args' => array('hide' => 1)
					),
					array(
					'id' => 'mts_featured_slider_cat',
					'type' => 'cats_multi_select',
					'title' => __('Featured Category(s)', 'pointpro' ), 
					'sub_desc' => wp_kses( __('Select a category from the drop-down menu, latest articles from this category will be shown <strong>in the slider</strong>.', 'pointpro' ), array( 'strong' => array() ) ),
					),
                array(
                    'id'        => 'mts_featured_categories',
                    'type'      => 'group',
                    'title'     => __('Featured Categories', 'pointpro' ), 
                    'sub_desc'  => __('Select categories appearing on the homepage.', 'pointpro' ),
                    'groupname' => __('Section', 'pointpro' ), // Group name
                    'subfields' => 
                        array(
                            array(
                                'id' => 'mts_featured_category',
        						'type' => 'cats_select',
        						'title' => __('Category', 'pointpro' ), 
        						'sub_desc' => __('Select a category or the latest posts for this section', 'pointpro' ),
								'std' => 'latest',
                                'args' => array('include_latest' => 1, 'hide_empty' => 0),
        						),
                            array(
                                'id' => 'mts_featured_category_postsnum',
        						'type' => 'text',
                                'class' => 'small-text',
        						'title' => __('Number of posts', 'pointpro' ), 
        						'sub_desc' => sprintf(__('Enter the number of posts to show in this section.<br/><strong>For Latest Posts</strong>, this setting will be ignored, and number set in <a href="%s" target="_blank">Settings&nbsp;&gt;&nbsp;Reading</a> will be used instead.', 'pointpro' ), admin_url('options-reading.php')),
                                'std' => '3',
                                'args' => array('type' => 'number')
        						),
                        ),
        				'std' => array(
        					'1' => array(
        						'group_title' => '',
        						'group_sort' => '1',
        						'mts_featured_category' => 'latest',
        						'mts_featured_category_postsnum' => get_option('posts_per_page')
        					)
        				)
                    ),
				array(
                    'id'       => 'mts_home_headline_meta_info',
                    'type'     => 'layout',
                    'title'    => __('HomePage Post Meta Info', 'pointpro' ),
                    'sub_desc' => __('Organize how you want the post meta info to appear on the homepage', 'pointpro' ),
                    'options'  => array(
                        'enabled'  => array(
                            'author'   => __('Author Name', 'pointpro' ),
                            'date'     => __('Date', 'pointpro' ),
                        ),
                        'disabled' => array(
                        	'comment'  => __('Comment Count', 'pointpro' )
                        )
                    ),
                    'std'  => array(
                        'enabled'  => array(
                            'author'   => __('Author Name', 'pointpro' ),
                            'date'     => __('Date', 'pointpro' ),
                        ),
                        'disabled' => array(
                        	'comment'  => __('Comment Count', 'pointpro' )
                        )
                    )
                ),
				array(
                    'id' => 'mts_pagenavigation_type',
                    'type' => 'radio',
                    'title' => __('Pagination Type', 'pointpro' ),
                    'sub_desc' => __('Select pagination type.', 'pointpro' ),
                    'options' => array(
                                    '0'=> __('Default (Next / Previous)', 'pointpro' ), 
                                    '1' => __('Numbered (1 2 3 4...)', 'pointpro' ), 
                                    '2' => __('AJAX (Load More Button)', 'pointpro' ),
                                    '3' => __('AJAX (Auto Infinite Scroll)', 'pointpro' )
                                ),
                    'std' => '1'
                ),
                array(
                    'id' => 'mts_full_posts',
                    'type' => 'button_set',
                    'title' => __('Posts on blog pages', 'pointpro' ), 
					'options' => array('0' => __('Excerpts', 'pointpro'),'1' => __('Full posts', 'pointpro')),
					'sub_desc' => __('Show post excerpts or full posts on the homepage and other archive pages.', 'pointpro' ),
					'std' => '0',
                    'class' => 'green'
                ),
            )
		);	
$sections[] = array(
				'icon' => '',
				'title' => __('Single Posts', 'pointpro' ),
				'desc' => __('From here, you can control the appearance and functionality of your single posts page.', 'pointpro' ),
				'fields' => array(
					array(
						'id'       => 'mts_single_post_layout',
                        'type'     => 'layout2',
                        'title'    => __('Single Post Layout', 'pointpro' ),
                        'sub_desc' => __('Customize the look of single posts', 'pointpro' ),
                        'options'  => array(
                            'enabled'  => array(
                                'content'   => array(
                                	'label' 	=> __('Post Content', 'pointpro' ),
                                	'subfields'	=> array(
                                		
                                	)
                                ),
                                'related'   => array(
                                	'label' 	=> __('Related Posts', 'pointpro' ),
                                	'subfields'	=> array(
										array(
											'id' => 'mts_related_posts_taxonomy',
											'type' => 'button_set',
											'title' => __('Related Posts Taxonomy', 'pointpro' ) ,
											'options' => array(
												'tags' => __( 'Tags', 'pointpro' ),
												'categories' => __( 'Categories', 'pointpro' )
											) ,
											'class' => 'green',
											'sub_desc' => __('Related Posts based on tags or categories.', 'pointpro' ) ,
											'std' => 'categories'
										),
										array(
											'id' => 'mts_related_postsnum',
											'type' => 'text',
											'class' => 'small-text',
											'title' => __('Number of related posts', 'pointpro' ) ,
											'sub_desc' => __('Enter the number of posts to show in the related posts section.', 'pointpro' ) ,
											'std' => '4',
											'args' => array(
												'type' => 'number'
											)
										),
										array(
											'id' => 'mts_related_author',
											'type' => 'button_set',
											'title' => __('Author Name', 'pointpro' ), 
											'options' => array('0' => __('Off','pointpro'),'1' => __('On','pointpro')),
											'sub_desc' => __('Show author name in related posts', 'pointpro' ),
											'std' => '1',
											'reset_at_version' => '2.0'
										),
										array(
											'id' => 'mts_related_date',
											'type' => 'button_set',
											'title' => __('Publish Date', 'pointpro' ), 
											'options' => array('0' => __('Off','pointpro'),'1' => __('On','pointpro')),
											'sub_desc' => __('Show Article Publishing date in related posts', 'pointpro' ),
											'std' => '1',
											'reset_at_version' => '2.0'
										),
                                	)
                                ),
                                'author'   => array(
                                	'label' 	=> __('Author Box', 'pointpro' ),
                                	'subfields'	=> array(

                                	)
                                ),
                            ),
                            'disabled' => array(
                            	'tags'   => array(
                                	'label' 	=> __('Tags', 'pointpro' ),
                                	'subfields'	=> array(
                                	)
                                ),
                            )
                        )
                    ),
					array(
	                    'id'       => 'mts_single_headline_meta_info',
	                    'type'     => 'layout',
	                    'title'    => __('Meta Info to Show', 'pointpro' ),
	                    'sub_desc' => __('Organize how you want the post meta info to appear', 'pointpro' ),
	                    'options'  => array(
	                        'enabled'  => array(
	                            'author'   => __('Author Name', 'pointpro' ),
	                            'date'     => __('Date', 'pointpro' ),
	                            'category' => __('Categories', 'pointpro' ),
	                            'comment'  => __('Comment Count', 'pointpro' )
	                        ),
	                        'disabled' => array(
	                        )
	                    ),
	                    'std'  => array(
	                        'enabled'  => array(
	                            'author'   => __('Author Name', 'pointpro' ),
	                            'date'     => __('Date', 'pointpro' ),
	                            'category' => __('Categories', 'pointpro' ),
	                            'comment'  => __('Comment Count', 'pointpro' )
	                        ),
	                        'disabled' => array(
	                        )
	                    )
	                ),
					array(
						'id' => 'mts_breadcrumb',
						'type' => 'button_set',
						'title' => __('Breadcrumbs', 'pointpro' ), 
						'options' => array('0' => __('Off','pointpro'),'1' => __('On','pointpro')),
						'sub_desc' => __('Breadcrumbs are a great way to make your site more user-friendly. You can enable them by checking this box.', 'pointpro' ),
						'std' => '1'
						),
					array(
						'id' => 'mts_author_comment',
						'type' => 'button_set',
						'title' => __('Highlight Author Comment', 'pointpro' ), 
						'options' => array( '0' => __( 'Off', 'pointpro' ), '1' => __( 'On', 'pointpro' ) ),
						'sub_desc' => __('Use this button to highlight author comments.', 'pointpro' ),
						'std' => '1'
						),
					array(
						'id' => 'mts_comment_date',
						'type' => 'button_set',
						'title' => __('Date in Comments', 'pointpro' ), 
						'options' => array( '0' => __( 'Off', 'pointpro' ), '1' => __( 'On', 'pointpro' ) ),
						'sub_desc' => __('Use this button to show the date for comments.', 'pointpro' ),
						'std' => '1'
						),
					)
				);
$sections[] = array(
				'icon' => '',
				'title' => __('Social Buttons', 'pointpro' ),
				'desc' => __('Enable or disable social sharing buttons on single posts using these buttons.', 'pointpro' ),
				'fields' => array(
					array(
						'id' => 'mts_social_button_layout',
						'type' => 'radio_img',
						'title' => __('Social Sharing Buttons Layout', 'pointpro' ),
						'sub_desc' => wp_kses( __('Choose default <strong>social</strong> or modern <strong>social sharing buttons</strong> layout for your site. ', 'pointpro' ), array( 'strong' => array() ) ),
						'options' => array(
							'default' => array('img' => NHP_OPTIONS_URL.'img/layouts/default-social.jpg'),
							'modern' => array('img' => NHP_OPTIONS_URL.'img/layouts/modern-social.jpg')
						),
						'std' => 'default',
						'reset_at_version' => '2.1.3'
					),
					array(
						'id' => 'mts_social_button_position',
						'type' => 'button_set',
						'title' => __('Social Sharing Buttons Position', 'pointpro' ), 
						'options' => array('top' => __('Above Content', 'pointpro' ), 'bottom' => __('Below Content', 'pointpro' ), 'floating' => __('Floating', 'pointpro' )),
						'sub_desc' => __('Choose position for Social Sharing Buttons.', 'pointpro' ),
						'std' => 'floating',
						'class' => 'green'
					),
					array(
						'id' => 'mts_social_buttons_on_pages',
						'type' => 'button_set',
						'title' => __('Social Sharing Buttons on Pages', 'pointpro' ), 
						'options' => array('0' => __('Off', 'pointpro' ), '1' => __('On', 'pointpro' )),
						'sub_desc' => __('Enable the sharing buttons for pages too, not just posts.', 'pointpro' ),
						'std' => '0',
					),
					array(
                        'id'       => 'mts_social_buttons',
                        'type'     => 'layout',
                        'title'    => __('Social Media Buttons', 'pointpro' ),
                        'sub_desc' => __('Organize how you want the social sharing buttons to appear on single posts', 'pointpro' ),
                        'options'  => array(
                            'enabled'  => array(
                            	'facebookshare'   => __('Facebook Share', 'pointpro' ),
                            	'facebook'  => __('Facebook Like', 'pointpro' ),
                                'twitter'   => __('Twitter', 'pointpro' ),
                                'gplus'     => __('Google Plus', 'pointpro' ),
                                'pinterest' => __('Pinterest', 'pointpro' ),
                            ),
                            'disabled' => array(
                            	'linkedin'  => __('LinkedIn', 'pointpro' ),
                                'stumble'   => __('StumbleUpon', 'pointpro' ),
                                'reddit'   => __('Reddit', 'pointpro' ),
                            )
                        ),
                        'std'  => array(
                            'enabled'  => array(
                            	'facebookshare'   => __('Facebook Share', 'pointpro' ),
                            	'facebook'  => __('Facebook Like', 'pointpro' ),
                                'twitter'   => __('Twitter', 'pointpro' ),
                                'gplus'     => __('Google Plus', 'pointpro' ),
                                'pinterest' => __('Pinterest', 'pointpro' ),
                            ),
                            'disabled' => array(
                            	'linkedin'  => __('LinkedIn', 'pointpro' ),
                                'stumble'   => __('StumbleUpon', 'pointpro' ),
                                'reddit'   => __('Reddit', 'pointpro' ),
                            )
                        ),
                        'reset_at_version' => '2.1.1'
                    ),
				)
			);
$sections[] = array(
				'icon' => 'fa fa-bar-chart-o',
				'title' => __('Ad Management', 'pointpro' ),
				'desc' => __('Now, ad management is easy with our options panel. You can control everything from here, without using separate plugins.', 'pointpro' ),
				'fields' => array(
					array(
						'id' => 'mts_header_adcode',
						'type' => 'textarea',
						'title' => __('Header Banner', 'pointpro'), 
						'sub_desc' => __('Paste your Adsense, BSA or other ad code here to show ads below header on single posts.', 'pointpro'),
					),
					array(
						'id' => 'mts_posttopleft_adcode',
						'type' => 'textarea',
						'title' => __('Below Header Right Side', 'pointpro'), 
						'sub_desc' => __('Show call to action button to the right side of header Ad. (This button will be shown only if you are showing Header Ad.)', 'pointpro'),
						'std' => '<a href="button link" class="header-button">Button Text!</a> Submit  original article and get paid. <a href="#">Find out</a> More'
					),
					array(
						'id' => 'mts_posttop_adcode',
						'type' => 'textarea',
						'title' => __('Below Post Title', 'pointpro' ), 
						'sub_desc' => __('Paste your Adsense, BSA or other ad code here to show ads below your article title on single posts.', 'pointpro' )
						),
					array(
						'id' => 'mts_posttop_adcode_time',
						'type' => 'text',
						'title' => __('Show After X Days', 'pointpro' ), 
						'sub_desc' => __('Enter the number of days after which you want to show the Below Post Title Ad. Enter 0 to disable this feature.', 'pointpro' ),
						'validate' => 'numeric',
						'std' => '0',
						'class' => 'small-text',
                        'args' => array('type' => 'number')
						),
					array(
						'id' => 'mts_postend_adcode',
						'type' => 'textarea',
						'title' => __('Below Post Content', 'pointpro' ), 
						'sub_desc' => __('Paste your Adsense, BSA or other ad code here to show ads below the post content on single posts.', 'pointpro' )
						),
					array(
						'id' => 'mts_postend_adcode_time',
						'type' => 'text',
						'title' => __('Show After X Days', 'pointpro' ), 
						'sub_desc' => __('Enter the number of days after which you want to show the Below Post Title Ad. Enter 0 to disable this feature.', 'pointpro' ),
						'validate' => 'numeric',
						'std' => '0',
						'class' => 'small-text',
                        'args' => array('type' => 'number')
						),
					)
				);
$sections[] = array(
				'icon' => 'fa fa-columns',
				'title' => __('Sidebars', 'pointpro' ),
				'desc' => __('Now you have full control over the sidebars. Here you can manage sidebars and select one for each section of your site, or select a custom sidebar on a per-post basis in the post editor.', 'pointpro' ),
                'fields' => array(
                    array(
                        'id'        => 'mts_custom_sidebars',
                        'type'      => 'group', //doesn't need to be called for callback fields
                        'title'     => __('Custom Sidebars', 'pointpro' ), 
                        'sub_desc'  => wp_kses( __('Add custom sidebars. <strong style="font-weight: 800;">You need to save the changes to use the sidebars in the dropdowns below.</strong><br />You can add content to the sidebars in Appearance &gt; Widgets.', 'pointpro' ), array( 'strong' => array(), 'br' => '' ) ),
                        'groupname' => __('Sidebar', 'pointpro' ), // Group name
                        'subfields' => 
                            array(
                                array(
                                    'id' => 'mts_custom_sidebar_name',
            						'type' => 'text',
            						'title' => __('Name', 'pointpro' ), 
            						'sub_desc' => __('Example: Homepage Sidebar', 'pointpro' )
            						),	
                                array(
                                    'id' => 'mts_custom_sidebar_id',
            						'type' => 'text',
            						'title' => __('ID', 'pointpro' ), 
            						'sub_desc' => __('Enter a unique ID for the sidebar. Use only alphanumeric characters, underscores (_) and dashes (-), eg. "sidebar-home"', 'pointpro' ),
            						'std' => 'sidebar-'
            						),
                            ),
                        ),
                    array(
						'id' => 'mts_sidebar_for_blog',
						'type' => 'sidebars_select',
						'title' => __('Blog Page', 'pointpro' ), 
						'sub_desc' => __('Select a sidebar for the Blog Page.', 'pointpro' ),
                        'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar')),
                        'std' => ''
						),
                    array(
						'id' => 'mts_sidebar_for_post',
						'type' => 'sidebars_select',
						'title' => __('Single Post', 'pointpro' ), 
						'sub_desc' => __('Select a sidebar for the single posts. If a post has a custom sidebar set, it will override this.', 'pointpro' ),
                        'args' => array('exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar')),
                        'std' => ''
						),
                    array(
						'id' => 'mts_sidebar_for_page',
						'type' => 'sidebars_select',
						'title' => __('Single Page', 'pointpro' ), 
						'sub_desc' => __('Select a sidebar for the single pages. If a page has a custom sidebar set, it will override this.', 'pointpro' ),
                        'args' => array('exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar')),
                        'std' => ''
						),
                    array(
						'id' => 'mts_sidebar_for_archive',
						'type' => 'sidebars_select',
						'title' => __('Archive', 'pointpro' ), 
						'sub_desc' => __('Select a sidebar for the archives. Specific archive sidebars will override this setting (see below).', 'pointpro' ),
                        'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar')),
                        'std' => ''
						),
                    array(
						'id' => 'mts_sidebar_for_category',
						'type' => 'sidebars_select',
						'title' => __('Category Archive', 'pointpro' ), 
						'sub_desc' => __('Select a sidebar for the category archives.', 'pointpro' ),
                        'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar')),
                        'std' => ''
						),
                    array(
						'id' => 'mts_sidebar_for_tag',
						'type' => 'sidebars_select',
						'title' => __('Tag Archive', 'pointpro' ), 
						'sub_desc' => __('Select a sidebar for the tag archives.', 'pointpro' ),
                        'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar')),
                        'std' => ''
						),
                    array(
						'id' => 'mts_sidebar_for_date',
						'type' => 'sidebars_select',
						'title' => __('Date Archive', 'pointpro' ), 
						'sub_desc' => __('Select a sidebar for the date archives.', 'pointpro' ),
                        'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar')),
                        'std' => ''
						),
                    array(
						'id' => 'mts_sidebar_for_author',
						'type' => 'sidebars_select',
						'title' => __('Author Archive', 'pointpro' ), 
						'sub_desc' => __('Select a sidebar for the author archives.', 'pointpro' ),
                        'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar')),
                        'std' => ''
						),
                    array(
						'id' => 'mts_sidebar_for_search',
						'type' => 'sidebars_select',
						'title' => __('Search', 'pointpro' ), 
						'sub_desc' => __('Select a sidebar for the search results.', 'pointpro' ),
                        'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar')),
                        'std' => ''
						),
                    array(
						'id' => 'mts_sidebar_for_notfound',
						'type' => 'sidebars_select',
						'title' => __('404 Error', 'pointpro' ), 
						'sub_desc' => __('Select a sidebar for the 404 Not found pages.', 'pointpro' ),
                        'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar')),
                        'std' => ''
						),
                    
                    array(
						'id' => 'mts_sidebar_for_shop',
						'type' => 'sidebars_select',
						'title' => __('Shop Pages', 'pointpro' ), 
						'sub_desc' => wp_kses( __('Select a sidebar for Shop main page and product archive pages (WooCommerce plugin must be enabled). Default is <strong>Shop Page Sidebar</strong>.', 'pointpro' ), array( 'strong' => array() ) ),
                        'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar')),
                        'std' => 'shop-sidebar'
						),
                    array(
						'id' => 'mts_sidebar_for_product',
						'type' => 'sidebars_select',
						'title' => __('Single Product', 'pointpro' ), 
						'sub_desc' => wp_kses( __('Select a sidebar for single products (WooCommerce plugin must be enabled). Default is <strong>Single Product Sidebar</strong>.', 'pointpro' ), array( 'strong' => array() ) ),
                        'args' => array('allow_nosidebar' => false, 'exclude' => array('sidebar', 'footer-first', 'footer-first-2', 'footer-first-3', 'footer-first-4', 'footer-second', 'footer-second-2', 'footer-second-3', 'footer-second-4', 'widget-header','shop-sidebar', 'product-sidebar')),
                        'std' => 'product-sidebar'
						),
                    ),
				);
//$sections[] = array(
//				'icon' => NHP_OPTIONS_URL.'img/glyphicons/fontsetting.png',
//				'title' => __('Fonts', 'pointpro' ),
//				'desc' => __('<div class="controls">You can find theme font options under the Appearance Section named <a href="themes.php?page=typography"><b>Theme Typography</b></a>, which will allow you to configure the typography used on your site.<br></div></p>', 'pointpro' ),
//				);
$sections[] = array(
	'icon' => 'fa fa-list-alt',
	'title' => __('Navigation', 'pointpro' ),
	'desc' => '<p class="description"><div class="controls">' . sprintf( __('Navigation settings can now be modified from the %s.', 'pointpro' ), '<a href="nav-menus.php"><b>' . __( 'Menus Section', 'pointpro' ) . '</b></a>' ) . '<br></div></p>'
);
				
				
	$tabs = array();
    
    $args['presets'] = array();
	$args['show_translate'] = false;
    include('theme-presets.php');
    
	global $NHP_Options;
	$NHP_Options = new NHP_Options($sections, $args, $tabs);

}//function
add_action('init', 'setup_framework_options', 0);

/*
 * 
 * Custom function for the callback referenced above
 *
 */
function my_custom_field($field, $value){
	print_r($field);
	print_r($value);

}//function

/*
 * 
 * Custom function for the callback validation referenced above
 *
 */
function validate_callback_function($field, $value, $existing_value){
	
	$error = false;
	$value =  'just testing';
	/*
	do your validation
	
	if(something){
		$value = $value;
	}elseif(somthing else){
		$error = true;
		$value = $existing_value;
		$field['msg'] = 'your custom error message';
	}
	*/
	$return['value'] = $value;
	if($error == true){
		$return['error'] = $field;
	}
	return $return;
	
}//function

/*--------------------------------------------------------------------
 * 
 * Default Font Settings
 *
 --------------------------------------------------------------------*/
if(function_exists('mts_register_typography')) { 
  mts_register_typography(array(
    'navigation_font' => array(
      'preview_text' => __('Navigation Font', 'pointpro'),
      'preview_color' => 'light',
      'font_family' => 'Droid Sans',
      'font_variant' => '700',
      'font_size' => '16px',
      'font_color' => '#2A2A2A',
      'css_selectors' => '.menu li, .menu li a',
      'additional_css' => 'text-transform: uppercase;'
    ),
    'home_title_font' => array(
      'preview_text' => __('Home Article Title', 'pointpro'),
      'preview_color' => 'light',
      'font_family' => 'Droid Sans',
      'font_size' => '18px',
	  'font_variant' => '700',
      'font_color' => '#2A2A2A',
      'css_selectors' => '.latestPost .title a'
    ),
    'single_title_font' => array(
      'preview_text' => __('Single Article Title', 'pointpro'),
      'preview_color' => 'light',
      'font_family' => 'Droid Sans',
      'font_size' => '32px',
	  'font_variant' => '700',
      'font_color' => '#2A2A2A',
      'css_selectors' => '.single-title',
      'additional_css' => 'text-transform: uppercase;'
    ),
    'content_font' => array(
      'preview_text' => __('Content Font', 'pointpro'),
      'preview_color' => 'light',
      'font_family' => 'Droid Sans',
      'font_size' => '14px',
	  'font_variant' => 'normal',
      'font_color' => '#555',
      'css_selectors' => 'body'
    ),
    'sidebar_title_font' => array(
      'preview_text' => __('Sidebar Title Font', 'pointpro'),
      'preview_color' => 'light',
      'font_family' => 'Droid Sans',
      'font_variant' => '700',
      'font_size' => '20px',
      'font_color' => '#2A2A2A',
      'css_selectors' => '.widget h3'
    ),
	'sidebar_font' => array(
      'preview_text' => __('Sidebar Font', 'pointpro'),
      'preview_color' => 'light',
      'font_family' => 'Droid Sans',
      'font_variant' => 'normal',
      'font_size' => '14px',
      'font_color' => '#444444',
      'css_selectors' => '#sidebar .widget'
    ),
	'footer_font' => array(
      'preview_text' => __('Footer Font', 'pointpro'),
      'preview_color' => 'light',
      'font_family' => 'Droid Sans',
      'font_variant' => 'normal',
      'font_size' => '14px',
      'font_color' => '#444444',
      'css_selectors' => '.footer-widgets'
    ),
    'h1_headline' => array(
      'preview_text' => __('Content H1', 'pointpro'),
      'preview_color' => 'light',
      'font_family' => 'Droid Sans',
      'font_variant' => '700',
      'font_size' => '28px',
      'font_color' => '#2A2A2A',
      'css_selectors' => 'h1'
    ),
	'h2_headline' => array(
      'preview_text' => __('Content H2', 'pointpro'),
      'preview_color' => 'light',
      'font_family' => 'Droid Sans',
      'font_variant' => '700',
      'font_size' => '24px',
      'font_color' => '#2A2A2A',
      'css_selectors' => 'h2'
    ),
	'h3_headline' => array(
      'preview_text' => __('Content H3', 'pointpro'),
      'preview_color' => 'light',
      'font_family' => 'Droid Sans',
      'font_variant' => '700',
      'font_size' => '22px',
      'font_color' => '#2A2A2A',
      'css_selectors' => 'h3'
    ),
	'h4_headline' => array(
      'preview_text' => __('Content H4', 'pointpro'),
      'preview_color' => 'light',
      'font_family' => 'Droid Sans',
      'font_variant' => '700',
      'font_size' => '20px',
      'font_color' => '#2A2A2A',
      'css_selectors' => 'h4'
    ),
	'h5_headline' => array(
      'preview_text' => __('Content H5', 'pointpro'),
      'preview_color' => 'light',
      'font_family' => 'Droid Sans',
      'font_variant' => '700',
      'font_size' => '18px',
      'font_color' => '#2A2A2A',
      'css_selectors' => 'h5'
    ),
	'h6_headline' => array(
      'preview_text' => __('Content H6', 'pointpro'),
      'preview_color' => 'light',
      'font_family' => 'Droid Sans',
      'font_variant' => '700',
      'font_size' => '16px',
      'font_color' => '#2A2A2A',
      'css_selectors' => 'h6'
    )
  ));
}

?>