<?php
$mts_options = get_option(MTS_THEME_NAME);

if ( isset( $mts_options['mts_custom_slider_2'] ) && !empty( $mts_options['mts_custom_slider_2'] ) ) { ?>
	<div class="primary-slider-container clearfix loading">
		<div id="slider" class="primary-slider">
			<?php foreach( $mts_options['mts_custom_slider_2'] as $slide ) :
				$image_id    = $slide['mts_custom_slider_image'];
				$slide_title  = $slide['mts_custom_slider_title'];
				$slider_text  = $slide['mts_custom_slider_text'];
				$slide_url    = $slide['mts_custom_slider_url'];
				if(!empty($slide_url)) { ?>
					<a href="<?php echo $slide_url; ?>">
				<?php } ?>
						<div class="home-slide bg-slide clearfix">
							<?php echo wp_get_attachment_image( $image_id, 'pointpro-slider', false, array('title' => '')); ?>
							<div class="slide-caption">
								<?php if ( !empty( $slide_title ) ) { ?>
									<h2 class="slide-title">
										<?php echo esc_html( $slide_title ); ?>
									</h2>
								<?php } ?>
								<?php if ( !empty( $slider_text ) ) { ?>
									<p><?php echo esc_html( $slider_text ); ?></p>
								<?php } ?>
							</div><!-- .home-slide-content -->
						</div><!-- .home-slide -->
				<?php if($slide_url) { ?>
					</a>
				<?php } ?>
			<?php endforeach; ?>
		</div>
	</div><!-- #home-slider -->
<?php } ?>