<?php
$mts_options = get_option(MTS_THEME_NAME);

$mts_homepage_gallery_title = $mts_options['mts_homepage_gallery_title'];
$mts_gallery_num    = empty ( $mts_options['mts_gallery_count_home'] ) ? '6' : $mts_options['mts_gallery_count_home'];
$mts_gallery_layout = $mts_options['mts_gallery_layout'];

if ( '1' == $mts_gallery_layout ) {
	$cols    = ' one-fourth';
	$thumb_size = 'pointpro-project-4';
} else {
	$cols    = ' one-third';
	$thumb_size = 'pointpro-project-3';
} ?>
<div id="gallery" class="section clearfix">
	<div id="page">
		<?php if ( !empty( $mts_homepage_gallery_title ) ) { ?>
			<h3 class="section-title"><span><?php echo $mts_homepage_gallery_title; ?></span></h3>
		<?php }?>
		<a href="<?php echo get_post_type_archive_link( 'gallery' ); ?>" class="btn-archive-link"><?php _e( 'All gallery', 'pointpro' ); ?></a>
		<div class="grid">
			<?php
			$query = new WP_Query();
			$query->query('post_type=gallery&ignore_sticky_posts=1&posts_per_page='.$mts_gallery_num);
			while ( $query->have_posts() ) : $query->the_post(); ?>				
				<article class="gallery-item grid-box<?php echo $cols; ?>">
					<div class="grid-inner project-box-inner">
						<a class="gallery-image" href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>">
							<?php the_post_thumbnail( $thumb_size, array('title' => '')); ?>
						</a>	
					</div>
				</article>
	        <?php endwhile; ?>
	        <?php wp_reset_query(); ?>
		</div>
	</div>
</div>