<?php
$mts_options = get_option(MTS_THEME_NAME);

$mts_homepage_team_title = $mts_options['mts_homepage_team_title'];
$mts_home_blog_col = $mts_options['mts_homepage_team_col'];

if ( '1' == $mts_home_blog_col ) {
    $cols    = ' one-fourth';
} else {
    $cols    = ' one-third';
} ?>
<div id="team" class="section clearfix">
    <div id="page">
    	<?php if ( !empty( $mts_homepage_team_title ) ) { ?>
    		<h3 class="section-title"><span><?php echo $mts_homepage_team_title; ?></span></h3>
    	<?php }
        if ( ! empty( $mts_options['mts_homepage_team'] ) ) {
            ?>
            <div class="grid">
                <?php 
                foreach ( $mts_options['mts_homepage_team'] as $key => $section ) {
                    $team_name        = $section['mts_homepage_team_name'];
                    $team_job         = $section['mts_homepage_team_member_job'];
                    $team_image       = $section['mts_homepage_team_image'];
                    $team_description = $section['mts_homepage_team_info'];
                    $team_facebook    = $section['mts_homepage_team_facebook'];
                    $team_twitter     = $section['mts_homepage_team_twitter'];
                    $team_google      = $section['mts_homepage_team_google'];
                    $team_instagram   = $section['mts_homepage_team_instagram'];

                    ?>
                    <div class="grid-box<?php echo $cols; ?>">
                        <div class="grid-box-inner">                        
                            <?php if ( !empty( $team_image ) ) { ?>
                                <div class="img-container"><img src="<?php echo $team_image; ?>"/></div>
                            <?php } ?>
                            
                            <div class="employee-name">
                                <h2 class="title team-title"><?php echo $team_name; ?></h2>
                                <div class="team-job">
                                    <?php echo ($team_job) ? $team_job : ''; ?>
                                </div>
                                <div class="social-list">
                                    <?php if ( !empty($team_facebook) ) { ?>
                                        <a href="<?php echo $team_facebook; ?>"><i class="fa fa-facebook"></i></a>
                                    <?php }?>
                                    <?php if ( !empty($team_twitter) ) { ?>
                                        <a href="<?php echo $team_twitter; ?>"><i class="fa fa-twitter"></i></a>
                                    <?php }?>
                                    <?php if ( !empty($team_google) ) { ?>
                                        <a href="<?php echo $team_google; ?>"><i class="fa fa-google-plus"></i></a>
                                    <?php }?>
                                    <?php if ( !empty($team_instagram) ) { ?>
                                        <a href="<?php echo $team_instagram; ?>"><i class="fa fa-instagram"></i></a>
                                    <?php }?>
                                </div>
                            </div>

                            <div class="description">
                                <?php echo $team_description; ?>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
    </div>
</div>