<?php
if ( function_exists( 'icl_get_languages' ) ):
	$langs = apply_filters( 'wpml_active_languages', 'skip_missing=1&orderby=id&order=asc', null );
endif;

if ( !empty( $langs ) ): ?>
    <div class="stm-lang-switcher">
		<?php
		if ( count( $langs ) > 1 || is_author() ) {
			$langs_exist = 'dropdown_toggle';
		} else {
			$langs_exist = 'no_other_langs';
		}

		$current_lang = '';
		$current_lang_flag = '';
		if ( !empty( $langs[ICL_LANGUAGE_CODE] ) ) {
			$current_lang = $langs[ICL_LANGUAGE_CODE];
			if ( !empty( $current_lang['country_flag_url'] ) ) {
				$current_lang_flag = $current_lang['country_flag_url'];
			}
		}


		?>
        <div class="pull-left language-switcher-unit">
            <div class="stm_current_language <?php echo esc_attr( $langs_exist ); ?>" <?php if ( count( $langs ) > 1 || is_author() ) { ?> id="lang_dropdown" data-toggle="dropdown" <?php } ?>>
				<?php if ( stm_is_rental() and !empty( $current_lang_flag ) ): ?>
                    <img src="<?php echo esc_url( $current_lang_flag ); ?>"
                         alt="<?php esc_attr_e( 'Language flag', 'stm_motors_car_rental' ) ?>"/>
				<?php endif; ?>
				<?php if ( count( $langs ) > 1 || is_author() ) { ?>
                    <i class="fas fa-angle-down"></i>
				<?php } ?>
            </div>
			<?php if ( count( $langs ) > 1 && !is_author() ): ?>
                <ul class="dropdown-menu lang_dropdown_menu" role="menu"
                    aria-labelledby="lang_dropdown">
					<?php foreach ( $langs as $lang ): ?>
						<?php if ( !$lang['active'] ): ?>
                            <li role="presentation">
                                <a role="menuitem" tabindex="-1"
                                   href="<?php echo esc_url( $lang['url'] ); ?>">
									<?php if ( stm_is_rental() and !empty( $lang['country_flag_url'] ) ): ?>
                                        <img src="<?php echo esc_url( $lang['country_flag_url'] ); ?>"
                                             alt="<?php esc_attr_e( 'Language flag', 'stm_motors_car_rental' ) ?>"/>
									<?php endif; ?>
                                </a>
                            </li>
						<?php endif; ?>
					<?php endforeach; ?>
                </ul>
			<?php elseif ( is_author() ):
				$user = get_user_by( "ID", get_current_user_id() );

				?>
                <ul class="dropdown-menu lang_dropdown_menu" role="menu"
                    aria-labelledby="lang_dropdown">
					<?php foreach ( icl_get_languages( 'skip_missing=0' ) as $val ) : ?>
						<?php
						$request_uri = str_replace( "/" . wpml_get_current_language() . "/", "/", apply_filters( 'stm_get_global_server_val', "REQUEST_URI" ) );
						if ( !$val['active'] ):
							$mainUrl = $sitepress->language_url( $val["code"] );

							$url_append = "";
							if ( is_multisite() ) {
								$ms_slug = get_blog_details()->path;
								$request_uri = str_replace( $ms_slug, "", $request_uri );
							}
							?>
                            <li role="presentation">
                                <a role="menuitem" tabindex="-1"
                                   href="<?php echo esc_url( $mainUrl . $request_uri ); ?>">
									<?php if ( stm_is_rental() and !empty( $val['country_flag_url'] ) ): ?>
                                        <img src="<?php echo esc_url( $val['country_flag_url'] ); ?>"
                                             alt="<?php esc_attr_e( 'Language flag', 'stm_motors_car_rental' ) ?>"/>
									<?php endif; ?>
                                </a>
                            </li>
						<?php endif; ?>
					<?php endforeach; ?>
                </ul>
			<?php endif; ?>
        </div>
    </div>
<?php endif; ?>
