<?php
/**
 * Radio control class that creates a list of radio inputs to choose from.
 *
 * @package    ButterBean
 * @subpackage Admin
 * @author     Justin Tadlock <justin@justintadlock.com>
 * @copyright  Copyright (c) 2015-2016, Justin Tadlock
 * @link       https://github.com/justintadlock/butterbean
 * @license    http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */

/**
 * Radio control class.
 *
 * @since  1.0.0
 * @access public
 */
class ButterBean_Review_Control_Radio extends ButterBean_Review_Control {

	/**
	 * The type of control.
	 *
	 * @since  1.0.0
	 * @access public
	 * @var    string
	 */
	public $type = 'radio';

	/**
	 * Radio controls imply that a value should be set.  Therefore, we will return
	 * the default if there is no value.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  string  $setting
	 * @return mixed
	 */
	public function get_value( $setting = 'default' ) {

		$value  = parent::get_value( $setting );
		$object = $this->get_setting( $setting );

		return ! $value && $object ? $object->default : $value;
	}
}
