<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $product, $woocommerce_loop, $wp_query;
$mokar_settings = mokar_check_theme_options();
// Ensure visibility
if (!$product || !$product->is_visible()) {
    return;
}
?>

<?php
	/**
	 * woocommerce_before_single_product hook.
	 *
	 * @hooked wc_print_notices - 10
	 */
	 do_action( 'woocommerce_before_single_product' );

	 if ( post_password_required() ) {
	 	echo get_the_password_form();
	 	return;
	 }
?>

<div itemscope itemtype="<?php echo woocommerce_get_product_schema(); ?>" id="product-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="product-deal">
		<div class="product-img">
			<a class="product-image" href="<?php echo esc_url( get_permalink( $product->get_id() ) ); ?>" title="<?php echo esc_attr( $product->get_title() ); ?>">
				<?php echo $product->get_image('mokar-blog-grid'); ?>
			</a>
		</div>
		<div class="info deal-of">
			<h3><a href="<?php the_permalink(); ?>" class="product-name"><?php the_title(); ?></a></h3>
			<div class="deal-meta">
				<?php
					/**
					 * woocommerce_attribute hook.
					 *
					 * @hooked woocommerce_template_single_rating - 10
					 * @hooked woocommerce_template_single_excerpt - 20
					 * @hooked woocommerce_template_single_price - 25
					 * @hooked woocommerce_template_single_add_to_cart - 30
					 */
					do_action( 'woocommerce_attribute' );
				?>
			</div>
		</div>
		<meta itemprop="url" content="<?php the_permalink(); ?>" />
	</div>

</div><!-- #product-<?php the_ID(); ?> -->
