<?php 
    $mokar_settings = mokar_check_theme_options();
    $mokar_post_layout = isset($mokar_settings['post-layout-version']) ? $mokar_settings['post-layout-version'] :'';
    $mokar_post_columns = isset($mokar_settings['post-layout-columns']) ? $mokar_settings['post-layout-columns'] :'';
    $mokar_list_style = isset($mokar_settings['post-list-style']) ? $mokar_settings['post-list-style'] :'list_s1';    
    $mokar_post_pagination = isset($mokar_settings['post_pagination']) ? $mokar_settings['post_pagination'] :'';   
    $mokar_post_desc = isset($mokar_settings['post_desc']) ? $mokar_settings['post_desc'] :'';   
    if (is_category()){
        $category = get_category( get_query_var( 'cat' ) );
        $cat_id = $category->cat_ID;
        if(get_metadata('category', $cat_id, 'blog_layout', true) != 'default'){
            $mokar_post_layout = get_metadata('category', $cat_id, 'blog_layout', true);    
        }
        if(get_metadata('category', $cat_id, 'blog_columns', true) != 'default'){
        	$mokar_post_columns = get_metadata('category', $cat_id, 'blog_columns', true);  
        }
        if(get_metadata('category', $cat_id, 'blog_list_style', true) != 'default'){
            $mokar_list_style = get_metadata('category', $cat_id, 'blog_list_style', true);
        }         
        if(get_metadata('category', $cat_id, 'post_pagination', true) != 'default'){
            $mokar_post_pagination = get_metadata('category', $cat_id, 'post_pagination', true);
        }  
        if(get_metadata('category', $cat_id, 'post_desc', true) != 'default'){
            $mokar_post_desc = get_metadata('category', $cat_id, 'post_desc', true);
        }                 
    }
    $mokar_skin = get_post_meta(get_the_ID(),'skin',true);
	$mokar_class = '';
	$mokar_class_columns = '';
	
	if($mokar_post_layout == 'masonry'){
		$mokar_class = ' blog-masonry';
		$mokar_list_style = '';
	}else if($mokar_post_layout == 'list'){
		$mokar_class = ' blog-list';
		$mokar_post_columns = '1';
	}else{
		$mokar_class = ' blog-grid';
		$mokar_list_style = '';
	}
	if($mokar_post_desc =='2' && $mokar_post_layout != 'list'){
		$mokar_class .= ' display_desc';
	}
	if($mokar_post_columns == '1'){
		$mokar_class_columns = 'col-md-12 col-sm-12 col-xs-12';
	}else if($mokar_post_columns == '2'){
		$mokar_class_columns = 'col-md-6 col-sm-6 col-xs-12';
	}else if($mokar_post_columns == '4'){
		$mokar_class_columns = 'col-md-3 col-sm-6 col-xs-12';
	}else{
		$mokar_class_columns = 'col-md-4 col-sm-6 col-xs-12';
	}	
    $current_page = get_query_var('paged') ? intval(get_query_var('paged')) : 1;
?>
<div class="row blog-entries-wrap grid-isotope <?php echo esc_attr($mokar_class).' '.esc_attr($mokar_list_style); ?>">
	<?php while (have_posts()) : the_post(); ?>
		<div class="grid-item <?php echo esc_attr($mokar_class_columns); ?>">
			<div class="blog-content animate-top">
				<div class="blog-item">
					<?php mokar_get_post_media(); ?>
					<div class="blog-post-info">
						<div class="blog-info">
							<div class="blog-date info">
								<p class="date"><a href="<?php the_permalink(); ?>"><?php echo get_the_date(); ?></a></p>
							</div>
							<?php $mokar_author_id= $post->post_author;?>
							<div class="info author">
								<span><?php echo esc_html__('author: ','mokar');?></span>
								<a href="<?php echo esc_url(get_edit_user_link( $mokar_author_id )); ?>"><?php the_author_meta( 'nickname' , $mokar_author_id ); ?></a>
							</div>		
						</div>									
						<?php if(get_the_title() != ''):?>
						<div class="blog-post-title">
							<div class="post-name">
							    <a href="<?php the_permalink(); ?>"><?php the_title(); ?>
									<?php  if ( is_sticky() && is_home() && ! is_paged() ):?>
									 <span class="sticky_post"><?php echo esc_html__('Featured', 'mokar')?></span>
									<?php endif;?>          
								</a>                                     
							</div>					
						</div>
						<?php endif;?>
						<?php if ($mokar_post_layout == "list"): ?>
							<div class="blog_post_desc">
								<?php 
								if (get_post_meta(get_the_ID(),'highlight',true) != "") : ?>                            
									<p><?php echo get_post_meta(get_the_ID(),'highlight',true);?></p>
								<?php else:?>
									<?php
									echo '<div class="entry-content">';
									the_content();
									wp_link_pages( array(
										'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'mokar' ) . '</span>',
										'after'       => '</div>',
										'link_before' => '<span>',
										'link_after'  => '</span>',
										'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'mokar' ) . ' </span>%',
										'separator'   => '<span class="screen-reader-text">, </span>',
									) );
									echo '</div>';
									?>
								<?php endif; ?>
							</div>
						<?php elseif($mokar_post_desc == '2'):?>
							<div class="blog_post_desc">
								<?php 
								if (get_post_meta(get_the_ID(),'highlight',true) != "") : ?>                            
									<p><?php echo get_post_meta(get_the_ID(),'highlight',true);?></p>
								<?php endif; ?>
							</div>
						<?php endif;?>
					</div>	
				</div>
			</div>
		</div>
	<?php endwhile; ?>
</div>


<?php if($mokar_post_pagination =='2'):?>
	<?php if( get_previous_posts_link() ||  get_next_posts_link()):?>
		<div class="row">
			<div class="col-md-12 col-sm-12 col-xs-12 animate-top ">			
				<ul class="paginationtype-2 text-right">
					<?php if( get_previous_posts_link()): ?>
					<li class="pagination_button_prev"><?php previous_posts_link( '<i class="pe-7s-angle-left"></i>' ); ?></li>
					<?php endif; ?>	
					<?php if( get_next_posts_link()): ?>
					<li class="pagination_button_next"><?php next_posts_link( '<i class="pe-7s-angle-right"></i>'); ?></li>
					<?php endif; ?>	
				</ul>
			</div>
		</div>
	<?php endif; ?>	
<?php else:?>
	<?php if ($wp_query->max_num_pages > 1) : ?>
		<div class="row">
			<div class="col-md-12 col-sm-12 col-xs-12 animate-top">				
				<div class="load-more text-center">
					<a data-paged="<?php echo esc_attr($current_page) ?>" data-totalpage="<?php echo esc_attr($wp_query->max_num_pages) ?>" id="blog-loadmore" class="btn btn-primary"><?php echo esc_html__('View More', 'mokar') ?> </a>
				</div>
			</div>
		</div>						
	<?php endif; ?>
<?php endif;?>

