<?php

function mokar_iconpicker_type_pestrokefont( $icons ) {
    $pestrokefont_icons = array(
        array( 'pe-7s-back-2' => 'Back 2' ),
        array( 'pe-7s-next-2' => 'Next 2'),
        array( 'pe-7s-piggy' => 'Piggy' ),
        array( 'pe-7s-gift' => 'Gift' ),
        array( 'pe-7s-arc' => 'Archor' ),
        array( 'pe-7s-plane' => 'Plane' ),
        array( 'pe-7s-help2' => 'Help' ),
        array( 'pe-7s-clock' => 'Clock' ),
        array( 'pe-7s-junk' => 'Junk' ),
        array( 'pe-7s-edit' => 'Edit' ),
        array( 'pe-7s-download' => 'Download' ),
        array( 'pe-7s-config' => 'Config' ),
        array( 'pe-7s-drop' => 'Drop' ),
        array( 'pe-7s-refresh' => 'Refresh' ),
        array( 'pe-7s-album' => 'Album' ),
        array( 'pe-7s-diamond' => 'Diamond' ),
        array( 'pe-7s-door-lock' => 'Door lock' ),
        array( 'pe-7s-photo' => 'Photo' ),
        array( 'pe-7s-settings' => 'Settings' ),
        array( 'pe-7s-volume' => 'Volumn' ),
        array( 'pe-7s-users' => 'Users' ),
        array( 'pe-7s-tools' => 'Tools' ),
        array( 'pe-7s-star' => 'Star' ),
        array( 'pe-7s-like2' => 'Like' ),
        array( 'pe-7s-map-2' => 'Map 2' ),
        array( 'pe-7s-call' => 'Call' ),
        array( 'pe-7s-mail' => 'Mail' ),
        array( 'pe-7s-way' => 'Way' ),
        array( 'pe-7s-edit' => 'Edit' ),
        array( 'pe-7s-drop' => 'Drop' ),
        array( 'pe-7s-download' => 'Download' ),
        array( 'pe-7s-config' => 'Config' ),
        array( 'pe-7s-junk' => 'Junk' ),
        array( 'pe-7s-magic-wand' => 'Magic' ),
        array( 'pe-7s-like' => 'Like' ),
        array( 'pe-7s-cup' => 'Cup' ),
        array( 'pe-7s-cash' => 'Cash' ),
        array( 'pe-7s-target' => 'Target' ),
    );

    return array_merge( $icons, $pestrokefont_icons );
}

add_filter( 'vc_iconpicker-type-pestrokefont', 'mokar_iconpicker_type_pestrokefont' );
function mokar_iconpicker_type_mokarfont( $icons ) {
    $mokarfont_icons = array(
        array( 'icon-1' => '' ),
        array( 'icon-2' => '' ),
        array( 'icon-3' => '' ),
        array( 'icon-4' => '' ),
        array( 'icon-5' => '' ),
        array( 'icon-6' => '' ),
        array( 'icon-7' => '' ),
        array( 'icon-8' => '' ),
        array( 'icon-9' => '' ),
        array( 'icon-10' => '' ),
        array( 'icon-11' => '' ),
        array( 'icon-12' => '' ),
        array( 'icon-13' => '' ),
        array( 'icon-14' => '' ),
        array( 'icon-15' => '' ),
        array( 'icon-16' => '' ),
        array( 'icon-17' => '' ),
        array( 'icon-18' => '' ),
        array( 'icon-19' => '' ),
        array( 'icon-20' => '' ),
        array( 'icon-21' => '' ),
        array( 'icon-22' => '' ),
        array( 'icon-23' => '' ),
        array( 'icon-24' => '' ),
        array( 'icon-25' => '' ),
        array('icon-arrow-right' => ''),
        array( 'icon-eye' => ''),
    );
    return array_merge( $icons, $mokarfont_icons );
}
add_filter( 'vc_iconpicker-type-mokarfont', 'mokar_iconpicker_type_mokarfont' );
function mokar_vc_icon() {
    $attributes = array(
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Icon library', 'mokar'),
            'value' => array(
                esc_html__('Font Awesome', 'mokar') => 'fontawesome',
                esc_html__('Stroke Icons 7', 'mokar') => 'pestrokefont',
                esc_html__('Mokar Icon', 'mokar') => 'mokarfont',
                esc_html__('Open Iconic', 'mokar') => 'openiconic',
                esc_html__('Typicons', 'mokar') => 'typicons',
                esc_html__('Entypo', 'mokar') => 'entypo',
                esc_html__('Linecons', 'mokar') => 'linecons',
            ),
            'admin_label' => true,
            'param_name' => 'type',
            'weight' => 10,
            'description' => esc_html__('Select icon library.', 'mokar'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__('Icon', 'mokar'),
            'param_name' => 'icon_pestrokefont',
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'pestrokefont',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => array(
                'element' => 'type',
                'value' => 'pestrokefont',
            ),
            'weight' => 9,
            'description' => esc_html__('Select icon from library.', 'mokar'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__('Icon', 'mokar'),
            'param_name' => 'icon_mokarfont',
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'mokarfont',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => array(
                'element' => 'type',
                'value' => 'mokarfont',
            ),
            'weight' => 9,
            'description' => esc_html__('Select icon from library.', 'mokar'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__('Icon', 'mokar'),
            'param_name' => 'icon_fontawesome',
            'value' => 'fa fa-adjust', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false,
                // default true, display an "EMPTY" icon?
                'iconsPerPage' => 4000,
            // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
            ),
            'dependency' => array(
                'element' => 'type',
                'value' => 'fontawesome',
            ),
            'description' => esc_html__('Select icon from library.', 'mokar'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__('Icon', 'mokar'),
            'param_name' => 'icon_openiconic',
            'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'openiconic',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => array(
                'element' => 'type',
                'value' => 'openiconic',
            ),
            'description' => esc_html__('Select icon from library.', 'mokar'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__('Icon', 'mokar'),
            'param_name' => 'icon_typicons',
            'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'typicons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => array(
                'element' => 'type',
                'value' => 'typicons',
            ),
            'description' => esc_html__('Select icon from library.', 'mokar'),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__('Icon', 'mokar'),
            'param_name' => 'icon_entypo',
            'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'entypo',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => array(
                'element' => 'type',
                'value' => 'entypo',
            ),
        ),
        array(
            'type' => 'iconpicker',
            'heading' => esc_html__('Icon', 'mokar'),
            'param_name' => 'icon_linecons',
            'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
            'settings' => array(
                'emptyIcon' => false, // default true, display an "EMPTY" icon?
                'type' => 'linecons',
                'iconsPerPage' => 4000, // default 100, how many icons per/page to display
            ),
            'dependency' => array(
                'element' => 'type',
                'value' => 'linecons',
            ),
            'description' => esc_html__('Select icon from library.', 'mokar'),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Icon alignment', 'mokar' ),
            'param_name' => 'align',
            'value' => array(
                esc_html__( 'Left', 'mokar' ) => 'left',
                esc_html__( 'Right', 'mokar' ) => 'right',
                esc_html__( 'Center', 'mokar' ) => 'center',
                esc_html__( 'Inline', 'mokar' ) => 'inline',
            ),
            'description' => esc_html__( 'Select icon alignment.', 'mokar' ),
             "group"     => "Icon Style",
        ),
        array(
            'type' => 'number',
            'heading' => esc_html__( 'Size', 'mokar' ),
            'param_name' => 'size',
            "value" => "14",
            'description' => esc_html__( 'Icon size (px)', 'mokar' ),
             "group"     => "Icon Style",
        ),
        array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Border Style", "mokar"),
            "param_name" => "icon_border_style",
            "value" => array(
                esc_html__("None","mokar") => "none",
                esc_html__("Solid","mokar")   => "solid",
                esc_html__("Dashed","mokar") => "dashed",
                esc_html__("Dotted","mokar") => "dotted",
                esc_html__("Double","mokar") => "double",
                esc_html__("Inset","mokar") => "inset",
                esc_html__("Outset","mokar") => "outset",
            ),
            "description" => esc_html__("Select the border style for icon.","mokar"),
            "dependency" => Array("element" => "background_style", "value" => array("rounded-outline","boxed-outline", "rounded-less-outline")),
            "group"     => "Icon Style",
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__( 'Enable hover state for icon', 'mokar' ),
            'param_name' => 'icon_hover',
            'value' => true,
             "group"     => "Icon Style",
        ),
        array(
            "type" => "textarea_html",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Content", "mokar" ),
            "param_name" => "content", // Important: Only one textarea_html param per content element allowed and it should have "content" as a "param_name"
            "description" => esc_html__( "Enter your content.", "mokar" ),
            'group' => esc_html__( 'Content', 'mokar' )
        )
    );

    vc_add_params('vc_icon', $attributes);

}

add_action('vc_before_init', 'mokar_vc_icon');

function mokar_vc_column() {
    $attributes = array(
        array(
            'type' => 'checkbox',
            'heading' => esc_html__("Add overlay background", "mokar"),
            'param_name' => 'overlay',
            'value' => array( esc_html__( 'Yes', 'mokar' ) => 'yes' ),
            'weight' => 5,
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__("Align inside element center horizontally and vertically", "mokar"),
            'param_name' => 'center_element',
            'value' => array( esc_html__( 'Yes', 'mokar' ) => 'yes' ),
            'weight' => 5,
        ),        
    );
    vc_add_params('vc_column', $attributes); 
}
add_action('vc_before_init', 'mokar_vc_column'); 
function mokar_vc_row() {
    $attributes = array(
        array(
            'type' => 'checkbox',
            'heading' => esc_html__("Wrap inside column in container", "mokar"),
            'param_name' => 'wrap_container',
            'value' => array( esc_html__( 'Yes', 'mokar' ) => 'yes' ),
            'weight' => 5,
        ),
        array(
            'type' => 'checkbox',
            'heading' => esc_html__("Hide background in mobile", "mokar"),
            'param_name' => 'hide_bg_mobile',
            'value' => array( esc_html__( 'Yes', 'mokar' ) => 'yes' ),
            'weight' => 5,
        ),
    );
    vc_add_params('vc_row', $attributes); 
}
add_action('vc_before_init', 'mokar_vc_row'); 
function mokar_vc_row_inner() {
    $attributes = array(
        array(
            'type' => 'checkbox',
            'heading' => esc_html__("Wrap inside column in container", "mokar"),
            'param_name' => 'wrap_container',
            'value' => array( esc_html__( 'Yes', 'mokar' ) => 'yes' ),
            'weight' => 5,
        ),
    );
    vc_add_params('vc_row_inner', $attributes); 
}
add_action('vc_before_init', 'mokar_vc_row_inner'); 

function mokar_vc_gallery() {
    $attributes = array(
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Number of columns', 'mokar' ),
            'param_name' => 'col_num',
            'value' => array(
                esc_html__( 'Default', 'mokar' ) => 'default',
                esc_html__( '2', 'mokar' ) => '2',
                esc_html__( '3', 'mokar' ) => '3',
                esc_html__( '4', 'mokar' ) => '4',
                esc_html__( '5', 'mokar' ) => '5',
            ),
            'description' => esc_html__( 'Select number of columns to display images.', 'mokar' ),
             "group"     => esc_html__( "Column numbers", 'mokar' ),
            'dependency' => array(
                'element' => 'type',
                'value' => 'image_grid',
            ),
        ),
    );

    vc_add_params('vc_gallery', $attributes);

}

add_action('vc_before_init', 'mokar_vc_gallery');

function mokar_vc_progress_bar() {
    $attributes = array(
        array(
            'type' => 'param_group',
            'heading' => esc_html__( 'Values', 'mokar' ),
            'param_name' => 'values',
            'description' => esc_html__( 'Enter values for graph - value, title and color.', 'mokar' ),
            'value' => urlencode( json_encode( array(
                array(
                    'label' => esc_html__( 'Development', 'mokar' ),
                    'value' => '90',
                ),
                array(
                    'label' => esc_html__( 'Design', 'mokar' ),
                    'value' => '80',
                ),
                array(
                    'label' => esc_html__( 'Marketing', 'mokar' ),
                    'value' => '70',
                ),
            ) ) ),

            'params' => array(
                
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Label', 'mokar' ),
                    'param_name' => 'label',
                    'description' => esc_html__( 'Enter text used as title of bar.', 'mokar' ),
                    'admin_label' => true,
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Value', 'mokar' ),
                    'param_name' => 'value',
                    'description' => esc_html__( 'Enter value of bar.', 'mokar' ),
                    'admin_label' => true,
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__( 'Color', 'mokar' ),
                    'param_name' => 'color',
                    'value' => array(
                            esc_html__( 'Default', 'mokar' ) => '',
                        ) + array(
                            esc_html__( 'Classic Grey', 'mokar' ) => 'bar_grey',
                            esc_html__( 'Classic Blue', 'mokar' ) => 'bar_blue',
                            esc_html__( 'Classic Turquoise', 'mokar' ) => 'bar_turquoise',
                            esc_html__( 'Classic Green', 'mokar' ) => 'bar_green',
                            esc_html__( 'Classic Orange', 'mokar' ) => 'bar_orange',
                            esc_html__( 'Classic Red', 'mokar' ) => 'bar_red',
                            esc_html__( 'Classic Black', 'mokar' ) => 'bar_black',
                        ) + getVcShared( 'colors-dashed' ) + array(
                            esc_html__( 'Custom Color', 'mokar' ) => 'custom',
                        ),
                    'description' => esc_html__( 'Select single bar background color.', 'mokar' ),
                    'admin_label' => true,
                    'param_holder_class' => 'vc_colored-dropdown',
                ),
                array(
                    'type' => 'colorpicker',
                    'heading' => esc_html__( 'Custom color', 'mokar' ),
                    'param_name' => 'customcolor',
                    'description' => esc_html__( 'Select custom single bar background color.', 'mokar' ),
                    'dependency' => array(
                        'element' => 'color',
                        'value' => array( 'custom' ),
                    ),
                ),
                array(
                    'type' => 'colorpicker',
                    'heading' => esc_html__( 'Custom text color', 'mokar' ),
                    'param_name' => 'customtxtcolor',
                    'description' => esc_html__( 'Select custom single bar text color.', 'mokar' ),
                    'dependency' => array(
                        'element' => 'color',
                        'value' => array( 'custom' ),
                    ),
                ),
            ),
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Layout", 'mokar'),
            "param_name" => "layout",
            'std' => 'layout1',
            'value' => array(
                esc_html__('Layout 1', 'mokar') => 'layout1',
                esc_html__('Layout 2', 'mokar') => 'layout2',
            ),
        ),
    );

    vc_add_params('vc_progress_bar', $attributes);

}

add_action('vc_before_init', 'mokar_vc_progress_bar');


