<?php
function mokar_show_gallery_page_meta_option() {
    $meta_box = mokar_default_meta_data();
    $meta_box['single_gallery_layout'] = array(
        'name'  => 'single_gallery_style',
        'type' => 'select',
        'title' => esc_html__('Single gallery layout', 'mokar'),
        'options' => array(
            "default" => esc_html__("Default","mokar"),
                    "1" => esc_html__("Wide","mokar"),
                    "2" => esc_html__("Slider","mokar"),
                    "3" => esc_html__("Side Information","mokar"),
                ),
        'default' => 'default' 
    );
    mokar_show_meta_box($meta_box);
}
function mokar_save_gallery_page_meta_option($post_id) {
    $meta_box = mokar_default_meta_data();
    $meta_box['single_gallery_layout'] = array(
        'name'  => 'single_gallery_style',
        'type' => 'select',
        'title' => esc_html__('Single gallery layout', 'mokar'),
        'options' => array(
            "default" => esc_html__("Default","mokar"),
                "1" => esc_html__("Wide","mokar"),
                "2" => esc_html__("Slider","mokar"),
                "3" => esc_html__("Side Information","mokar"),
            ),
        'default' => 'default' 
    );    
    return mokar_save_meta_data($post_id, $meta_box);
}
function mokar_add_gallery_metaboxes() {
    if (function_exists('add_meta_box')) {
        add_meta_box('view-meta-boxes', esc_html__('Layout Options', 'mokar'), 'mokar_show_gallery_page_meta_option', 'gallery', 'side', 'low');
    }
}

add_action('add_meta_boxes', 'mokar_add_gallery_metaboxes');
add_action('save_post', 'mokar_save_gallery_page_meta_option');
function mokar_add_categorymeta_gallery_table() {
// Create Gallery Cat Meta
global $wpdb;
$type = 'gallery_cat';
$table_name = $wpdb->prefix . $type . 'meta';
$variable_name = $type . 'meta';
$wpdb->$variable_name = $table_name;

// Create Gallery Cat Meta Table
mokar_create_metadata_table($table_name, $type);
}
add_action( 'init', 'mokar_add_categorymeta_gallery_table' );
//Taxonomy
function mokar_default_gallery_tax_meta_data() {
    $mokar_layout = mokar_layouts();
    $mokar_sidebar_position = mokar_sidebar_position();
    $mokar_sidebars = mokar_sidebars();   
    $mokar_header_layout = mokar_header_types();
    $mokar_footer_layout = mokar_footer_types(); 
    $gallery_style= mokar_page_gallery_layouts();
    $gallery_style['default'] ='Default';
    $gallery_cols = mokar_gallery_columns();
    $gallery_cols['default'] ='Default';
    return array(
                // layout
        'layout' => array(
            'name' => 'layout',
            'title' => esc_html__('Layout', 'mokar'),
            'type' => 'select',
            'options' => $mokar_layout,
            'default' => 'default'
        ),
        'left-sidebar' => array(
            'name' => 'left-sidebar',
            'type' => 'select',
            'title' => esc_html__('Left Sidebar', 'mokar'),
            'options' => $mokar_sidebars,
            'default' => 'default'
        ),
        'right-sidebar' => array(
            'name' => 'right-sidebar',
            'type' => 'select',
            'title' => esc_html__('Right Sidebar', 'mokar'),
            'options' => $mokar_sidebars,
            'default' => 'default'
        ),    
        'gallery_filter' => array(
            'name'  => 'gallery_filter',
            'type'  => 'select',
            'title' => esc_html__('Gallery filter','mokar'),
            'options'   => array(
                'default' => esc_html__('Default','mokar'),
                '1' => esc_html__('Yes','mokar'),
                '2' => esc_html__('No','mokar'),
                ),
            'default' => 'default',
        ),
        'gallery-style-version' => array(
            'name' => 'gallery-style-version',
            'type' => 'select',
            'title' => esc_html__('Gallery Layouts', 'mokar'),
            'options' => $gallery_style,
            'default' => 'default'
        ),
        'gallery-loadmore-style' => array(
            'name'  => 'gallery-loadmore-style',
            'type'  => 'select',
            'title' => esc_html__('Gallery loadmore style','mokar'),
            'options'   => array(
                                'default' => esc_html__('Default','mokar'),
                                '1' => esc_html__('Button style 1','mokar'),
                                '2' => esc_html__('Button style 2','mokar'),
                                ),
            'default' => 'default',
        ),
        'gallery-cols' => array(
            'name' => 'gallery-cols',
            'type' => 'select',
            'title' => esc_html__('Gallery columns', 'mokar'),
            'options' => $gallery_cols,
            'default' => 'default'
        ), 
        'gallery_per_page' => array(
            'name' => 'gallery_per_page',
            'type' => 'number',
            'title' => esc_html__('Post show per page', 'mokar'),
            'default' => 'default',
        ),                
    );
}

add_action( 'gallery_cat_add_form_fields', 'mokar_add_gallery_cat', 10, 2);
function mokar_add_gallery_cat() {
    $gallery_cat_meta_boxes = mokar_default_gallery_tax_meta_data();

    mokar_show_tax_add_meta_boxes($gallery_cat_meta_boxes);
}

add_action( 'gallery_cat_edit_form_fields', 'mokar_edit_gallery_cat', 10, 2);
function mokar_edit_gallery_cat($tag, $taxonomy) {
    $gallery_cat_meta_boxes = mokar_default_gallery_tax_meta_data();

    mokar_show_tax_edit_meta_boxes($tag, $taxonomy, $gallery_cat_meta_boxes);
}

add_action( 'created_term', 'mokar_save_gallery_cat', 10,3 );
add_action( 'edit_term', 'mokar_save_gallery_cat', 10,3 );

function mokar_save_gallery_cat($term_id, $tt_id, $taxonomy) {
    if (!$term_id) return;
    
    $gallery_cat_meta_boxes = mokar_default_gallery_tax_meta_data();
    return mokar_save_taxdata( $term_id, $tt_id, $taxonomy, $gallery_cat_meta_boxes );
}