<?php

if (!class_exists('ReduxFramework') && file_exists(MOKAR_ADMIN . '/ReduxCore/framework.php')) {
    require_once( MOKAR_ADMIN . '/ReduxCore/framework.php' );
}

require_once( MOKAR_ADMIN . '/settings/settings.php' );
require_once( MOKAR_ADMIN . '/settings/save_settings.php' );

function mokar_check_theme_options() {
    // check default options
    global $mokar_settings;
    if(!get_option('mokar_settings')) {
        ob_start();
        include(MOKAR_PLUGINS . '/theme_options.php');
        $options = ob_get_clean();
        $mokar_default_settings = json_decode($options, true);
        if (is_array($mokar_default_settings) || is_object($mokar_default_settings))
        {
            foreach ($mokar_default_settings as $key => $value) {
                if (is_array($value)) {
                    foreach ($value as $key1 => $value1) {
                        if (!isset($mokar_settings[$key][$key1]) || !$mokar_settings[$key][$key1]) {
                            $mokar_settings[$key][$key1] = $mokar_default_settings[$key][$key1];
                        }
                    }
                } else {
                    if (!isset($mokar_settings[$key])) {
                        $mokar_settings[$key] = $mokar_default_settings[$key];
                    }
                }
            }
        }
    }

    return $mokar_settings;
}

if(!class_exists('ReduxFramework')) {
    mokar_check_theme_options();
}
//get theme layout options
function mokar_layouts() {
    return array(
        'default' => esc_html__('Default Layout', 'mokar'),
        'wide' => esc_html__('Wide', 'mokar'),
        'fullwidth' => esc_html__('Full width', 'mokar'),
    );
}
//mokar block
function mokar_block(){
    $block_options = array();
    $args = array(
        'numberposts'       => -1,
        'post_type'         => 'block',
        'post_status'       => 'publish',
    );
    $posts = get_posts($args);
    foreach( $posts as $_post ){
        $block_options[$_post->ID] = $_post->post_title;
    }
    return $block_options;
}
//get theme sidebar position options
function mokar_sidebar_position() {
    return array(
        'default' => esc_html__('Default Position', 'mokar'),
        'left-sidebar' => esc_html__('Left', 'mokar'),
        'right-sidebar' => esc_html__('Right', 'mokar'),
        'none' => esc_html__('None', 'mokar')
    );
}
function mokar_rev_sliders_in_array(){
    if (class_exists('RevSlider')) {
        $theslider     = new RevSlider();
        $arrSliders = $theslider->getArrSliders();
        $arrA     = array();
        $arrT     = array();
        foreach($arrSliders as $slider){
            $arrA[]     = $slider->getAlias();
            $arrT[]     = $slider->getTitle();
        }
        if($arrA && $arrT){
            $result = array_combine($arrA, $arrT);
        }
        else
        {
            $result = false;
        }
        return $result;
    }
}
//Mokar popup
function mokar_popup_layouts() {
    return array(
        'default' => esc_html__('Default Popup', 'mokar'),
        '1' => esc_html__("Popup ", 'mokar'),
    );
}
function mokar_header_types() {
    return array(
        'default' => esc_html__('Default Header', 'mokar'),
        '1' => esc_html__('Header Type 1', 'mokar'),
        '2' => esc_html__('Header Type 2', 'mokar'),
        '3' => esc_html__('Header Type 3', 'mokar'),
        '4' => esc_html__('Header Type 4', 'mokar'),
        '5' => esc_html__('Header Type 5', 'mokar'),
        '6' => esc_html__('Header Type 6', 'mokar'),
    );
}
function mokar_list_menu(){
    $menus = get_terms('nav_menu');
    $menu_list =array();
    foreach($menus as $menu){
      $menu_list[$menu->term_id] =  $menu->name . "";
    } 
    return $menu_list;
}
function mokar_footer_types() {
    return array(
        'default' => esc_html__('Default Footer', 'mokar'),
        '1' => esc_html__('Footer Type 1', 'mokar'),
        '2' => esc_html__('Footer Type 2', 'mokar'),
        '3' => esc_html__('Footer Type 3', 'mokar'),
        '4' => esc_html__('Footer Type 4', 'mokar'),
        '5' => esc_html__('Footer Type 5', 'mokar'),
        '6' => esc_html__('Footer Type 6', 'mokar'),
    );
}
function mokar_page_blog_layouts(){
    return array(
        "grid" => esc_html__("Grid", 'mokar'),
        "list" => esc_html__("List", 'mokar'),
        "masonry" => esc_html__("Masonry", 'mokar'),
    );
}
function mokar_blog_list_style(){
    return array(
        "list_s1" => esc_html__("Style 1(Standard)", 'mokar'),
        "list_s2" => esc_html__("Style 2", 'mokar'),

    );
}
function mokar_page_blog_columns(){
    return array(
        "3" => esc_html__("3 Columns", 'mokar'),
		"1" => esc_html__("1 Column", 'mokar'),
        "2" => esc_html__("2 Columns", 'mokar'),
        "4" => esc_html__("4 Columns", 'mokar'),
    );
}
function mokar_single_room_layouts(){
    return array(
        "3" => esc_html__("3 Columns", 'mokar'),
        "2" => esc_html__("2 Columns", 'mokar'),
        "4" => esc_html__("4 Columns", 'mokar'),
    );
}
function mokar_get_breadcrumbs_type(){
    return array(
        "type-1" => esc_html__("Type 1", 'mokar'),
        "type-2" => esc_html__("Type 2", 'mokar'),
        "type-3" => esc_html__("Type 3", 'mokar'),
        "type-4" => esc_html__("Type 4", 'mokar'),
    );
}
function mokar_product_columns() {
    return array(
		"5" => esc_html__("5", 'mokar'),
		"4" => esc_html__("4", 'mokar'),
		"3" => esc_html__("3", 'mokar'),
		"2" => esc_html__("2", 'mokar'),
		"1" => esc_html__("1", 'mokar'), 
    );
}
function mokar_product_type() {
    return array(
        "only-grid" => esc_html__("Grid", 'mokar'),
        "only-list" => esc_html__("List", 'mokar'),
        //"grid-default" => esc_html__("Grid (default) / List", 'mokar'),
        //"list-default" => esc_html__("List (default) / Grid", 'mokar'),
    );
}
function mokar_blog_columns() {
    return array(
        "2" => esc_html__("2", 'mokar'),
        "3" => esc_html__("3", 'mokar'),
        "4" => esc_html__("4", 'mokar'),
    );
}
function mokar_gallery_columns() {
    return array(
        "3" => esc_html__("3", 'mokar'),
        "2" => esc_html__("2", 'mokar'),
        "4" => esc_html__("4", 'mokar'),
        "5" => esc_html__("5", 'mokar'),
    );
}
function mokar_page_gallery_layouts(){
    return array(
        "1" => esc_html__("Grid", 'mokar'),
        "2" => esc_html__("Masonry", 'mokar'),
    );
}
function mokar_pagination_types(){
    return array(
        "pagination" => esc_html__("Pagination", 'mokar'),
        "loadmore" => esc_html__("Loadmore", 'mokar'),
    );
}
function mokar_get_block_name(){
    $block_options = array();
    $args = array(
        'numberposts'       => -1,
        'post_type'         => 'block',
        'post_status'       => 'publish',
    );
    $posts = get_posts($args);
    foreach( $posts as $_post ){
        $block_options[$_post->ID] = $_post->post_title;

    }
    return $block_options;
}