<?php
$mokar_header_class='';
$mokar_settings = mokar_check_theme_options();
$mokar_breadcrumbs = mokar_get_meta_value('breadcrumbs', true);
$mokar_page_title = mokar_get_meta_value('page_title', true);
?>
<div class="header-wrapper <?php echo esc_attr($mokar_header_class);?>">
    <div class="container">
		<div class="row">
		<?php 
			$mokar_logo_header = (mokar_get_meta_value('logo_header_page') != '') ? mokar_get_meta_value('logo_header_page') : $mokar_settings['logo']['url'];
		?>
			<div class="header-logo hidden-lg hidden-md">
				<a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
                    <?php
                    if ($mokar_settings['logo'] && $mokar_settings['logo']['url']):
                        echo '<img class="" src="' . esc_url(str_replace(array('http:', 'https:'), '', $mokar_settings['logo']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '" />';
                    else:
                        bloginfo('name');
                    endif;
                    ?>
                </a>
			</div>
			<div class="kad-header-logo hidden-xs hidden-sm">
			<?php if (is_front_page()) : ?>
	            <h1 class="header-logo">
	            <?php else : ?>
	                <h2 class="header-logo">
	                <?php endif; ?>
	                <a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
	                    <?php
	                    if ($mokar_settings['logo'] && $mokar_settings['logo']['url']):
	                        echo '<img class="" src="' . esc_url(str_replace(array('http:', 'https:'), '', $mokar_settings['logo']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '" />';
	                    else:
	                        bloginfo('name');
	                    endif;
	                    ?>
	                </a>
	                <?php if (is_front_page()) : ?>
	            </h1>
	        <?php else : ?>
	            </h2>
	        <?php endif; ?>
			</div>
			<div class="col-md-12 kad-header-menu">
				<nav id="site-navigation" class="main-navigation">
					<?php
					$mokar_before_items_wrap = '<button class="btn-open icons"><i class=" fa fa-bars"></i></button>';
					$mokar_after_item_wrap = '';
                         ?>
                            <?php
                            if(has_nav_menu('primary')) {
                                wp_nav_menu(array(
                                    'theme_location' => 'primary',
                                    'menu_class' => 'mega-menu',
                                    'items_wrap' => $mokar_before_items_wrap . '<ul id="%1$s" class="%2$s">%3$s</ul>' . $mokar_after_item_wrap,
                                    'walker' => new Mokar_Primary_Walker_Nav_Menu()
                                        )
                                );
                            }
                            ?>   
				</nav>   
				<?php if(has_nav_menu('primary')) :?> 
				<div class="right-header">
					<?php  if ($mokar_settings['header-search']) {
								$mokar_search_template = mokar_get_search_form();
								echo '<div class="search-block-top">' . $mokar_search_template . '</div>';
							}
					?>
					<?php	 
						if (isset($mokar_settings['header-minicart-hiden']) && $mokar_settings['header-minicart-hiden'] && class_exists('WooCommerce')) :
						$mokar_minicart_template = mokar_get_minicart_template();?>
						<div id="mini-scart" class="mini-cart"> <?php echo wp_kses($mokar_minicart_template, mokar_allow_html()); ?> </div>
					<?php endif; ?>
				</div>  
				<?php endif;?>        
			</div>
		</div>
    </div>
</div>
<!-- Menu -->
