<?php $mokar_settings = mokar_check_theme_options(); ?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11" />
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) :?>
        <?php if (!empty($mokar_settings['favicon'])): ?>
            <link rel="shortcut icon" href="<?php echo esc_url(str_replace(array('http:', 'https:'), '', $mokar_settings['favicon']['url'])); ?>" type="image/x-icon" />
        <?php endif; ?>
    <?php endif;?>    
    <?php wp_head(); ?>
</head>
<?php
$mokar_sidebar_left = mokar_get_sidebar_left();
$mokar_sidebar_right = mokar_get_sidebar_right();
$mokar_layout = mokar_get_layout();
$header_type = mokar_get_header_type();
$mokar_remove_space_br = mokar_get_meta_value('remove_space_br', true);
$mokar_remove_space = mokar_get_meta_value('remove_space', true);
$mokar_header_fixed = get_post_meta(get_the_ID(), 'header_fixed', true);
$header_class = '';
if($mokar_header_fixed || (isset($mokar_settings['header-fixed']) && $mokar_settings['header-fixed'] && $header_type=='1')){
    $header_class .= ' fixed-header';
}
if (is_404() ) {
    $mokar_layout .=  'wide';
}
?>
<body <?php body_class(); ?>>
    <?php echo mokar_pre_loader();?>
	<div id="page" class="hfeed site <?php if(!$mokar_remove_space){echo 'remove_space';}?> 
                                     <?php if(!$mokar_remove_space_br){echo 'remove_space_br';}?> 
                                     <?php echo esc_attr($header_class);?>">
        <?php if(!is_page_template('coming-soon.php')) :?>                             
            <?php if (mokar_get_meta_value('show_header', true)) : ?>
                <header id="masthead" class="site-header header-v<?php echo esc_attr($header_type); ?>">
                    <?php get_template_part('headers/header_' . $header_type); ?>
                </header> <!-- End masthead -->
            <?php endif; ?>
            <?php get_template_part('breadcrumb'); ?>
        <?php endif;?>
        <?php mokar_get_page_banner();?>
        <div id="main" class="wrapper <?php if($mokar_layout == 'fullwidth'){echo 'boxed';}?>">
        <?php if(!is_page_template('coming-soon.php')) :?>
        <?php if($mokar_layout == 'fullwidth') :?>
            <div class="container">
				 <div class="row">    
			<?php else: ?>
			<div class="container-fluid">
			<?php endif;?> 
        <?php endif;?>    
                    
        
       
