<?php
$theme = wp_get_theme();
define('MOKAR_VERSION', $theme->get('Version'));
define('MOKAR_LIB', get_template_directory() . '/inc');
define('MOKAR_ADMIN', MOKAR_LIB . '/admin');
define('MOKAR_PLUGINS', MOKAR_LIB . '/plugins');
define('MOKAR_FUNCTIONS', MOKAR_LIB . '/functions');
define('MOKAR_METABOXES', MOKAR_FUNCTIONS . '/metaboxes');
define('MOKAR_CSS', get_template_directory_uri() . '/css');
define('MOKAR_JS', get_template_directory_uri() . '/js');

require_once(MOKAR_ADMIN . '/functions.php');
require_once(MOKAR_FUNCTIONS . '/functions.php');
require_once(MOKAR_METABOXES . '/functions.php');
require_once(MOKAR_PLUGINS . '/functions.php');
// Set up the content width value based on the theme's design and stylesheet.
if (!isset($content_width)) {
    $content_width = 1140;
}

if (!function_exists('mokar_setup')) {

    function mokar_setup() {
        load_theme_textdomain('mokar', get_template_directory() . '/languages');
        add_editor_style( array( 'style.css', 'style_rtl.css' ) );
        add_theme_support( 'title-tag' );
        add_theme_support('automatic-feed-links');
        add_theme_support( 'post-formats', array(
            'image', 'video', 'audio', 'quote', 'link', 'gallery',
        ) );
        // register menus
        register_nav_menus( array(
            'primary' => esc_html__('Primary Menu', 'mokar'),
        ));
        add_theme_support( 'custom-header' );
        add_theme_support( 'custom-background' );
        add_theme_support( 'post-thumbnails' );
   
		add_image_size('mokar-blog-grid', 570, 402, true);
		add_image_size('mokar-blog-list', 1175, 538, true);
		add_image_size('mokar-blog-detail', 1170, 718, true); 
        add_image_size('mokar-gallery-detail', 1172, 877, true);
        add_image_size('mokar-gallery-grid', 570, 427, true);
    }

}
add_action('after_setup_theme', 'mokar_setup');

add_action('admin_enqueue_scripts', 'mokar_admin_scripts_css');
function mokar_admin_scripts_css() {
    if(is_rtl()){
        wp_enqueue_style('mokar-admin-rtl-css', MOKAR_CSS . '/admin-rtl.css', false);
    }
    else{
        wp_enqueue_style('mokar-admin-css', MOKAR_CSS . '/admin.css', false);
    }
}
add_action('admin_enqueue_scripts', 'MOKAR_ADMIN_scripts_js');
function mokar_admin_scripts_js() {
    wp_register_script('mokar-admin-js', MOKAR_JS . '/un-minify/admin.js', array('common', 'jquery', 'media-upload', 'thickbox'), MOKAR_VERSION, true);
    wp_enqueue_script('mokar-admin-js');
}
function mokar_fonts_url() {
    $font_url = '';
    
    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'mokar' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Open Sans|Poppins:300,300italic,400,400italic,500,600,700italic,700&subset=latin,latin-ext' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}

//Disable all woocommerce styles
add_filter('woocommerce_enqueue_styles', '__return_false');

function mokar_scripts_js() {
    global $mokar_settings, $wp_query;
    $cat = $wp_query->get_queried_object();
    $header_type = mokar_get_header_type();
    if(isset($cat->term_id)){
    $woo_cat = $cat->term_id;
    }else{
        $woo_cat = '';
    }
    $shop_list = '';
    if ( class_exists( 'WooCommerce' ) ) {
    $shop_list = is_product_category();
    }
    $product_list_mode = get_metadata('product_cat', $woo_cat, 'list_mode_product', true);
    $header_sticky_mobile = isset($mokar_settings['header-sticky-mobile'])? $mokar_settings['header-sticky-mobile'] : '';   
    $mokar_text_day = (isset($mokar_settings['under-contr-day']) && $mokar_settings['under-contr-day'] != '') ? $mokar_settings['under-contr-day'] : 'Days'; 
    $mokar_text_hour = (isset($mokar_settings['under-contr-hour']) && $mokar_settings['under-contr-hour'] != '') ? $mokar_settings['under-contr-hour'] : 'Hours';  
    $mokar_text_min = (isset($mokar_settings['under-contr-min']) && $mokar_settings['under-contr-min'] != '') ? $mokar_settings['under-contr-min'] : 'Mins';  
    $mokar_text_sec = (isset($mokar_settings['under-contr-sec']) && $mokar_settings['under-contr-sec'] != '') ? $mokar_settings['under-contr-sec'] : 'Secs';   
    // comment reply
    if ( is_singular() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
    // Loads our main js.
    
    wp_enqueue_script('bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array('jquery'), MOKAR_VERSION, true);
    wp_enqueue_script('images-load', get_template_directory_uri() . '/js/imagesloaded.pkgd.min.js', array('jquery'), MOKAR_VERSION, true);
    wp_enqueue_script('isotope', get_template_directory_uri() . '/js/isotope.pkgd.min.js', array('jquery'), MOKAR_VERSION, true);  
    wp_enqueue_script('fancybox', get_template_directory_uri() . '/js/jquery.fancybox.pack.js', array('jquery'), MOKAR_VERSION, true);
    wp_enqueue_script('fancybox-thumbs', get_template_directory_uri() . '/js/jquery.fancybox-thumbs.js', array(), MOKAR_VERSION, true);
	wp_enqueue_script('cascadeslider', get_template_directory_uri() . '/js/cascade-slider.js', array('jquery'),MOKAR_VERSION, true);  
    wp_enqueue_script('owlcarousel', get_template_directory_uri() . '/js/owl.carousel.min.js', array('jquery'), MOKAR_VERSION, true);
    wp_enqueue_script('slick', get_template_directory_uri() . '/js/slick.min.js', array('jquery'), MOKAR_VERSION, true);
    
    wp_enqueue_script('countdown', get_template_directory_uri() . '/js/jquery.countdown.min.js', array('jquery'), MOKAR_VERSION, true);
    wp_enqueue_script('scrollreveal', get_template_directory_uri() . '/js/un-minify/scrollReveal.js', array('jquery'), MOKAR_VERSION, true);
    wp_enqueue_script('elevate-zoom', get_template_directory_uri() . '/js/un-minify/jquery.elevatezoom.js', array('jquery'), MOKAR_VERSION, true);
    wp_enqueue_script('appear', get_template_directory_uri() . '/js/un-minify/appear.js', array('jquery'), MOKAR_VERSION, true);   
    
    wp_enqueue_script('validate', get_template_directory_uri() . '/js/jquery.validate.min.js', array('jquery'), MOKAR_VERSION);
    if(is_rtl()){
        wp_enqueue_script('mokar-custom-rtl', get_template_directory_uri() . '/js/un-minify/custom-rtl.js', array('jquery'), MOKAR_VERSION, true);
    }
    else{
        wp_enqueue_script('mokar-custom', get_template_directory_uri() . '/js/un-minify/custom.js', array('jquery'), MOKAR_VERSION, true);
    }
    wp_enqueue_script('mokar-script', get_template_directory_uri() . '/js/un-minify/functions.js', array('jquery'), MOKAR_VERSION, true);
    if (isset($mokar_settings['js-code'])){
        wp_add_inline_script( 'mokar-script', $mokar_settings['js-code'] ); 
    }  
    wp_localize_script('mokar-script', 'mokar_params', array(
        'ajax_url' => esc_js(admin_url( 'admin-ajax.php' )),
        'ajax_loader_url' => esc_js(str_replace(array('http:', 'https'), array('', ''), MOKAR_CSS . '/images/ajax-loader.gif')),
        'ajax_cart_added_msg' => esc_html__('A product has been added to cart.', 'mokar'),
        'ajax_compare_added_msg' => esc_html__('A product has been added to compare', 'mokar'),
        'type_product' => $product_list_mode,
        'shop_list' => $shop_list,
        'under_end_date' => $mokar_settings['under-end-date'],
        'mokar_text_day' => $mokar_text_day,
        'mokar_text_hour' => $mokar_text_hour,
        'mokar_text_min' => $mokar_text_min,
        'mokar_text_sec' => $mokar_text_sec,
        'header_type' => $header_type,
        'header_sticky' => $mokar_settings['header-sticky'],
        'header_sticky_mobile' => $header_sticky_mobile,
        'request_error' => esc_js(__('The requested content cannot be loaded.<br/>Please try again later.', 'mokar')),
        'popup_close' => esc_js(__('Close', 'mokar')),
        'popup_prev' => esc_js(__('Previous', 'mokar')),
        'popup_next' => esc_js(__('Next', 'mokar')),
    ));
}
add_action('wp_enqueue_scripts', 'mokar_scripts_js');
function mokar_override_mce_options($initArray) {
    $opts = '*[*]';
    $initArray['valid_elements'] = $opts;
    $initArray['extended_valid_elements'] = $opts;
    return $initArray;
} 
add_filter('tiny_mce_before_init', 'mokar_override_mce_options'); 

function mokar_get_current_url($echo = true) {
    global $wp;
    if($echo) {
        echo home_url(add_query_arg(array(),$wp->request));
    } else {
        return home_url(add_query_arg(array(),$wp->request));
    }
}

if (class_exists( 'YITH_WOOCOMPARE' ) ){
    function mokar_compare_page_title($sep = '', $display = true, $title = '') {
        if($title != '') {
            return esc_attr($title);
        }
    }
    add_filter( 'wp_title', 'mokar_compare_page_title', 100, 3 );
}
//Defer parsing of JavaScript
if (!(is_admin() )) {
    function mokar_defer_parsing_of_js ( $url ) {
        if ( FALSE === strpos( $url, '.js' ) ) return $url;
        if ( strpos( $url, 'jquery.js' ) ) return $url;
        // return "$url' defer ";
        return "$url' defer onload='";
    }
    add_filter( 'clean_url', 'mokar_defer_parsing_of_js', 11, 1 );
}
