<?php

// arrowpress_product_order
add_shortcode('arrowpress_product_order', 'arrowpress_shortcode_product_order');
add_action('vc_build_admin_page', 'arrowpress_load_product_order_shortcode');
add_action('vc_after_init', 'arrowpress_load_product_order_shortcode');

function arrowpress_shortcode_product_order($atts, $content = null) {
    ob_start();
    if ($template = arrowpress_shortcode_woo_template('arrowpress_product_order'))
        include $template;
    return ob_get_clean();
}

function arrowpress_load_product_order_shortcode() {
    $custom_class = arrowpress_vc_custom_class();
    $order_by_values = arrowpress_vc_woo_order_by();
    $order_way_values = arrowpress_vc_woo_order_way();
    vc_map( array(
        'name' => "ArrowPress " . esc_html__('Product Order', 'arrowpress-shortcodes'),
        'base' => 'arrowpress_product_order',
        'category' => esc_html__('ArrowPress', 'arrowpress-shortcodes'),
        'icon' => 'arrowpress_vc_icon',
        'weight' => - 50,
        "params" => array( 
            array(
                'type' => 'autocomplete',
                'heading' => __( 'Select identificator', 'arrowpress-shortcodes' ),
                'param_name' => 'id',
                'description' => __( 'Input product ID or product SKU or product title to see suggestions', 'arrowpress-shortcodes' ),
                'admin_label' => true
            ),
            array(
                'type' => 'hidden',
                // This will not show on render, but will be used when defining value for autocomplete
                'param_name' => 'sku',
            ),
            $custom_class
        )
    ) );
    //Filters For autocomplete param:
    //For suggestion: vc_autocomplete_[shortcode_name]_[param_name]_callback
    add_filter( 'vc_autocomplete_arrowpress_product_order_id_callback', 'arrowpress_shortcode_product_id_callback', 10, 1 ); // Get suggestion(find). Must return an array
    add_filter( 'vc_autocomplete_arrowpress_product_order_id_render', 'arrowpress_shortcode_product_id_render', 10, 1 ); // Render exact product. Must return an array (label,value)
    //For param: ID default value filter
    add_filter( 'vc_form_fields_render_field_arrowpress_product_order_id_param_value', 'arrowpress_shortcode_product_id_param_value', 10, 4 ); // Defines default value for param if not provided. Takes from other param value.

    if (!class_exists('WPBakeryShortCode_Arrowpress_Product_Order')) {
        class WPBakeryShortCode_Arrowpress_Product_Order extends WPBakeryShortCode {
        }
    }
}
function arrowpress_shortcode_product_id_callback($query) {
    if (class_exists('Vc_Vendor_Woocommerce')) {
        $vc_vendor_wc = new Vc_Vendor_Woocommerce();
        return $vc_vendor_wc->productIdAutocompleteSuggester($query);
    }
    return '';
}

function arrowpress_shortcode_product_id_render($query) {
    if (class_exists('Vc_Vendor_Woocommerce')) {
        $vc_vendor_wc = new Vc_Vendor_Woocommerce();
        return $vc_vendor_wc->productIdAutocompleteRender($query);
    }
    return '';
}

function arrowpress_shortcode_product_id_param_value($current_value, $param_settings, $map_settings, $atts) {
    if (class_exists('Vc_Vendor_Woocommerce')) {
        $vc_vendor_wc = new Vc_Vendor_Woocommerce();
        return $vc_vendor_wc->productIdDefaultValue($current_value, $param_settings, $map_settings, $atts);
    }
    return '';
}