<?php

// arrowpress_product
add_shortcode('arrowpress_product', 'arrowpress_shortcode_product');
add_action('vc_build_admin_page', 'arrowpress_load_product_shortcode');
add_action('vc_after_init', 'arrowpress_load_product_shortcode');

function arrowpress_shortcode_product($atts, $content = null) {
    ob_start();
    if ($template = arrowpress_shortcode_woo_template('arrowpress_product'))
        include $template;
    return ob_get_clean();
}

function arrowpress_load_product_shortcode() {
    $custom_class = arrowpress_vc_custom_class();
    $order_by_values = arrowpress_vc_woo_order_by();
    $order_way_values = arrowpress_vc_woo_order_way();
    vc_map( array(
        'name' => "ArrowPress " . esc_html__('View Product', 'arrowpress-shortcodes'),
        'base' => 'arrowpress_product',
        'category' => esc_html__('ArrowPress', 'arrowpress-shortcodes'),
        'icon' => 'arrowpress_vc_icon',
        'weight' => - 50,
        "params" => array( 
			array(
                'type' => 'dropdown',
                'heading' => __( 'Layout', 'arrowpress-shortcodes' ),
                'param_name' => 'layout',
                'std' => '',
				'value' => array(
                    esc_html__('Product Filter', 'arrowpress-shortcodes') => 'filter',
                    esc_html__('Product Slide', 'arrowpress-shortcodes') => 'slide',
                ),
                "admin_label" => true,
            ),
			array(
                'type' => 'dropdown',
                'heading' => __( 'Shortcodes Layout', 'arrowpress-shortcodes' ),
                'param_name' => 'shortcodes_layout',
                'std' => '',
				'value' => array(
                    esc_html__('Rencent Products', 'arrowpress-shortcodes') => 'recent_products',
                    esc_html__('Featured Products', 'arrowpress-shortcodes') => 'featured_products',
                    esc_html__('Best-Selling Products', 'arrowpress-shortcodes') => 'best_selling_products',
                    esc_html__('Top Rated Products', 'arrowpress-shortcodes') => 'top_rated_products',
                    esc_html__('Sale Products', 'arrowpress-shortcodes') => 'sale_products',
                ),
                "admin_label" => true,
            ),
			 array(
                'type' => 'textarea',
                'heading' => __( 'Slogan', 'arrowpress-shortcodes' ),
                'param_name' => 'slogan',
                'admin_label' => true
            ),
            array(
                'type' => 'textfield',
                'heading' => __( 'Per page', 'arrowpress-shortcodes' ),
                'value' => 12,
                'param_name' => 'per_page',
                'description' => __( 'The "per_page" shortcode determines how many products to show on the page', 'arrowpress-shortcodes' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => __( 'Columns', 'arrowpress-shortcodes' ),
                'param_name' => 'columns',
                'std' => '4',
                'value' => arrowpress_sh_commons('products_columns'),
				'admin_label' => true,
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('filter')
                ),
            ),
			array(
                "type" => "textfield",
                "heading" => esc_html__("Slug Name", "arrowpress-shortcodes"),
                "param_name" => "slug_name",
                "value" => '',
                "admin_label" => true
            ),
            array(
                'type' => 'dropdown',
                'heading' => __( 'Order by', 'arrowpress-shortcodes' ),
                'param_name' => 'orderby',
                'value' => $order_by_values,
                'description' => sprintf( __( 'Select how to sort retrieved products. More at %s.', 'arrowpress-shortcodes' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' )
            ),
            array(
                'type' => 'dropdown',
                'heading' => __( 'Order way', 'arrowpress-shortcodes' ),
                'param_name' => 'order',
                'value' => $order_way_values,
                'description' => sprintf( __( 'Designates the ascending or descending order. More at %s.', 'arrowpress-shortcodes' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' )
            ),
			array(
                "type" => "checkbox",
                "heading" => esc_html__("Show view more", 'arrowpress-shortcodes'),
                "param_name" => "view_more",
				'std' => 'yes',
                'value' => array(esc_html__('Yes', 'arrowpress-shortcodes') => 'yes'),       
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('filter')
                ),
            ),
			array(
                "type" => "dropdown",
                "heading" => esc_html__("Number Column on Desktop Large (> 1200px)", "arrowpress-shortcodes"),
                "param_name" => "items_desktop_large",
                'std' => 3,
                'value' => array(
                    esc_html__('4', 'arrowpress-shortcodes') => 4,
                    esc_html__('3', 'arrowpress-shortcodes') => 3,
                    esc_html__('2', 'arrowpress-shortcodes') => 2,
                    esc_html__('1', 'arrowpress-shortcodes') => 1,
                ),
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('slide')
                ),
				'group' => esc_html__( 'Responsive Slide','arrowpress-shortcodes' ),
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Number Column on Desktop", "arrowpress-shortcodes"),
                "param_name" => "items_desktop",
                'std' => 2,
                'value' => array(
                    esc_html__('4', 'arrowpress-shortcodes') => 4,
                    esc_html__('3', 'arrowpress-shortcodes') => 3,
                    esc_html__('2', 'arrowpress-shortcodes') => 2,
                    esc_html__('1', 'arrowpress-shortcodes') => 1,
                ),
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('slide')
                ),
				'group' => esc_html__( 'Responsive Slide','arrowpress-shortcodes' )
            ),
            array(
                "type" => "dropdown",
                "heading" => __("Number Column on Tablets", "arrowpress"),
                "param_name" => "items_tablets",
                'std' => 2,
                'value' => array(
                    esc_html__('4', 'arrowpress-shortcodes') => 4,
                    esc_html__('3', 'arrowpress-shortcodes') => 3,
                    esc_html__('2', 'arrowpress-shortcodes') => 2,
                    esc_html__('1', 'arrowpress-shortcodes') => 1,
                ),
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('slide')
                ),
				'group' => esc_html__( 'Responsive Slide','arrowpress-shortcodes' )
            ),
            array(
                "type" => "dropdown",
                "heading" => __("Number Column on Mobile", "arrowpress"),
                "param_name" => "items_mobile",
                'std' => 1,
                'value' => array(
                    esc_html__('4', 'arrowpress-shortcodes') => 4,
                    esc_html__('3', 'arrowpress-shortcodes') => 3,
                    esc_html__('2', 'arrowpress-shortcodes') => 2,
                    esc_html__('1', 'arrowpress-shortcodes') => 1,
                ),
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('slide')
                ),
				'group' => esc_html__( 'Responsive Slide','arrowpress-shortcodes' )
            ),
            $custom_class
        )
    ) );

    if (!class_exists('WPBakeryShortCode_ArrowPress_Product')) {
        class WPBakeryShortCode_ArrowPress_Product extends WPBakeryShortCode {
        }
    }
}