<?php

add_shortcode('arrowpress_member', 'arrowpress_shortcode_member');
add_action('vc_build_admin_page', 'arrowpress_load_member_shortcode');
add_action('vc_after_init', 'arrowpress_load_member_shortcode');

function arrowpress_shortcode_member($atts, $content = null) {
    ob_start();
    if ($template = arrowpress_shortcode_template('arrowpress_member'))
        include $template;
    return ob_get_clean();
}

function arrowpress_load_member_shortcode() {
    $custom_class = arrowpress_vc_custom_class();
    $animation_type = arrowpress_animation_custom();

    vc_map( array(
        'name' => "ArrowPress" . esc_html__(' Member', 'arrowpress-shortcodes'),
        'base' => 'arrowpress_member',
        'category' => esc_html__('ArrowPress', 'arrowpress-shortcodes'),
        'icon' => 'arrowpress_vc_icon',
        'weight' => - 50,
        "params" => array(
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Layout", "arrowpress-shortcodes"),
                "param_name" => "layout",
                'std' => 'slide',
                'value' => array(
                    esc_html__('Layout 1', 'arrowpress-shortcodes') => 'layout1',
                    esc_html__('Layout 2', 'arrowpress-shortcodes') => 'layout2',
                ),
            ), 
            array(
                'type' => 'attach_image',
                'heading' => esc_html__('Image', 'arrowpress-shortcodes'),
                'param_name' => 'image',
                'value' => '',
                'description' => esc_html__( 'Upload image.', 'arrowpress-shortcodes' ),
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Name", 'arrowpress-shortcodes'),
                "param_name" => "name",
                "admin_label" => true,
            ),  
            array(
                "type" => "textarea",
                "heading" => esc_html__("Job", "arrowpress-shortcodes"),
                "param_name" => "job",
            ),
			array(
                "type" => "textarea",
                "heading" => esc_html__("Description", "arrowpress-shortcodes"),
                "param_name" => "description",
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('layout1'),
                ),   
            ),
            array(
                'type' => 'checkbox',
                'heading' => esc_html__("Show Socials", "arrowpress-shortcodes"),
                'param_name' => 'show_socials',
                'std' => 'Yes',
                'value' => array(esc_html__('Yes', 'arrowpress-shortcodes') => 'yes')
            ),
             array(
                 "type" => "vc_link",
                "heading" => esc_html__("Facebook", 'arrowpress-shortcodes'),
                "param_name" => "facebook_link",
                'dependency' => array(
                    'element' => 'show_socials',
                    'value' => 'yes',
                ),
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Instagram", 'arrowpress-shortcodes'),
                "param_name" => "instagram_link",
                'dependency' => array(
                    'element' => 'show_socials',
                    'value' => 'yes',
                ),
            ),
             array(
                "type" => "vc_link",
                "heading" => esc_html__("Twitter", 'arrowpress-shortcodes'),
                "param_name" => "twitter_link",
                'dependency' => array(
                    'element' => 'show_socials',
                    'value' => 'yes',
                ),
            ),
            array(
                 "type" => "vc_link",
                "heading" => esc_html__("Dribbble", 'arrowpress-shortcodes'),
                "param_name" => "dribbble_link",
                'dependency' => array(
                    'element' => 'show_socials',
                    'value' => 'yes',
                ),
            ),
             array(
                 "type" => "vc_link",
                "heading" => esc_html__("Print", 'arrowpress-shortcodes'),
                "param_name" => "print_link",
                'dependency' => array(
                    'element' => 'show_socials',
                    'value' => 'yes',
                ),
            ),
            $custom_class,
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','arrowpress-shortcodes' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','arrowpress-shortcodes' ),
            )
        )
    ) );

    if (!class_exists('WPBakeryShortCode_arrowpress_Member')) {
        class WPBakeryShortCode_arrowpress_Member extends WPBakeryShortCode {
        }
    }
}