<?php

add_shortcode('arrowpress_blog', 'arrowpress_shortcode_blog');
add_action('vc_build_admin_page', 'arrowpress_load_blog_shortcode');
add_action('vc_after_init', 'arrowpress_load_blog_shortcode');

function arrowpress_shortcode_blog($atts, $content = null) {
    ob_start();
    if ($template = arrowpress_shortcode_template('arrowpress_blog'))
        include $template;
    return ob_get_clean();
}

function arrowpress_load_blog_shortcode() {
    $custom_class = arrowpress_vc_custom_class();
    $order_by_values = arrowpress_vc_woo_order_by();
    $order_way_values = arrowpress_vc_woo_order_way();
    vc_map( array(
        'name' => "ArrowPress " . esc_html__('Blog', 'arrowpress-shortcodes'),
        'base' => 'arrowpress_blog',
        'category' => esc_html__('ArrowPress', 'arrowpress-shortcodes'),
        'icon' => 'arrowpress_vc_icon',
        'weight' => - 50,
        "params" => array(
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Layout", 'arrowpress-shortcodes'),
                "param_name" => "layout",
                'std' => 'Slide Style 1',
                'value' => array(
                    esc_html__('Slide Style 1', 'arrowpress-shortcodes') => 'slide_style_1',
                    esc_html__('List Style 1', 'arrowpress-shortcodes') => 'list_style_1',
                ),
                "admin_label" => true,
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Posts Count", "arrowpress-shortcodes"),
                "param_name" => "number",
                "value" => "3",
                "admin_label" => true
            ),  
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Number of rows", "arrowpress-shortcodes"),
                "param_name" => "row_number",
                'std' => 3,
                'value' => array(
                    esc_html__('4', 'arrowpress-shortcodes') => 4,
                    esc_html__('3', 'arrowpress-shortcodes') => 3,
                    esc_html__('2', 'arrowpress-shortcodes') => 2,
                    esc_html__('1', 'arrowpress-shortcodes') => 1,
                ),
                "dependency" => array(
                    'element' => 'layout',
                    'value' => array('slide_style_1')
                )
            ),                   
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Number Column on Desktop Large (> 1200px)", "arrowpress-shortcodes"),
                "param_name" => "items_desktop_large",
                'std' => 3,
                'value' => array(
                    esc_html__('4', 'arrowpress-shortcodes') => 4,
                    esc_html__('3', 'arrowpress-shortcodes') => 3,
                    esc_html__('2', 'arrowpress-shortcodes') => 2,
                    esc_html__('1', 'arrowpress-shortcodes') => 1,
                ),
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('slide_style_1')
                )
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Number Column on Desktop", "arrowpress-shortcodes"),
                "param_name" => "items_desktop",
                'std' => 2,
                'value' => array(
                    esc_html__('4', 'arrowpress-shortcodes') => 4,
                    esc_html__('3', 'arrowpress-shortcodes') => 3,
                    esc_html__('2', 'arrowpress-shortcodes') => 2,
                    esc_html__('1', 'arrowpress-shortcodes') => 1,
                ),
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('slide_style_1')
                )
            ),
            array(
                "type" => "dropdown",
                "heading" => __("Number Column on Tablets", "arrowpress"),
                "param_name" => "items_tablets",
                'std' => 2,
                'value' => array(
                    esc_html__('4', 'arrowpress-shortcodes') => 4,
                    esc_html__('3', 'arrowpress-shortcodes') => 3,
                    esc_html__('2', 'arrowpress-shortcodes') => 2,
                    esc_html__('1', 'arrowpress-shortcodes') => 1,
                ),
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('')
                )
            ),
            array(
                "type" => "dropdown",
                "heading" => __("Number Column on Mobile", "arrowpress"),
                "param_name" => "items_mobile",
                'std' => 1,
                'value' => array(
                    esc_html__('4', 'arrowpress-shortcodes') => 4,
                    esc_html__('3', 'arrowpress-shortcodes') => 3,
                    esc_html__('2', 'arrowpress-shortcodes') => 2,
                    esc_html__('1', 'arrowpress-shortcodes') => 1,
                ),
				"dependency" => array(
                    'element' => 'layout',
                    'value' => array('')
                )
            ),
            $custom_class,
            // post type
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Display", 'arrowpress-shortcodes'),
                "param_name" => "post_display_type",
                'std' => '',
                'value' => array(
                    esc_html__('Recent', 'arrowpress-shortcodes') => 'recent',
                    esc_html__('Featured', 'arrowpress-shortcodes') => 'featured',
                    esc_html__('Most Viewed', 'arrowpress-shortcodes') => 'most-viewed',
                ),
                "admin_label" => true,
                'group' => 'Data'
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Order by', 'arrowpress-shortcodes' ),
                'param_name' => 'orderby',
                'value' => $order_by_values,
                'description' => sprintf( esc_html__( 'Select how to sort retrieved products_category. More at %s.', 'arrowpress-shortcodes' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
                'group' => 'Data'
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Order way', 'arrowpress-shortcodes' ),
                'param_name' => 'order',
                'value' => $order_way_values,
                'description' => sprintf( esc_html__( 'Designates the ascending or descending order. More at %s.', 'arrowpress-shortcodes' ), '<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex page</a>' ),
                'group' => 'Data'
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Category IDs", "arrowpress-shortcodes"),
                "description" => esc_html__("Comma separated list of category ids", "arrowpress-shortcodes"),
                "param_name" => "cat",
                "admin_label" => true,
                'group' => 'Data'
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__("Slug Name Category", "arrowpress-shortcodes"),
                "param_name" => "slug_name",
                "value" => "",
                "admin_label" => true,
                'group' => 'Data'
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'arrowpress-shortcodes' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'arrowpress-shortcodes' ),
            ),
        )
    ) );

    if (!class_exists('WPBakeryShortCode_arrowpress_Blog')) {
        class WPBakeryShortCode_arrowpress_Blog extends WPBakeryShortCode {
        }
    }
}