<?php
/**
* Plugin Name: ArrowPress Importer
* Description: ArrowPress One click demo import 
* Version: 1.0
* Author: ArrowPress
* Author URI: http://arrowpress.net/
*/

// don't load directly
if (!defined('ABSPATH'))
    die('-1');


define('ARROWPRESS_IMPORTER_URL', plugin_dir_url(__FILE__));
// require_once( 'inc/functions.php' );
require_once( 'one-click-demo-import/one-click-demo-import.php' );


/** Enqueue admin style file for import page */
add_action('admin_enqueue_scripts', 'arrowpress_importer_enqueue'); 
function arrowpress_importer_enqueue() {
  	wp_enqueue_style('arrowpress_importer_style', plugin_dir_url(__FILE__) . 'assets/css/style.css');
}

/**
 * Import file setup
 */
if ( ! function_exists( 'arrowpress_importer_files' ) ) {
	function arrowpress_importer_files() {
		$demo_link = 'demo.arrowpress.net/modus/';
	  	return array(
		        array(
		            'import_file_name'             => 'Base Content',
		            'categories'                   => array( 'Base Content'),
		            'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/data/content.xml',
		            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/data/widget.wie',
		            // 'local_import_customizer_file' => trailingslashit( get_template_directory() ) . '/demo/default/customizer.dat',
		            'import_preview_image_url'     => trailingslashit( ARROWPRESS_IMPORTER_URL ) .'assets/images/home1.jpg',
		            'import_notice'                => __( 'Please waiting for a few minutes, do not close the window or refresh the page until the data is imported.', 'arrowpress_importer' ),
		        ),
		       	array(
		            'import_file_name'             => 'Home Furniture',
		            'categories'                 => array( 'Home Demos'),
		            'import_preview_image_url'     => trailingslashit( ARROWPRESS_IMPORTER_URL ) .'assets/images/home1.jpg',
		            'import_notice'                => __( 'Please waiting for a few minutes, do not close the window or refresh the page until the data is imported.', 'arrowpress_importer' ),
		            'preview_url'                => $demo_link.'furniture',
		        ),  
		       	array(
		             'import_file_name'             => 'Home Furniture 2',
		             'categories'                 => array( 'Home Demos'),
		             //'local_import_file'            => trailingslashit( get_template_directory() ) . 'data/home2/content.xml',
		             'import_preview_image_url'     => trailingslashit( ARROWPRESS_IMPORTER_URL ) .'assets/images/home2.jpg',
		             'import_notice'                => __( 'Please waiting for a few minutes, do not close the window or refresh the page until the data is imported.', 'arrowpress_importer' ),
		             'preview_url'                => $demo_link.'furniture-2',
		        ), 
		       	array(
		            'import_file_name'             => 'Home Market',
		            'categories'                 => array( 'Home Demos'),
		            // 'local_import_file'            => trailingslashit( get_template_directory() ) . 'data/home2/content.xml',
		            'import_preview_image_url'     => trailingslashit( ARROWPRESS_IMPORTER_URL ) .'assets/images/home3.jpg',
		            'import_notice'                => __( 'Please waiting for a few minutes, do not close the window or refresh the page until the data is imported.', 'arrowpress_importer' ),
		            'preview_url'                => $demo_link.'home-market',
		        ), 	
		       	array(
		            'import_file_name'             => 'Home Interiors',
		            'categories'                 => array( 'Home Demos'),
		            // 'local_import_file'            => trailingslashit( get_template_directory() ) . 'data/home2/content.xml',
		            'import_preview_image_url'     => trailingslashit( ARROWPRESS_IMPORTER_URL ) .'assets/images/home4.jpg',
		            'import_notice'                => __( 'Please waiting for a few minutes, do not close the window or refresh the page until the data is imported.', 'arrowpress_importer' ),
		            'preview_url'                => $demo_link.'furniture-4',
		        ), 	
		       	array(
		             'import_file_name'             => 'Home Woods Shop',
		             'categories'                 => array( 'Home Demos'),
		             // 'local_import_file'            => trailingslashit( get_template_directory() ) . 'data/home2/content.xml',
		             'import_preview_image_url'     => trailingslashit( ARROWPRESS_IMPORTER_URL ) .'assets/images/home5.jpg',
		             'import_notice'                => __( 'Please waiting for a few minutes, do not close the window or refresh the page until the data is imported.', 'arrowpress_importer' ),
		             'preview_url'                => $demo_link.'furniture-5',
		        ), 	
		       	array(
		            'import_file_name'             => 'Home TS Glass',
		            'categories'                 => array( 'Home Demos'),
		            // 'local_import_file'            => trailingslashit( get_template_directory() ) . 'data/home2/content.xml',
		            'import_preview_image_url'     => trailingslashit( ARROWPRESS_IMPORTER_URL ) .'assets/images/home6.jpg',
		            'import_notice'                => __( 'Please waiting for a few minutes, do not close the window or refresh the page until the data is imported.', 'arrowpress_importer' ),
		            'preview_url'                => $demo_link.'furniture-6',
		        ), 
		       	array(
					'import_file_name'             => 'Home Equipment',
		             'categories'                 => array( 'Home Demos'),
		             // 'local_import_file'            => trailingslashit( get_template_directory() ) . 'data/home2/content.xml',
		             'import_preview_image_url'     => trailingslashit( ARROWPRESS_IMPORTER_URL ) .'assets/images/home7.jpg',
		             'import_notice'                => __( 'Please waiting for a few minutes, do not close the window or refresh the page until the data is imported.', 'arrowpress_importer' ),
		             'preview_url'                => $demo_link.'furniture-7',
		        ), 	
                array(
                     'import_file_name'             => 'Home Fabric',
                     'categories'                 => array( 'Home Demos'),
                     // 'local_import_file'            => trailingslashit( get_template_directory() ) . 'data/home2/content.xml',
                     'import_preview_image_url'     => trailingslashit( ARROWPRESS_IMPORTER_URL ) .'assets/images/home8.jpg',
                     'import_notice'                => __( 'Please waiting for a few minutes, do not close the window or refresh the page until the data is imported.', 'arrowpress_importer' ),
                     'preview_url'                => $demo_link.'furniture-8',
                ),  
                array(
                     'import_file_name'             => 'Home Interiors 2',
                     'categories'                 => array( 'Home Demos'),
                     // 'local_import_file'            => trailingslashit( get_template_directory() ) . 'data/home2/content.xml',
                     'import_preview_image_url'     => trailingslashit( ARROWPRESS_IMPORTER_URL ) .'assets/images/home9.jpg',
                     'import_notice'                => __( 'Please waiting for a few minutes, do not close the window or refresh the page until the data is imported.', 'arrowpress_importer' ),
                     'preview_url'                => $demo_link.'furniture-9',
                ), 
				array(
                     'import_file_name'             => 'Home Minimals',
                     'categories'                 => array( 'Home Demos'),
                     // 'local_import_file'            => trailingslashit( get_template_directory() ) . 'data/home2/content.xml',
                     'import_preview_image_url'     => trailingslashit( ARROWPRESS_IMPORTER_URL ) .'assets/images/home10.jpg',
                     'import_notice'                => __( 'Please waiting for a few minutes, do not close the window or refresh the page until the data is imported.', 'arrowpress_importer' ),
                     'preview_url'                => $demo_link.'furniture-10',
                ),  
				array(
                     'import_file_name'             => 'Home Instagram',
                     'categories'                 => array( 'Home Demos'),
                     // 'local_import_file'            => trailingslashit( get_template_directory() ) . 'data/home2/content.xml',
                     'import_preview_image_url'     => trailingslashit( ARROWPRESS_IMPORTER_URL ) .'assets/images/home11.jpg',
                     'import_notice'                => __( 'Please waiting for a few minutes, do not close the window or refresh the page until the data is imported.', 'arrowpress_importer' ),
                     'preview_url'                => $demo_link.'home-instagram',
                ),  
				array(
                     'import_file_name'             => 'Home Granite',
                     'categories'                 => array( 'Home Demos'),
                     // 'local_import_file'            => trailingslashit( get_template_directory() ) . 'data/home2/content.xml',
                     'import_preview_image_url'     => trailingslashit( ARROWPRESS_IMPORTER_URL ) .'assets/images/home12.jpg',
                     'import_notice'                => __( 'Please waiting for a few minutes, do not close the window or refresh the page until the data is imported.', 'arrowpress_importer' ),
                     'preview_url'                => $demo_link.'home-granite',
                ),  
				array(
                     'import_file_name'             => 'Home Decor',
                     'categories'                 => array( 'Home Demos'),
                     // 'local_import_file'            => trailingslashit( get_template_directory() ) . 'data/home2/content.xml',
                     'import_preview_image_url'     => trailingslashit( ARROWPRESS_IMPORTER_URL ) .'assets/images/home13.jpg',
                     'import_notice'                => __( 'Please waiting for a few minutes, do not close the window or refresh the page until the data is imported.', 'arrowpress_importer' ),
                     'preview_url'                => $demo_link.'home-decor',
                ), 
		  	);
	}
	add_filter( 'pt-ocdi/import_files', 'arrowpress_importer_files' );
}


/**
 * Steps after importing content: 
 * 
 * - Set menu location
 * - Import theme options
 * - Set front page & blog page
 * - Import slider
 */
if ( ! function_exists( 'arrowpress_importer_after_import' ) ) {
	function arrowpress_importer_after_import( $selected_import ) {
    	global $wp_filesystem; 
            if ( empty( $wp_filesystem ) ) {
                require_once ABSPATH . '/wp-admin/includes/file.php';
                WP_Filesystem();
            }	
    		$chosen_template = $selected_import['import_file_name'];

    	    if ( 'Base Content' === $selected_import['import_file_name'] ) {

    	       	//Set Main Menu
    			$main_menu = get_term_by( 'name', 'Menu Primary', 'nav_menu' );
    			set_theme_mod( 'nav_menu_locations', array(
    					'primary' => $main_menu->term_id,
    				)
    			); 

                
                echo 'Delete Default Post and Page \n';

                /** Delete Hello Post */
    		    wp_delete_post( 1, true );

    		    /** Delete "Sample Page" Page */
    		    wp_delete_post( 2, true );

                // /*Widgets*/
                // $widgets_file = ARROWPRESS_IMPORTER_URL . 'data/widget_data.json';
                // echo $widgets_file;
                // // if ( file_exists( $widgets_file ) ) {
                // 	echo 'file exits';
                //     $encode_widgets_array = $wp_filesystem->get_contents( $widgets_file );
                //     arrowpress_import_widgets( $encode_widgets_array );
                //     print_r($encode_widgets_array);
                // // }	
                
    	    }elseif('Home Furniture' === $selected_import['import_file_name']){

    	    	echo "Import Theme Options \n";	
    	    	ob_start();
                include(plugin_dir_path( __FILE__ ) . '/data/home1/theme_options.php');
                $theme_options = ob_get_clean();

                $options = json_decode($theme_options, true);
                $redux = ReduxFrameworkInstances::get_instance('modus_settings');
                $redux->set_options($options);
                modus_save_theme_settings();

                //front page
                echo "Set Front Page \n";	
                $front_page = get_page_by_title( 'Home Furniture' );
                if ( isset( $front_page->ID ) ) {
                    update_option( 'page_on_front', $front_page->ID );
                    update_option( 'show_on_front', 'page' );
                }

                $blog_page = get_page_by_title( 'Blog' );
                if ( isset( $blog_page->ID ) ) {
                    update_option( 'page_for_posts', $blog_page->ID );
                }	
                echo "Start Import Slider \n";	    	
                if ( class_exists( 'RevSlider' ) ) {
                    $main_slider = plugin_dir_path( __FILE__ ) . '/data/home1/home.zip';

                    if ( file_exists( $main_slider ) ) {
                        $slider = new RevSlider();
                        $slider->importSliderFromPost( true, true, $main_slider );
                    }
                } 
    		}elseif('Home Furniture 2' === $selected_import['import_file_name']){
                echo "Import Theme Options \n"; 
                ob_start();
                include(plugin_dir_path( __FILE__ ) . '/data/home2/theme_options.php');
                $theme_options = ob_get_clean();

                $options = json_decode($theme_options, true);
                $redux = ReduxFrameworkInstances::get_instance('modus_settings');
                $redux->set_options($options);
                modus_save_theme_settings();
                //front page
                $front_page = get_page_by_title( 'Home Furniture 2' );
                if ( isset( $front_page->ID ) ) {
                    update_option( 'page_on_front', $front_page->ID );
                    update_option( 'show_on_front', 'page' );
                }

                $blog_page = get_page_by_title( 'Blog' );
                if ( isset( $blog_page->ID ) ) {
                    update_option( 'page_for_posts', $blog_page->ID );
                }

                if ( class_exists( 'RevSlider' ) ) {
                    $main_slider = plugin_dir_path( __FILE__ ) . '/data/home2/home.zip';

                    if ( file_exists( $main_slider ) ) {
                        $slider = new RevSlider();
                        $slider->importSliderFromPost( true, true, $main_slider );
                    }
                }  			
    		}elseif('Home Market' === $selected_import['import_file_name']) {
                //Theme Options    
                ob_start();
                include(plugin_dir_path( __FILE__ ) . 'data/home3/theme_options.php');
                $theme_options = ob_get_clean();

                $options = json_decode($theme_options, true);
                $redux = ReduxFrameworkInstances::get_instance('modus_settings');
                $redux->set_options($options);
                modus_save_theme_settings();
                //front page
                $front_page = get_page_by_title( 'Home Market' );
                if ( isset( $front_page->ID ) ) {
                    update_option( 'page_on_front', $front_page->ID );
                    update_option( 'show_on_front', 'page' );
                }

                $blog_page = get_page_by_title( 'Blog' );
                if ( isset( $blog_page->ID ) ) {
                    update_option( 'page_for_posts', $blog_page->ID );
                }   
                if ( class_exists( 'RevSlider' ) ) {
                    $main_slider = plugin_dir_path( __FILE__ ) . '/data/home3/home-3.zip';

                    if ( file_exists( $main_slider ) ) {
                        $slider = new RevSlider();
                        $slider->importSliderFromPost( true, true, $main_slider );
                    }
                }             
            }elseif('Home Interiors' === $selected_import['import_file_name']) {
                //Theme Options    
                ob_start();
                include(plugin_dir_path( __FILE__ ) .'data/home4/theme_options.php');
                $theme_options = ob_get_clean();

                $options = json_decode($theme_options, true);
                $redux = ReduxFrameworkInstances::get_instance('modus_settings');
                $redux->set_options($options);
                modus_save_theme_settings();
                //front page
                $front_page = get_page_by_title( 'Home Interiors' );
                if ( isset( $front_page->ID ) ) {
                    update_option( 'page_on_front', $front_page->ID );
                    update_option( 'show_on_front', 'page' );
                }

                $blog_page = get_page_by_title( 'Blog' );
                if ( isset( $blog_page->ID ) ) {
                    update_option( 'page_for_posts', $blog_page->ID );
                }

                if ( class_exists( 'RevSlider' ) ) {
                    $main_slider = plugin_dir_path( __FILE__ ) . '/data/home4/furniture_4.zip';

                    if ( file_exists( $main_slider ) ) {
                        $slider = new RevSlider();
                        $slider->importSliderFromPost( true, true, $main_slider );
                    }
                }     
            }
            // Home 5
            elseif('Home Woods Shop' === $selected_import['import_file_name']) {
                //Theme Options    
                ob_start();
                include(plugin_dir_path( __FILE__ ) .'data/home5/theme_options.php');
                $theme_options = ob_get_clean();

                $options = json_decode($theme_options, true);
                $redux = ReduxFrameworkInstances::get_instance('modus_settings');
                $redux->set_options($options);
                modus_save_theme_settings();
                //front page
                $front_page = get_page_by_title( 'Home Woods Shop' );
                if ( isset( $front_page->ID ) ) {
                    update_option( 'page_on_front', $front_page->ID );
                    update_option( 'show_on_front', 'page' );
                }

                $blog_page = get_page_by_title( 'Blog' );
                if ( isset( $blog_page->ID ) ) {
                    update_option( 'page_for_posts', $blog_page->ID );
                }

                if ( class_exists( 'RevSlider' ) ) {
                    $main_slider = plugin_dir_path( __FILE__ ) . '/data/home5/fumiture5.zip';

                    if ( file_exists( $main_slider ) ) {
                        $slider = new RevSlider();
                        $slider->importSliderFromPost( true, true, $main_slider );
                    }
                }    
            }
            // Home 6
            elseif('Home TS Glass' === $selected_import['import_file_name']) {
                //Theme Options    
                ob_start();
                include(plugin_dir_path( __FILE__ ) .'data/home6/theme_options.php');
                $theme_options = ob_get_clean();

                $options = json_decode($theme_options, true);
                $redux = ReduxFrameworkInstances::get_instance('modus_settings');
                $redux->set_options($options);
                modus_save_theme_settings();
                //front page
                $front_page = get_page_by_title( 'Home TS Glass' );
                if ( isset( $front_page->ID ) ) {
                    update_option( 'page_on_front', $front_page->ID );
                    update_option( 'show_on_front', 'page' );
                }

                $blog_page = get_page_by_title( 'Blog' );
                if ( isset( $blog_page->ID ) ) {
                    update_option( 'page_for_posts', $blog_page->ID );
                }

                if ( class_exists( 'RevSlider' ) ) {
                    $main_slider = plugin_dir_path( __FILE__ ) . '/data/home6/fumiture_6.zip';

                    if ( file_exists( $main_slider ) ) {
                        $slider = new RevSlider();
                        $slider->importSliderFromPost( true, true, $main_slider );
                    }
                }                   
       
            }
            // Home 7
            elseif('Home Equipment' === $selected_import['import_file_name']) {
                //Theme Options    
                ob_start();
                include(plugin_dir_path( __FILE__ ) . 'data/home7/theme_options.php');
                $theme_options = ob_get_clean();

                $options = json_decode($theme_options, true);
                $redux = ReduxFrameworkInstances::get_instance('modus_settings');
                $redux->set_options($options);
                modus_save_theme_settings();
                //front page
                $front_page = get_page_by_title( 'Home Equipment' );
                if ( isset( $front_page->ID ) ) {
                    update_option( 'page_on_front', $front_page->ID );
                    update_option( 'show_on_front', 'page' );
                }

                $blog_page = get_page_by_title( 'Blog' );
                if ( isset( $blog_page->ID ) ) {
                    update_option( 'page_for_posts', $blog_page->ID );
                }

                if ( class_exists( 'RevSlider' ) ) {
                    $main_slider = plugin_dir_path( __FILE__ ) . '/data/home7/fumiture7.zip';

                    if ( file_exists( $main_slider ) ) {
                        $slider = new RevSlider();
                        $slider->importSliderFromPost( true, true, $main_slider );
                    }
                }    
            }     
            // Home 8
            elseif('Home Fabric' === $selected_import['import_file_name']) {
                //Theme Options    
                ob_start();
                include(plugin_dir_path( __FILE__ ) . 'data/home8/theme_options.php');
                $theme_options = ob_get_clean();

                $options = json_decode($theme_options, true);
                $redux = ReduxFrameworkInstances::get_instance('modus_settings');
                $redux->set_options($options);
                modus_save_theme_settings();
                //front page
                $front_page = get_page_by_title( 'Home Fabric' );
                if ( isset( $front_page->ID ) ) {
                    update_option( 'page_on_front', $front_page->ID );
                    update_option( 'show_on_front', 'page' );
                }

                $blog_page = get_page_by_title( 'Blog' );
                if ( isset( $blog_page->ID ) ) {
                    update_option( 'page_for_posts', $blog_page->ID );
                }

                if ( class_exists( 'RevSlider' ) ) {
                    $main_slider = plugin_dir_path( __FILE__ ) . '/data/home8/furniture-8.zip';

                    if ( file_exists( $main_slider ) ) {
                        $slider = new RevSlider();
                        $slider->importSliderFromPost( true, true, $main_slider );
                    }
                }    
            }                 
    	// Home 9
            elseif('Home Interiors 2' === $selected_import['import_file_name']) {
                //Theme Options    
                ob_start();
                include(plugin_dir_path( __FILE__ ) . 'data/home9/theme_options.php');
                $theme_options = ob_get_clean();

                $options = json_decode($theme_options, true);
                $redux = ReduxFrameworkInstances::get_instance('modus_settings');
                $redux->set_options($options);
                modus_save_theme_settings();
                //front page
                $front_page = get_page_by_title( 'Home Interiors 2' );
                if ( isset( $front_page->ID ) ) {
                    update_option( 'page_on_front', $front_page->ID );
                    update_option( 'show_on_front', 'page' );
                }

                $blog_page = get_page_by_title( 'Blog' );
                if ( isset( $blog_page->ID ) ) {
                    update_option( 'page_for_posts', $blog_page->ID );
                }

                if ( class_exists( 'RevSlider' ) ) {
                    $main_slider = plugin_dir_path( __FILE__ ) . '/data/home9/furniture9.zip';

                    if ( file_exists( $main_slider ) ) {
                        $slider = new RevSlider();
                        $slider->importSliderFromPost( true, true, $main_slider );
                    }
                }    
            } 
		// Home 10
			elseif('Home Minimals' === $selected_import['import_file_name']) {
                //Theme Options    
                ob_start();
                include(plugin_dir_path( __FILE__ ) . 'data/home10/theme_options.php');
                $theme_options = ob_get_clean();

                $options = json_decode($theme_options, true);
                $redux = ReduxFrameworkInstances::get_instance('modus_settings');
                $redux->set_options($options);
                modus_save_theme_settings();
                //front page
                $front_page = get_page_by_title( 'Home Minimals' );
                if ( isset( $front_page->ID ) ) {
                    update_option( 'page_on_front', $front_page->ID );
                    update_option( 'show_on_front', 'page' );
                }

                $blog_page = get_page_by_title( 'Blog' );
                if ( isset( $blog_page->ID ) ) {
                    update_option( 'page_for_posts', $blog_page->ID );
                }

                if ( class_exists( 'RevSlider' ) ) {
                    $main_slider = plugin_dir_path( __FILE__ ) . '/data/home10/furniture10.zip';

                    if ( file_exists( $main_slider ) ) {
                        $slider = new RevSlider();
                        $slider->importSliderFromPost( true, true, $main_slider );
                    }
                }    
            }  
		// Home 11
			elseif('Home Instagram' === $selected_import['import_file_name']) {
                //Theme Options    
                ob_start();
                include(plugin_dir_path( __FILE__ ) . 'data/home11/theme_options.php');
                $theme_options = ob_get_clean();

                $options = json_decode($theme_options, true);
                $redux = ReduxFrameworkInstances::get_instance('modus_settings');
                $redux->set_options($options);
                modus_save_theme_settings();
                //front page
                $front_page = get_page_by_title( 'Home Instagram' );
                if ( isset( $front_page->ID ) ) {
                    update_option( 'page_on_front', $front_page->ID );
                    update_option( 'show_on_front', 'page' );
                }

                $blog_page = get_page_by_title( 'Blog' );
                if ( isset( $blog_page->ID ) ) {
                    update_option( 'page_for_posts', $blog_page->ID );
                }

                if ( class_exists( 'RevSlider' ) ) {
                    $main_slider = plugin_dir_path( __FILE__ ) . '/data/home11/furniture11.zip';

                    if ( file_exists( $main_slider ) ) {
                        $slider = new RevSlider();
                        $slider->importSliderFromPost( true, true, $main_slider );
                    }
                }    
            }  
		// Home 12
			elseif('Home Granite' === $selected_import['import_file_name']) {
                //Theme Options    
                ob_start();
                include(plugin_dir_path( __FILE__ ) . 'data/home12/theme_options.php');
                $theme_options = ob_get_clean();

                $options = json_decode($theme_options, true);
                $redux = ReduxFrameworkInstances::get_instance('modus_settings');
                $redux->set_options($options);
                modus_save_theme_settings();
                //front page
                $front_page = get_page_by_title( 'Home Granite' );
                if ( isset( $front_page->ID ) ) {
                    update_option( 'page_on_front', $front_page->ID );
                    update_option( 'show_on_front', 'page' );
                }

                $blog_page = get_page_by_title( 'Blog' );
                if ( isset( $blog_page->ID ) ) {
                    update_option( 'page_for_posts', $blog_page->ID );
                }

                if ( class_exists( 'RevSlider' ) ) {
                    $main_slider = plugin_dir_path( __FILE__ ) . '/data/home12/home_granite.zip';

                    if ( file_exists( $main_slider ) ) {
                        $slider = new RevSlider();
                        $slider->importSliderFromPost( true, true, $main_slider );
                    }
                }    
            }  
		// Home 13
			elseif('Home Decor' === $selected_import['import_file_name']) {
                //Theme Options    
                ob_start();
                include(plugin_dir_path( __FILE__ ) . 'data/home13/theme_options.php');
                $theme_options = ob_get_clean();

                $options = json_decode($theme_options, true);
                $redux = ReduxFrameworkInstances::get_instance('modus_settings');
                $redux->set_options($options);
                modus_save_theme_settings();
                //front page
                $front_page = get_page_by_title( 'Home Granite' );
                if ( isset( $front_page->ID ) ) {
                    update_option( 'page_on_front', $front_page->ID );
                    update_option( 'show_on_front', 'page' );
                }

                $blog_page = get_page_by_title( 'Blog' );
                if ( isset( $blog_page->ID ) ) {
                    update_option( 'page_for_posts', $blog_page->ID );
                }

                if ( class_exists( 'RevSlider' ) ) {
                    $main_slider = plugin_dir_path( __FILE__ ) . '/data/home13/home_decor.zip';

                    if ( file_exists( $main_slider ) ) {
                        $slider = new RevSlider();
                        $slider->importSliderFromPost( true, true, $main_slider );
                    }
                }    
            } 
    	}
	add_action( 'pt-ocdi/after_import', 'arrowpress_importer_after_import' );
}


/** Echo text before importing widget in log file */
if ( ! function_exists( 'arrowpress_importer_before_widgets_import' ) ) {
	function arrowpress_importer_before_widgets_import( $selected_import ) {
		echo "Import Widget";
	}
	add_action( 'pt-ocdi/before_widgets_import', 'arrowpress_importer_before_widgets_import' );
}

/**
 * Changing Import Page slug
 */
if ( ! function_exists( 'arrowpress_importer_plugin_page_setup' ) ) {
	function arrowpress_importer_plugin_page_setup( $default_settings ) {
		$default_settings['parent_slug'] = 'themes.php';
		$default_settings['page_title']  = esc_html__( 'ArrowPress Importer' , 'arrowpress-importer' );
		$default_settings['menu_title']  = esc_html__( 'Import Demo Content' , 'arrowpress-importer' );
		$default_settings['capability']  = 'import';
		$default_settings['menu_slug']   = 'arrowpress-importer';

		return $default_settings;
	}
	add_filter( 'pt-ocdi/plugin_page_setup', 'arrowpress_importer_plugin_page_setup' );
}

add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

// Increase PHP max execution time. Just in case, even though the AJAX calls are only 25 sec long.
$disabled = explode(',', ini_get('disable_functions'));
if( !ini_get('safe_mode') && !in_array('set_time_limit', $disabled) ) {
	set_time_limit( apply_filters( 'pt-ocdi/set_time_limit_for_demo_data_import', 300 ) );
}