<?php
/**
* Shortcode Product Tabs
*/
add_shortcode( 'modus_time_line', 'modus_template_timeline' );
function modus_template_timeline( $atts ){
    extract( shortcode_atts(
        array(
            'title' =>'',
            'values' => '',
            'el_class' => '',
            'css' => '',
        ),$atts ));
    ob_start();
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_classs( $css, '' ), 'modus_time_line', $atts );
    $el_class = modus_extract_class( $el_class );

    if ( $css_class != '' ){
        $el_class .= modus_extract_class( $css_class );
    }

    //parse link
    
    $values = (array) vc_param_group_parse_atts( $values );
    ?>
    <div class="modus-timeline <?php echo $el_class; ?>">
        <div class="sfc wow fadeInUp" data-wow-duration="300ms" data-wow-delay="100ms">
            <?php if ( $title != '' ) : ?>
                <div class="modus-headingtitle md">
                    <div class="shortcode-title text-left">
                        <h2><?php echo wp_kses_post( $title );?></h2>
                    </div>
                </div>
            <?php endif; ?>
            <div class="tab-time">
                <div class="row">
                    <div class="col-lg-1 col-md-2 col-sm-3 col-xs-4 ">
                        <div class="nav-tab">
                            <ul>
                                <?php 
                                $j = 0;
                                foreach ( $values as $data ) {
                                    $j++;
                                    $new_line = $data;
                                    $new_line['index'] = isset( $data['index'] ) ? $data['index'] : '';
                                    if ( $j == 1 ) {
                                        echo '<li><a class="active" data-filter="tab-'.$j.'" href="#">'.$new_line['index'].'</a></li>';
                                    }else{
                                        echo '<li><a data-filter="tab-'.$j.'" href="#">'.$new_line['index'].'</a></li>';
                                    }
                                }
                                ?>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-11 col-md-10 col-sm-9 col-xs-8">
                        <div class="tabs-content">
                            <?php
                            $i=0;
                            foreach ( $values as $data ) {
                                $i++;
                                $new_line = $data;
                                $index = isset( $new_line['index'] ) ? $new_line['index'] : '';
                                $label = isset( $new_line['label'] ) ? $new_line['label'] : '';
                                $sub_label = isset( $new_line['sub_label'] ) ? $new_line['sub_label'] : '';
                                $description = isset( $data['content'] ) ? $new_line['content'] : '';
                                $image = isset( $new_line['image'] ) ? $new_line['image'] : '';
                                $link = isset( $new_line['link'] ) ? $new_line['link'] : '';
                                $link = ( '||' == $link ) ? '' : $link;
                                $link = vc_build_link($link);
                                $has_link = false;
                                $a_link = '';
                                $a_title = $a_target =' ';
                                if ( strlen( $link['url'] ) > 0 ){
                                    $has_link = true;
                                    $a_link = $link['url'];
                                    $a_title = $link['title'];
                                    $a_target = ( strlen($link['target']) > 0 ) ? $link['target'] : '_self';
                                }
                                ?>
                                <div class="product-tab tab-<?php echo esc_attr( $i );?> <?php if ( $i == 1 ) echo 'active';?>">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="about-time">
                                                <div class="label"><?php echo wp_kses_post( $label );?></div>
                                                <div class="sub_label"><?php echo esc_html( $sub_label );?></div>
                                                <div class="description"><?php echo esc_html( $description );?></div>
                                                <?php if ( $a_link != '' ) : ?>
                                                    <a class="learn-more" href="<?php echo esc_html( $a_link );?>" target="<?php echo esc_html( $a_target );?>"><?php echo esc_html( $a_title );?></a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="about-image">
                                                <img src="<?php echo wp_get_attachment_url( $image ); ?>" alt="">
                                            </div>
                                        </div>
                                    </div>
                                </div>  
                                <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
    return ob_get_clean();
}