<?php
/**
 * Blockquote template
 */

add_shortcode( 'modus_team', 'modus_tp_team' );
function modus_tp_team( $atts ){
    extract( shortcode_atts(
        array(
            'layout' => 'layout1',
            'team_group' => '',
        	'title' 		=> '',
            'items_show' 	=> -1,
            'column'        => 1,
            'el_class' 		=> '',
            'css' 			=> '',
        ),$atts));
    ob_start();
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'modus_team', $atts );
    $el_class = modus_extract_class( $el_class );

    if ( $css_class != '' ){
        $el_class .= modus_extract_class( $css_class );
    }
    $cl_item = 'col-xs-12 col-sm-3 col-md-3';
    switch ( $column ) {
        case '1':
            $cl_item = 'col-xs-12 col-sm-12 col-md-12';
            break;
        case '2':
            $cl_item = 'col-xs-12 col-sm-6 col-md-6';
            break;
        case '3':
            $cl_item = 'col-xs-12 col-sm-4 col-md-4';
            break;
        case '4':
            $cl_item = 'col-xs-12 col-sm-3 col-md-3';
            break;
        default:
            # code...
            break;
    }
    ?>

    <div class="modus-team<?php echo $el_class; ?>">
        <div class="sfc wow fadeInUp" data-wow-duration="300ms" data-wow-delay="100ms">
            <?php
            /*Query*/
            if ( $team_group == '' ) :
                $args = array(
                    'post_type' => 'team',
                    'post_status' => 'publish',
                    'posts_per_page' => $items_show,
                    'orderby' => 'modified',
                    'order'   => 'DESC',
                );
            else :
                $args = array(
                    'post_type' => 'team',
                    'post_status' => 'publish',
                    'posts_per_page' => $items_show,
                    'tax_query' => array(
                        'relation' => 'AND',
                        array(
                            'taxonomy' => 'team_group',
                            'field'    => 'slug',
                            'terms'    => $team_group,
                        ),
                    ),
                );
            endif;

            $rquery_team = new Wp_Query( $args );
            if ( $rquery_team->have_posts() ) :
                ?>
                <div class="team-list <?php echo esc_attr( $layout );?>">
                    <?php
                    $i_team = 0;
                    while ( $rquery_team->have_posts() ) : $rquery_team->the_post();
                        $i_team++;
                        if ( $i_team == 1 ) echo '<div class="row">';
                        if ( ($i_team-1)%$column == 0 && $i_team>$column ) echo '<div class="row">';
                            ?>
                            <div class="<?php echo esc_attr( $cl_item );?>">
                                <div class="team-item <?php echo esc_attr( $layout );?>">
                                    <!-- client box -->
                                    <?php if ( $layout != 'layout4'): ?>
                                        <?php the_post_thumbnail('full'); ?>
                                    <?php else: ?>
                                    <div class="team-img">
                                        <?php the_post_thumbnail('modus-our-best'); ?>
                                        <div class="team-action">
                                            <div class="team-cat">
                                                <ul>
                                                    <?php
                                                    $modus_team_cat = get_the_terms( get_the_ID(), 'team_cat');
                                                    if ( $modus_team_cat != '' ):
                                                        $i=0;
                                                        foreach( $modus_team_cat as $term ){
                                                            $term_link = get_term_link( $term );
                                                            $i++;
                                                            ?>
                                                            <li><?php echo esc_html__( $term->name ); ?></li>
                                                            <?php
                                                        }
                                                    endif;
                                                    ?>
                                                </ul>
                                            </div>
                                            <div class="team-social">
                                                <?php
                                                $facebook = get_post_meta( get_the_ID(), 'facebook', true );
                                                $twitter = get_post_meta( get_the_ID(), 'twitter', true );
                                                $instagram = get_post_meta( get_the_ID(), 'instagram', true );
                                                $gpl = get_post_meta( get_the_ID(), 'googleplus', true );
                                                ?>
                                                <ul>
                                                    <?php if ( $facebook != '' ) :?><li><a href="<?php echo esc_attr( $facebook );?>" target="_blank"><i class="fa fa-facebook" aria-hidden="true"></i></a></li><?php endif; ?>
                                                    <?php if ( $twitter != '' ) :?><li><a href="<?php echo esc_attr( $twitter );?>" target="_blank"><i class="fa fa-twitter" aria-hidden="true"></i></a></li><?php endif; ?>
                                                    <?php if ( $instagram != '' ) : ?><li><a href="<?php echo esc_attr( $instagram );?>" target="_blank"><i class="fa fa-instagram" aria-hidden="true"></i></a></li><?php endif; ?>
                                                    <?php if ( $gpl != '' ) :?><li><a href="<?php echo esc_attr( $gpl );?>" target="_blank"><i class="fa fa-google-plus" aria-hidden="true"></i></a></li><?php endif; ?>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                    <div class="team-info">
                                        <?php if ( $layout != 'layout3' && $layout != 'layout4'): ?>
                                                <h3><?php the_title();?></h3>
                                                <div class="team-cat">
                                                    <ul>
                                                        <?php
                                                        $modus_team_cat = get_the_terms( get_the_ID(), 'team_cat');
                                                        if ( $modus_team_cat != '' ):
                                                            $i=0;
                                                            foreach( $modus_team_cat as $term ){
                                                                $term_link = get_term_link( $term );
                                                                $i++;
                                                                ?>
                                                                    <li><?php echo esc_html__( $term->name ); ?></li>
                                                                <?php
                                                            }
                                                        endif;
                                                        ?>
                                                    </ul>
                                                </div>
                                                <h3 class="team-3"><a href="<?php the_permalink(); ?>" title=""><?php the_title();?></a></h3>
                                                <div class="team-dsc">
                                                    <?php the_content();?>
                                                </div>
                                        <?php elseif ($layout == 'layout4'): ?>
                                            <h3 class="team-3"><a href="<?php the_permalink(); ?>" title=""><?php the_title();?></a></h3>
                                        <?php else: ?>
                                             <div class="team-cat">
                                                <ul>
                                                    <?php
                                                    $modus_team_cat = get_the_terms( get_the_ID(), 'team_cat');
                                                    if ( $modus_team_cat != '' ):
                                                        $i=0;
                                                        foreach( $modus_team_cat as $term ){
                                                            $term_link = get_term_link( $term );
                                                            $i++;
                                                            ?>
                                                                <li><?php echo esc_html__( $term->name ); ?></li>
                                                            <?php
                                                        }
                                                    endif;
                                                    ?>
                                                </ul>
                                            </div>
                                            <h3 class="team-3"><a href="<?php the_permalink(); ?>" title=""><?php the_title();?></a></h3>
                                            <div class="team-dsc">
                                                <?php echo the_content();?>
                                            </div>
                                        <?php endif ?>
                                        <?php if ($layout != 'layout4'): ?>
                                            <div class="team-social">
                                                <?php
                                                $facebook = get_post_meta( get_the_ID(), 'facebook', true );
                                                $twitter = get_post_meta( get_the_ID(), 'twitter', true );
                                                $instagram = get_post_meta( get_the_ID(), 'instagram', true );
                                                $gpl = get_post_meta( get_the_ID(), 'googleplus', true );
                                                ?>
                                                <ul>
                                                    <?php if ( $facebook != '' ) :?><li><a href="<?php echo esc_attr( $facebook );?>" target="_blank"><i class="fa fa-facebook" aria-hidden="true"></i></a></li><?php endif; ?>
                                                    <?php if ( $twitter != '' ) :?><li><a href="<?php echo esc_attr( $twitter );?>" target="_blank"><i class="fa fa-twitter" aria-hidden="true"></i></a></li><?php endif; ?>
                                                    <?php if ( $instagram != '' ) : ?><li><a href="<?php echo esc_attr( $instagram );?>" target="_blank"><i class="fa fa-instagram" aria-hidden="true"></i></a></li><?php endif; ?>
                                                    <?php if ( $gpl != '' ) :?><li><a href="<?php echo esc_attr( $gpl );?>" target="_blank"><i class="fa fa-google-plus" aria-hidden="true"></i></a></li><?php endif; ?>
                                                </ul>
                                            </div>
                                        <?php endif ?>

                                    </div>
                                </div>
                            </div>
                            <?php
                        if ( $i_team == $column ) echo '</div>';
                        if ( $i_team%$column == 0 && $i_team>$column ) echo '</div>';
                    endwhile;
                    if ( $i_team%$column != 0 ) echo '</div>';
                    wp_reset_postdata();
                    ?>
                </div>
                <?php
            endif;
            ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}