<?php
add_shortcode( 'modus_custom_tab', 'modus_tp_custom_tab' );
function modus_tp_custom_tab( $atts ){
    extract( shortcode_atts(
        array(
            'title'         => '',
			'values'   => '',
            'el_class'      => '',
            'css'           => '',
        ),$atts ));
    ob_start();

    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, '' ), 'modus_custom_tab', $atts );
    $el_class = modus_extract_class( $el_class );

    if ( $css_class != '' ){
        $el_class .= modus_extract_class( $css_class );
    }
    $values = (array) vc_param_group_parse_atts( $values );
    ?>
    <div class="modus_custom_tab">
        <?php if ( $title != '' ) : ?>
            <div class="o2you-headingtitle">
                <h2><?php echo wp_kses_post( $title );?></h2>
            </div>
        <?php endif; ?>
        <div class="tab-process">
            <div class="nav-tab">
                <ul>
                    <?php
                    $j = 0;
                    foreach ( $values as $data ) {
                        $j++;
                        $new_line = $data;
                        $new_line['index'] = isset( $data['index'] ) ? $data['index'] : '';
                        if ( $j == 1 ) {
                            echo '<li class="item active" data-filter="tab-'.$j.'"><a href="#">'.$j.'</a></li>';
                        }else{
                            echo '<li class="line"><a href="#">&nbsp;</a></li><li class="item" data-filter="tab-'.$j.'"><a href="#">'.$j.'</a></li>';
                        }
                    }
                    ?>
                </ul>
            </div>
            <div class="tabs-content">
                <?php
                $i=0;
                foreach ( $values as $data ) {
                    $i++;
                    $new_line = $data;
                    $description = isset( $data['content'] ) ? $new_line['content'] : '';
                    ?>
                    <div class="item-tab tab-<?php echo esc_attr( $i );?> <?php if ( $i == 1 ) echo 'active';?>">
                        <div class="description"><?php echo esc_html( $description );?></div>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>
    </div>

<?php
    return ob_get_clean();
}
?>