<?php
add_shortcode( 'modus_services', 'modus_tp_services' );
function modus_tp_services( $atts ){
    extract( shortcode_atts(
        array(
            'layout' => 'layout1',
            'group_layout' => '',
            'column' => '4',
            'items_show' => -1,
            'word_show' => 20,
            'show_btnview' => '',
            'el_class' => '',
            'css' => '',
        ),$atts ));
    ob_start();

    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, '' ), 'modus_services', $atts );
    $el_class = modus_extract_class( $el_class );

    if ( $css_class != '' ){
        $el_class .= modus_extract_class( $css_class );
    }
    switch ( $column ) {
        case '1':
            $cl_class = 'col-xs-12 col-sm-12 col-md-12';
            break;
        case '2':
            $cl_class = 'col-xs-12 col-sm-6 col-md-6';
            break;
        case '3':
            $cl_class = 'col-xs-12 col-sm-4 col-md-4';
            break;
        case '4':
            $cl_class = 'col-xs-12 col-sm-6 col-md-3';
            break;

        default:
            $cl_class = '';
            break;
    }
    ?>
    <div class="sfc wow fadeInUp" data-wow-duration="300ms" data-wow-delay="100ms">
        <div class="modus-services<?php echo $el_class; ?>">
            <?php
            if ( $group_layout == '' ) :
                $args = array(
                    'post_type' => 'services',
                    'post_status' => 'publish',
                    'posts_per_page' => $items_show,

                );
            else :
                $args = array(
                    'post_type' => 'services',
                    'post_status' => 'publish',
                    'posts_per_page' => $items_show,
                    'tax_query' => array(
                        'relation' => 'AND',
                        array(
                            'taxonomy' => 'services_cat',
                            'field'    => 'slug',
                            'terms'    => $group_layout,
                        ),
                    ),
                );
            endif;
            $rquery_services = New Wp_Query( $args );
            if ( $rquery_services->have_posts() ) :
                $i = 0;
                if ( $layout == 'layout1' ) :
                    echo '<div class="layout1">';
                        while ( $rquery_services->have_posts() ) : $rquery_services->the_post();
                            $i++;
                                if ( $i == 1 ) echo '<div class="row first">';
                                if ( ($i-1)%$column == 0 && $i>$column ) echo '<div class="row">';
                                    ?>
                                    <div class="<?php echo esc_attr( $cl_class ); ?>">
                                        <div class="item">
                                            <!-- services box -->
                                            <div class="img left">
                                                <?php
                                                    $attachment_id = get_post_thumbnail_id();
                                                    $image_grid_sv = modus_shortcode_get_attachment($attachment_id, 'modus-service-1'); 
                                                ?>
                                                <div class="service-img"><a href="<?php the_permalink(); ?>"><img width="<?php echo esc_attr($image_grid_sv['width']) ?>" height="<?php echo esc_attr($image_grid_sv['height']) ?>" src="<?php echo esc_url($image_grid_sv['src']) ?>" alt="<?php echo esc_attr($image_grid_sv['alt']) ?>" /></a></div>
                                            </div>
                                            <div class="box">
                                                <div class="item-service">
                                                <h3><a href=<?php the_permalink(); ?>><span><?php the_title(); ?></span></a></h3>
                                                    <div class="txt">
                                                        <?php echo modus_content_limit($word_show);?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                if ( $i == $column ) echo '</div>';
                                if ( $i%$column == 0 && $i>$column ) echo '</div>';
                        endwhile;
                        if ( $i%$column != 0 ) echo '</div>';
                        wp_reset_postdata();
                    echo '</div>';
                endif;
                if ( $layout == 'layout2' ) :
                    echo '<div class="layout2">';
                        while ( $rquery_services->have_posts() ) : $rquery_services->the_post();
                            $i++;
                                if ( $i == 1 ) echo '<div class="row first">';
                                if ( ($i-1)%$column == 0 && $i>$column ) echo '<div class="row">';
                                    ?>
                                    <div class="<?php echo esc_attr( $cl_class ); ?>">
                                        <div class="item">
                                            <!-- services box -->
                                            <a class="modus_link_to" href="<?php the_permalink(); ?>"></a>
                                            <div class="img">
                                                 <?php
                                                    $attachment_id = get_post_thumbnail_id();
                                                    $image_grid_sv2 = modus_shortcode_get_attachment($attachment_id, 'modus-service-2'); 
                                                ?>
                                                <div class="service-img"><a href="<?php the_permalink(); ?>"><img width="<?php echo esc_attr($image_grid_sv2['width']) ?>" height="<?php echo esc_attr($image_grid_sv2['height']) ?>" src="<?php echo esc_url($image_grid_sv2['src']) ?>" alt="<?php echo esc_attr($image_grid_sv2['alt']) ?>" /></a></div>
                                            </div>
                                            <div class="item-service">
                                                <div class="bg-op">
                                                    <div class="bg-full"></div>
                                                </div>
                                                <div class="box">

                                                    <div class="service-info">
                                                        <h3><?php the_title(); ?></h3>
                                                        <div class="txt">
                                                            <?php echo modus_content_limit( 10 );?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                if ( $i == $column ) echo '</div>';
                                if ( $i%$column == 0 && $i>$column ) echo '</div>';
                        endwhile;
                        if ( $i%$column != 0 ) echo '</div>';
                        wp_reset_postdata();
                    echo '</div>';
                endif;
                if ( $layout == 'layout3' ) :
                    echo '<div class="layout3">';
                        while ( $rquery_services->have_posts() ) : $rquery_services->the_post();
                            $i++;
                                if ( $i == 1 ) echo '<div class="row first">';
                                if ( ($i-1)%$column == 0 && $i>$column ) echo '<div class="row">';
                                    ?>
                                    <div class="<?php echo esc_attr( $cl_class ); ?>">
                                        <div class="item">
                                            <!-- services box -->
                                            <a class="modus_link_to" href="<?php the_permalink(); ?>"></a>
                                            <div class="img">
                                                <div class="md-link-all">
                                                    <a class="md-link-7s" href="<?php  the_permalink(); ?>"><i class="Pe-icon-7-stroke-link"></i></a>
                                                </div>
                                                <?php
                                                    $attachment_id = get_post_thumbnail_id();
                                                    $image_grid_sv3 = modus_shortcode_get_attachment($attachment_id, 'modus-service-3'); 
                                                ?>
                                                 <div class="service-img"><a href="<?php the_permalink(); ?>"><img width="<?php echo esc_attr($image_grid_sv3['width']) ?>" height="<?php echo esc_attr($image_grid_sv3['height']) ?>" src="<?php echo esc_url($image_grid_sv3['src']) ?>" alt="<?php echo esc_attr($image_grid_sv3['alt']) ?>" /></a></div>
                                            </div>
                                            <div class="item-service">
                                                <div class="bg-op">
                                                    <div class="bg-full"></div>
                                                </div>
                                                <div class="box">
                                                    <div class="service-info">
                                                        <h3><?php the_title(); ?></h3>
                                                        <div class="txt">
                                                            <?php echo modus_content_limit( 7 );?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                if ( $i == $column ) echo '</div>';
                                if ( $i%$column == 0 && $i>$column ) echo '</div>';
                        endwhile;
                        if ( $i%$column != 0 ) echo '</div>';
                        wp_reset_postdata();
                    echo '</div>';
                endif;
				if ( $layout == 'layout4' ) :
                    echo '<div class="layout4">';
                        while ( $rquery_services->have_posts() ) : $rquery_services->the_post();
                            $i++;
                                if ( $i == 1 ) echo '<div class="row first">';
                                if ( ($i-1)%$column == 0 && $i>$column ) echo '<div class="row">';
                                    ?>
                                    <div class="<?php echo esc_attr( $cl_class ); ?>">
                                        <div class="item">
                                            <!-- services box -->
											<?php
												$attachment_id = get_post_thumbnail_id();
												$image_grid = modus_shortcode_get_attachment($attachment_id, 'modus-service-4'); 
											?>
                                            <div class="service-img"><a href="<?php the_permalink(); ?>"><img width="<?php echo esc_attr($image_grid['width']) ?>" height="<?php echo esc_attr($image_grid['height']) ?>" src="<?php echo esc_url($image_grid['src']) ?>" alt="<?php echo esc_attr($image_grid['alt']) ?>" /></a></div>
                                            <div class="item-service">
                                                <div class="box">
                                                    <div class="service-info">
                                                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                                        <div class="txt">
                                                            <?php echo modus_content_limit( 15 );?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                if ( $i == $column ) echo '</div>';
                                if ( $i%$column == 0 && $i>$column ) echo '</div>';
                        endwhile;
                        if ( $i%$column != 0 ) echo '</div>';
                        wp_reset_postdata();
                    echo '</div>';
                endif;
            endif;
            if ( $show_btnview == 'enable_show_btnview' ) :
                ?>
                <div class="padding-top-60 sfc wow fadeInUp animated" data-wow-duration="300ms" data-wow-delay="100ms" style="visibility: visible; animation-duration: 300ms; animation-delay: 100ms; animation-name: fadeInUp;">
                    <div class="text-center">
                        <a href="#" class="view-more hvr-trim"><?php echo esc_html__( 'View All','modus');?></a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
?>