<?php
/**
 * Shortcode Product Tabs
 */
add_shortcode('modus_product_tab_slider', 'modus_template_product_tab_slider');
function modus_template_product_tab_slider($atts)
{
  extract(shortcode_atts(
    array(
      'title' => '',
      'layout_nav' => 'default',
      'typegrid' => 'type1',
      'typelist' => 'type1',
      'type_product' => 'new-product',
      'filter' => 'custom',
      'icon_title' => 'icon-image',
      'image' => '',
      'icon_font' => '',
      'values' => '',
      'type_nav' => 'nav_default',
      'type_layout' => 'grid',
      'items_show' => -1,
      'column' => 1,
      'row' => 1,
      'hidden_loadmore' => '',
      'el_class' => '',
      'css' => '',
    ), $atts));
  ob_start();
  $css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_classs($css, ''), 'modus_product_tab_slider', $atts);
  $el_class = modus_extract_class($el_class);

  if ($css_class != '') {
    $el_class .= modus_extract_class($css_class);
  }
  $padding_col = 'padding-35';
  $col = 'col-xs-12 col-sm-6 col-md-3';
  switch ($column) {
    case '1':
    $padding_col = 'padding-35';
    $column_class = 'coll-2';
    $col = 'col-xs-12 col-sm-12 col-md-12';
    break;
    case '2':
    $padding_col = 'padding-35';
    $column_class = 'coll-2';
    $col = 'col-xs-12 col-sm-6 col-md-6';
    break;
    case '3':
    $padding_col = 'padding-35';
    $column_class = 'coll-3';
    $col = 'col-xs-12 col-sm-4 col-md-4';
    break;
    case '4':
    $padding_col = 'padding-35';
    $column_class = 'coll-4';
    $col = 'col-xs-12 col-sm-6 col-md-3';
    break;
    case '5':
    $padding_col = 'padding-15';
    $column_class = 'coll-5';
    $col = 'col-xs-12 col-sm-15 col-md-15';
    break;
    case '6':
    $padding_col = 'padding-15';
    $column_class = 'coll-6';
    $col = 'col-xs-12 col-sm-2 col-md-2';
    break;
    default:
    break;
  }
  $values = (array)vc_param_group_parse_atts($values);
  ?>
  <div class="modus-product-tab <?php echo $el_class; ?>">
    <div class="sfc wow fadeInUp" data-wow-duration="300ms" data-wow-delay="100ms">
      <?php
      if ($filter == 'custom') :
        if ($title != '') :
          switch ($icon_title) {
            case 'icon-image':
            ?>
            <div class="heading-title wpb_bottom-to-top">
              <?php if (isset($image)) :; ?>
                <div class="icon-heading"><img src="<?php echo wp_get_attachment_url($image); ?>"
                 alt="<?php echo esc_attr($title); ?>"><?php endif; ?>
               </div>
               <h2><?php echo esc_attr($title); ?></h2>
             </div>
             <?php
             break;
             case 'icon-font':
             ?>
             <div class="heading-title wpb_bottom-to-top">
              <?php if (isset($icon_font)) :; ?>
                <div class="icon-heading"><i
                  class="<?php echo esc_attr($icon_font); ?>"></i><?php endif; ?></div>
                  <h2><?php echo esc_attr($title); ?></h2>
                </div>
                <?php
                break;
                default:
                            # code...
                break;
              }
            endif;
            if ($type_layout == 'list')
              $main_class = "slide-product-list";
            if ($type_layout == 'grid')
              $main_class = "slide-product-grid";
            ?>
            <div class="tab-slide">
              <div class="nav-tab">
                <ul>
                  <?php
                  $j = 0;
                  foreach ($values as $data) {
                    $j++;
                    $new_line = $data;
                    $new_line['label'] = isset($data['label']) ? $data['label'] : '';
                    if ($j == 1) {
                      echo '<li><a class="active" data-filter="tab-' . $j . '" href="#">' . $new_line['label'] . '</a></li>';
                    } else {
                      echo '<li><a data-filter="tab-' . $j . '" href="#">' . $new_line['label'] . '</a></li>';
                    }
                  }
                  ?>
                </ul>
              </div>
              <div class="tabs-content">
                <?php
                $i = 0;
                foreach ($values as $data) {
                  $i++;
                  $new_line = $data;
                  $new_line['label'] = isset($data['label']) ? $data['label'] : '';
                  $new_line['cat_product'] = isset($data['cat_product']) ? $data['cat_product'] : '';
                  if ($type_product == 'new-product') {
                    if ($new_line['cat_product'] == '') {
                      $args = array(
                        'post_type' => 'product',
                        'post_status' => 'publish',
                        'posts_per_page' => $items_show,
                      );
                    } else {
                      $args = array(
                        'post_type' => 'product',
                        'post_status' => 'publish',
                        'posts_per_page' => $items_show,
                        'tax_query' => array(
                          'relation' => 'AND',
                          array(
                            'taxonomy' => 'product_cat',
                            'field' => 'slug',
                            'terms' => $new_line['cat_product'],
                          ),
                        ),
                      );
                    }
                  } elseif ($type_product == 'feature-product') {
                    $product_visibility_term_ids = wc_get_product_visibility_term_ids();
                    if ($new_line['cat_product'] == '') :
                      $args = array(
                        'post_type' => 'product',
                        'post_status' => 'publish',
                        'posts_per_page' => $items_show,
                        'tax_query' => array(
                          'relation' => 'AND',
                          array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'term_taxonomy_id',
                            'terms' => array($product_visibility_term_ids['featured']),
                          ),
                          array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'term_taxonomy_id',
                            'terms' => array($product_visibility_term_ids['exclude-from-catalog']),
                            'operator' => 'NOT IN',
                          ),
                        ),
                        'orderby' => 'date',
                      );
                    else :
                      $args = array(
                        'post_type' => 'product',
                        'post_status' => 'publish',
                        'posts_per_page' => $items_show,
                        'tax_query' => array(
                          'relation' => 'AND',
                          array(
                            'taxonomy' => 'product_cat',
                            'field' => 'slug',
                            'terms' => $new_line['cat_product'],
                          ),
                          array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'term_taxonomy_id',
                            'terms' => array($product_visibility_term_ids['featured']),
                          ),
                          array(
                            'taxonomy' => 'product_visibility',
                            'field' => 'term_taxonomy_id',
                            'terms' => array($product_visibility_term_ids['exclude-from-catalog']),
                            'operator' => 'NOT IN',
                          ),
                        )
                      );
                    endif;
                  } elseif ($type_product == 'sale-product') {
                    if ($new_line['cat_product'] == '') :
                      $args = array(
                        'post_type' => 'product',
                        'post_status' => 'publish',
                        'posts_per_page' => $items_show,
                        'meta_query' => array(
                          'relation' => 'OR',
                                            array( // Simple products type
                                              'key' => '_sale_price',
                                              'value' => 0,
                                              'compare' => '>',
                                              'type' => 'numeric'
                                            ),
                                            array( // Variable products type
                                              'key' => '_min_variation_sale_price',
                                              'value' => 0,
                                              'compare' => '>',
                                              'type' => 'numeric'
                                            )
                                          )
                      );
                    else :
                      $args = array(
                        'post_type' => 'product',
                        'post_status' => 'publish',
                        'posts_per_page' => $items_show,
                        'tax_query' => array(
                          'relation' => 'AND',
                          array(
                            'taxonomy' => 'product_cat',
                            'field' => 'slug',
                            'terms' => $new_line['cat_product'],
                          ),
                        ),
                        'meta_query' => array(
                          'relation' => 'OR',
                                            array( // Simple products type
                                              'key' => '_sale_price',
                                              'value' => 0,
                                              'compare' => '>',
                                              'type' => 'numeric'
                                            ),
                                            array( // Variable products type
                                              'key' => '_min_variation_sale_price',
                                              'value' => 0,
                                              'compare' => '>',
                                              'type' => 'numeric'
                                            )
                                          )
                      );
                    endif;
                  } elseif ( $type_product == 'best-seller-product' ) {
                    if ($new_line['cat_product'] == '') :
                     $args = array(
                      'post_type' => 'product',
                      'meta_key' => 'total_sales',
                      'orderby' => 'meta_value_num',
                      'posts_per_page' => $items_show,
                    );
                   else :
                     $args = array(
                      'post_type' => 'product',
                      'meta_key' => 'total_sales',
                      'orderby' => 'meta_value_num',
                      'posts_per_page' => $items_show,
                      'tax_query' => array(
                        'relation' => 'AND',
                        array(
                          'taxonomy' => 'product_cat',
                          'field' => 'slug',
                          'terms' => $new_line['cat_product'],
                        ),
                      ),
                    );
                   endif;
                 } else {
                  $args = '';
                };
                $rquery = new Wp_Query($args);
                ?>
                <div class="product-tab tab-<?php echo esc_attr($i); ?> <?php if ($i == 1) echo 'active'; ?>">
                  <div class="slide-product <?php echo esc_attr($main_class); ?>"
                   data-columns="<?php echo esc_attr($column); ?>"
                   data-rows="<?php echo esc_attr($row); ?>">
                   <div class="beans-stepslider" data-rotate="true">
                    <div class="beans-mask">
                      <div class="beans-slideset">
                        <?php
                        if ($rquery->have_posts()) :
                          while ($rquery->have_posts()) : $rquery->the_post();
                            ?>
                            <div class="beans-slide">
                              <div class="<?php echo esc_attr($padding_col); ?>">
                                <div class="border-hover">
                                  <div>
                                    <?php
                                    if ($type_layout == 'list') {
                                      if ($typelist == 'type1') {
                                        wc_get_template_part('content', 'product-list-1');
                                      } elseif ($typelist == 'type2') {
                                        wc_get_template_part('content', 'product-list-2');
                                      }
                                    } elseif ($type_layout == 'grid') {
                                      if ($typegrid == 'type1') {
                                        wc_get_template_part('content', 'product-grid');
                                      } elseif ($typegrid == 'type2') {
                                        wc_get_template_part('content', 'product-grid-2');
                                      } elseif ($typegrid == 'type3') {
                                        wc_get_template_part('content', 'product-grid-3');
                                      } elseif ($typegrid == 'type4') {
                                        wc_get_template_part('content', 'product-grid-4');
                                      } elseif ($typegrid == 'type5') {
                                        wc_get_template_part('content', 'product-grid-5');
                                      } elseif ($typegrid == 'type6') {
                                        wc_get_template_part('content', 'product-grid-6');
                                      } elseif ($typegrid == 'type7') {
                                        wc_get_template_part('content', 'product-grid-7');
                                      }elseif ($typegrid == 'type8') {
                                        wc_get_template_part('content', 'product-grid-9');
                                      }
                                    }
                                    ?>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <?php
                          endwhile;
                          wp_reset_query();
                        endif;
                        ?>
                      </div>
                    </div>
                    <div class="beans-pagination"></div>
                  </div>
                </div>
              </div>
              <?php
            }
            ?>
          </div>
        </div>
      <?php endif; ?>
      <?php if ($filter == 'tab-loadmore') : ?>
        <div class="modus-tab-loadmore">
          <?php if ($layout_nav == 'default') : ?>
            <div class="nav-default text-center">
              <nav class="list-inline nav-tab">
                <ul>
                  <?php
                  $j = 0;
                  foreach ($values as $data) {
                    $j++;
                    $new_line = $data;
                    $new_line['label'] = isset($data['label']) ? $data['label'] : '';
                    if ($j == 1) {
                      echo '<li><a class="active" data-filter="tab-' . $j . '" href="#">' . $new_line['label'] . '</a></li>';
                    } else {
                      echo '<li><a data-filter="tab-' . $j . '" href="#">' . $new_line['label'] . '</a></li>';
                    }
                  }
                  ?>
                </ul>
              </nav>
            </div>
          <?php elseif ($layout_nav == 'type1') : ?>
            <div class="nav-1 text-center">
              <nav class="list-inline nav-tab">
                <ul>
                  <?php
                  $j = 0;
                  foreach ($values as $data) {
                    $j++;
                    $new_line = $data;
                    $new_line['label'] = isset($data['label']) ? $data['label'] : '';
                    if ($j == 1) {
                      echo '<li><a class="active" data-filter="tab-' . $j . '" href="#">' . $new_line['label'] . '</a></li>';
                    } else {
                      echo '<li><a data-filter="tab-' . $j . '" href="#">' . $new_line['label'] . '</a></li>';
                    }
                  }
                  ?>
                </ul>
              </nav>
            </div>
          <?php elseif ($layout_nav == 'type2') : ?>
            <div class="nav-2 text-center">
              <nav class="nav-tab">
                <ul>
                  <?php
                  $j = 0;
                  foreach ($values as $data) {
                    $j++;
                    $new_line = $data;
                    $new_line['label'] = isset($data['label']) ? $data['label'] : '';
                    if ($j == 1) {
                      echo '<li><a class="active" data-filter="tab-' . $j . '" href="#">' . $new_line['label'] . '</a></li>';
                    } else {
                      echo '<li><a data-filter="tab-' . $j . '" href="#">' . $new_line['label'] . '</a></li>';
                    }
                  }
                  ?>
                </ul>
              </nav>
            </div>
          <?php elseif ($layout_nav == 'type3') : ?>
            <div class="nav-3 text-center margin-bottom-55">
              <div class="box-table">
                <div class="inline-left"></div>
                <div class="inline-center">
                  <nav class="nav-tab">
                    <ul>
                      <?php
                      $j = 0;
                      foreach ($values as $data) {
                        $j++;
                        $new_line = $data;
                        $new_line['label'] = isset($data['label']) ? $data['label'] : '';
                        if ($j == 1) {
                          echo '<li><a class="active" data-filter="tab-' . $j . '" href="#">' . $new_line['label'] . '</a></li>';
                        } else {
                          echo '<li><a data-filter="tab-' . $j . '" href="#">' . $new_line['label'] . '</a></li>';
                        }
                      }
                      ?>
                    </ul>
                  </nav>
                </div>
                <div class="inline-right"></div>
              </div>
            </div>
          <?php elseif ($layout_nav == 'type4') : ?>
            <div class="nav-4 text-center margin-bottom-40">
              <nav class="nav-tab">
                <div class="mobile hidden-md hidden-lg">
                  <div class="select_title">
                    <ul>
                      <?php
                      $k = 0;
                      foreach ($values as $data) {
                        $k++;
                        $new_line = $data;
                        $new_line['label'] = isset($data['label']) ? $data['label'] : '';
                        $new_line['image'] = isset($data['image']) ? $data['image'] : '';
                        $image = wp_get_attachment_image_src($new_line['image'], 'full');
                        if ($k == 1) {
                          ?>
                          <li>
                            <a class="active" data-filter="tab-<?php echo esc_attr($k) ?>"
                             href="#">
                             <div class="box-img"><img
                              src="<?php echo esc_url($image[0]); ?>" alt=""/>
                            </div>
                            <span><?php echo esc_attr($new_line['label']); ?></span>
                          </a>
                        </li>
                        <?php
                      }
                    }
                    ?>
                  </ul>
                  <i class="fa fa-angle-down"></i>
                </div>
                <ul class="select_list">
                  <?php
                  $j = 0;
                  foreach ($values as $data) {
                    $j++;
                    $new_line = $data;
                    $new_line['label'] = isset($data['label']) ? $data['label'] : '';
                    $new_line['image'] = isset($data['image']) ? $data['image'] : '';
                    $image = wp_get_attachment_image_src($new_line['image'], 'full');
                    if ($j == 1) {
                      ?>
                      <li>
                        <a class="active" data-filter="tab-<?php echo esc_attr($j) ?>"
                         href="#">
                         <div class="box-img"><img
                          src="<?php echo esc_url($image[0]); ?>"
                          alt="<?php echo esc_attr($new_line['label']); ?>"/>
                        </div>
                        <span><?php echo esc_attr($new_line['label']); ?></span>
                      </a>
                    </li>
                    <?php
                  } else {
                    ?>
                    <li>
                      <a data-filter="tab-<?php echo esc_attr($j) ?>" href="#">
                        <div class="box-img"><img
                          src="<?php echo esc_url($image[0]); ?>"
                          alt="<?php echo esc_attr($new_line['label']); ?>"/>
                        </div>
                        <span><?php echo esc_attr($new_line['label']); ?></span>
                      </a>
                    </li>
                    <?php
                  }
                }
                ?>
              </ul>
            </div>
            <div class="hidden-sm hidden-xs">
              <ul class="select_list">
                <?php
                $j = 0;
                foreach ($values as $data) {
                  $j++;
                  $new_line = $data;
                  $new_line['label'] = isset($data['label']) ? $data['label'] : '';
                  $new_line['image'] = isset($data['image']) ? $data['image'] : '';
                  $image = wp_get_attachment_image_src($new_line['image'], 'full');
                  if ($j == 1) {
                    ?>
                    <li>
                      <a class="active" data-filter="tab-<?php echo esc_attr($j) ?>"
                       href="#">
                       <div class="box-img"><img
                        src="<?php echo esc_url($image[0]); ?>" alt="<?php echo esc_attr($new_line['label']); ?>"/>
                      </div>
                      <span><?php echo esc_attr($new_line['label']); ?></span>
                    </a>
                  </li>
                  <?php
                } else {
                  ?>
                  <li>
                    <a data-filter="tab-<?php echo esc_attr($j) ?>" href="#">
                      <div class="box-img"><img
                        src="<?php echo esc_url($image[0]); ?>" alt="<?php echo esc_attr($new_line['label']); ?>"/></div>
                        <span><?php echo esc_attr($new_line['label']); ?></span>
                      </a>
                    </li>
                    <?php
                  }
                }
                ?>
              </ul>
            </div>
          </nav>
        </div>
      <?php endif; ?>
      <?php if ($layout_nav == 'type3') : ?>
        <div class="container">
        <?php endif; ?>
        <div class="tabs-content">
          <?php
          $i = 0;
          foreach ($values as $data) {
            $i++;
            $new_line = $data;
            $new_line['label'] = isset($data['label']) ? $data['label'] : '';
            $new_line['cat_product'] = isset($data['cat_product']) ? $data['cat_product'] : '';

            if ($type_product == 'new-product') {
              if ($new_line['cat_product'] == '') {
                $args = array(
                  'post_type' => 'product',
                  'post_status' => 'publish',
                  'posts_per_page' => $items_show,
                );
              } else {
                $args = array(
                  'post_type' => 'product',
                  'post_status' => 'publish',
                  'posts_per_page' => $items_show,
                  'tax_query' => array(
                    'relation' => 'AND',
                    array(
                      'taxonomy' => 'product_cat',
                      'field' => 'slug',
                      'terms' => $new_line['cat_product'],
                    ),
                  ),
                );
              }
            } elseif ($type_product == 'feature-product') {
              $product_visibility_term_ids = wc_get_product_visibility_term_ids();
              if ($new_line['cat_product'] == '') :
                $args = array(
                  'post_type' => 'product',
                  'post_status' => 'publish',
                  'posts_per_page' => $items_show,
                  'tax_query' => array(
                    'relation' => 'AND',
                    array(
                      'taxonomy' => 'product_visibility',
                      'field' => 'term_taxonomy_id',
                      'terms' => array($product_visibility_term_ids['featured']),
                    ),
                    array(
                      'taxonomy' => 'product_visibility',
                      'field' => 'term_taxonomy_id',
                      'terms' => array($product_visibility_term_ids['exclude-from-catalog']),
                      'operator' => 'NOT IN',
                    ),
                  ),
                  'orderby' => 'date',
                );
              else :
                $args = array(
                  'post_type' => 'product',
                  'post_status' => 'publish',
                  'posts_per_page' => $items_show,
                  'tax_query' => array(
                    'relation' => 'AND',
                    array(
                      'taxonomy' => 'product_cat',
                      'field' => 'slug',
                      'terms' => $new_line['cat_product'],
                    ),
                    array(
                      'taxonomy' => 'product_visibility',
                      'field' => 'term_taxonomy_id',
                      'terms' => array($product_visibility_term_ids['featured']),
                    ),
                    array(
                      'taxonomy' => 'product_visibility',
                      'field' => 'term_taxonomy_id',
                      'terms' => array($product_visibility_term_ids['exclude-from-catalog']),
                      'operator' => 'NOT IN',
                    ),
                  )
                );
              endif;
            } elseif ($type_product == 'sale-product') {
              if ($new_line['cat_product'] == '') :
                $args = array(
                  'post_type' => 'product',
                  'post_status' => 'publish',
                  'posts_per_page' => $items_show,
                  'meta_query' => array(
                    'relation' => 'OR',
                                                array( // Simple products type
                                                  'key' => '_sale_price',
                                                  'value' => 0,
                                                  'compare' => '>',
                                                  'type' => 'numeric'
                                                ),
                                                array( // Variable products type
                                                  'key' => '_min_variation_sale_price',
                                                  'value' => 0,
                                                  'compare' => '>',
                                                  'type' => 'numeric'
                                                )
                                              )
                );
              else :
                $args = array(
                  'post_type' => 'product',
                  'post_status' => 'publish',
                  'posts_per_page' => $items_show,
                  'tax_query' => array(
                    'relation' => 'AND',
                    array(
                      'taxonomy' => 'product_cat',
                      'field' => 'slug',
                      'terms' => $new_line['cat_product'],
                    ),
                  ),
                  'meta_query' => array(
                    'relation' => 'OR',
                      array( // Simple products type
                        'key' => '_sale_price',
                        'value' => 0,
                        'compare' => '>',
                        'type' => 'numeric'
                      ),
                      array( // Variable products type
                        'key' => '_min_variation_sale_price',
                        'value' => 0,
                        'compare' => '>',
                        'type' => 'numeric'
                      )
                  )
                );
              endif;
            } elseif ( $type_product == 'best-seller-product' ) {
              if ($new_line['cat_product'] == '') :
                $args = array(
                  'post_type' => 'product',
                  'meta_key' => 'total_sales',
                  'orderby' => 'meta_value_num',
                  'posts_per_page' => $items_show,
                );
              else :
                $args = array(
                  'post_type' => 'product',
                  'meta_key' => 'total_sales',
                  'orderby' => 'meta_value_num',
                  'posts_per_page' => $items_show,
                  'tax_query' => array(
                    'relation' => 'AND',
                    array(
                      'taxonomy' => 'product_cat',
                      'field' => 'slug',
                      'terms' => $new_line['cat_product'],
                    ),
                  ),
                );
              endif;
            } else {
              $args = '';
            };
            $rquery = new Wp_Query($args);
            ?>
            <div class="product-tab tab-<?php echo esc_attr($i); ?> <?php if ($i == 1) echo 'active'; ?>">
              <div class="modus-product-more">
                <?php
                if ($rquery->have_posts()) :
                  $i_row = 0;
                  while ($rquery->have_posts()) : $rquery->the_post();
                    $i_row++;
                    if ($i_row == 1) echo '<div class="row">';
                    if (($i_row - 1) % $column == 0 && $i_row > $column) echo '<div class="row">';
                    ?>
                    <div class="<?php echo esc_attr($col); ?>">
                      <?php
                      if ($type_layout == 'list') {
                        if ($typelist == 'type1') {
                          wc_get_template_part('content', 'product-list-1');
                        } elseif ($typelist == 'type2') {
                          wc_get_template_part('content', 'product-list-2');
                        }
                      } elseif ($type_layout == 'grid') {
                        if ($typegrid == 'type1') {
                          wc_get_template_part('content', 'product-grid');
                        } elseif ($typegrid == 'type2') {
                          wc_get_template_part('content', 'product-grid-2');
                        } elseif ($typegrid == 'type3') {
                          wc_get_template_part('content', 'product-grid-3');
                        } elseif ($typegrid == 'type4') {
                          wc_get_template_part('content', 'product-grid-4');
                        } elseif ($typegrid == 'type5') {
                          wc_get_template_part('content', 'product-grid-5');
                        } elseif ($typegrid == 'type6') {
                          wc_get_template_part('content', 'product-grid-6');
                        } elseif ($typegrid == 'type7') {
                          wc_get_template_part('content', 'product-grid-7');
                        } elseif ($typegrid == 'type8') {
                          wc_get_template_part('content', 'product-grid-9');
                        }elseif ($typegrid == 'type9') {
                          wc_get_template_part('content', 'product-grid-10');
                        }
                      }
                      ?>
                    </div>
                    <?php
                    if ($i_row == $column) echo '</div>';
                    if ($i_row % $column == 0 && $i_row > $column) echo '</div>';
                  endwhile;
                  if ($i_row % $column != 0) echo '</div>';
                  wp_reset_postdata();
                endif;
                ?>
              </div>
              <?php if ($rquery->max_num_pages > 1) { ?>
              <?php switch ($layout_nav) {
                case 'default':
                $type_nav = 'nav_default';
                break;
                case 'type1':
                $type_nav = 'nav_type1';
                break;
                case 'type2':
                $type_nav = 'nav_type2';
                break;
                case 'type3':
                $type_nav = 'nav_type3';
                break;
                default:
                                                # code...
                break;
              }
              $text_more='';
              if($type_nav == 'nav_default' || $type_nav == 'nav_type2' ){
                $text_more='View More';
              }else{
                $text_more='Show More';
              }
              if ($hidden_loadmore != 'enable_hidden_loadmore') :
                ?>
                <div class="text-center <?php echo esc_attr($type_nav); ?>">
                  <a href="#" class="view-more-product modus_ajax_load_more"
                  data-posttype="product" data-layout="producttab-loadmore"
                  data-typeproduct="<?php echo esc_attr($type_product) ?>"
                  data-typeitem="<?php echo esc_attr($type_layout) ?>"
                  data-list="<?php echo esc_attr($typelist) ?>"
                  data-grid="<?php echo esc_attr($typegrid) ?>"
                  data-tax="<?php echo esc_attr($new_line['cat_product']) ?>"
                  data-column="<?php echo esc_attr($column) ?>"
                  data-perpage="<?php echo esc_attr($items_show) ?>"
                  data-currentpage="1"
                  data-maxpage="<?php echo esc_attr($rquery->max_num_pages); ?>"><?php echo esc_html__($text_more, 'modus-sc'); ?></a>
                </div>
                <?php
              endif;
            }
            ?>
          </div>
          <?php
        }
        ?>
      </div>
      <?php if ($layout_nav == 'type3') : ?>
      </div>
    <?php endif; ?>
  </div>
<?php endif; ?>
</div>
</div>
<?php
return ob_get_clean();
}