<?php
add_shortcode( 'modus_single_product', 'modus_tp_product_single' );
function modus_tp_product_single( $atts, $content=null ){
    extract( shortcode_atts(
        array(
            'title'         => '',
            'id'  =>'',
            'el_class'      => '',
            'css'           => '',
        ),$atts ));
    ob_start();
    $content = wpb_js_remove_wpautop( $content, true );
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, '' ), 'modus_single_product', $atts );
    $el_class = modus_extract_class( $el_class ).' '.$css_class;
    if($id !=''){
        $_product = wc_get_product( (int)$id );
    }
?>
    <div class="modus-single-product-shortcode<?php echo esc_attr( $el_class ); ?> sfc wow fadeInUp" data-wow-duration="300ms" data-wow-delay="100ms">
        <?php
            $args = array(
                'post_type' => "product",
                'p' => (int)$id
            );
            $rquery = New Wp_Query( $args );
            if ( $rquery->have_posts() ) :
                while( $rquery->have_posts() ) : $rquery-> the_post();
                    global $post, $product;
                    $columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
                    $post_thumbnail_id = get_post_thumbnail_id( $post->ID );
                    $full_size_image   = wp_get_attachment_image_src( $post_thumbnail_id, 'full' );
                    $image_title       = get_post_field( 'post_excerpt', $post_thumbnail_id );
                    $placeholder       = has_post_thumbnail() ? 'with-images' : 'without-images';
                    $wrapper_classes   = apply_filters( 'woocommerce_single_product_image_gallery_classes', array(
                        'woocommerce-product-gallery',
                        'woocommerce-product-gallery--' . $placeholder,
                        'woocommerce-product-gallery--columns-' . absint( $columns ),
                        'images',
                    ) );
                    ?>
                    <div class="slider slider-for">
                        <div><?php the_post_thumbnail();?></div>
                        <?php
                        $attachment_ids = $product->get_gallery_image_ids();
                        ?>
                        <?php
                        if ( $attachment_ids && has_post_thumbnail() ) {
                            foreach ( $attachment_ids as $attachment_id ) {
                                $thumbnail       = wp_get_attachment_image_src( $attachment_id, 'full' );
                                ?>
                                <div><img src="<?php echo esc_url( $thumbnail[0] ); ?>" alt="slider-for"/></div>
                            <?php
                            }
                        }
                        ?>
                    </div>    

                    <a href="<?php the_permalink(); ?>"><?php echo woocommerce_template_loop_product_title(); ?></a>
                    <?php echo wc_get_product_category_list( $product->get_id(), ', ', '<span class="posted_in">' . _n( '','', count( $product->get_category_ids() ), 'modus_sc' ) . ' ', '</span>' ); ?>

                <?php
                    // Ensure visibility
                    if ( empty( $product ) || ! $product->is_visible() ) {
                        return;
                    }
                    echo '<div class="price-product">';
                        woocommerce_template_loop_price();
                    echo '</div>';
                ?>
                
                <div class="slider slider-nav">
                    <div class="item-nav"><div><?php the_post_thumbnail('modus-image-product-small');?></div></div>
                    <?php
                    $attachment_ids = $product->get_gallery_image_ids();
                    ?>
                    <?php
                    if ( $attachment_ids && has_post_thumbnail() ) {
                        foreach ( $attachment_ids as $attachment_id ) {
                            $thumbnail       = wp_get_attachment_image_src( $attachment_id, 'modus-image-product-small' );
                            ?>
                            <div class="item-nav"><div><img src="<?php echo esc_url( $thumbnail[0] ); ?>" alt="item-nav"/></div></div>
                        <?php
                        }
                    }
                    ?>
                </div>
                <?php
                endwhile;
            endif;
            wp_reset_postdata();
        ?>
    </div>
    <?php
    return ob_get_clean();
}
?>