<?php
/**
* Shortcode Product
*/
add_shortcode( 'modus_product_masonry', 'modus_template_product_masonry' );
function modus_template_product_masonry( $atts, $content){
    extract( shortcode_atts(
        array(
            'type_product' => 'new-product',
            'typecss' => 'type1',
            'items_show' => -1,
            'cat_product' => '',
            'el_class' => '',
            'css' => '',
        ),$atts ));
    ob_start();
    $content = wpb_js_remove_wpautop( $content, true );
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_classs( $css, '' ), 'modus_product_masonry', $atts );
    $el_class = modus_extract_class( $el_class );

    if ( $css_class != '' ){
        $el_class .= modus_extract_class( $css_class );
    }
    ?>
    <div class="modus-product<?php echo $el_class; ?>">
        <?php
        if ( $type_product == 'new-product') {
            if ( $cat_product == '' ){
                $args = array(
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'posts_per_page' => $items_show,
                );
            }else{
               $args = array(
                'post_type' => 'product',
                'post_status' => 'publish',
                'posts_per_page' => $items_show,
                'tax_query' => array(
                    'relation' => 'AND',
                    array(
                        'taxonomy' => 'product_cat',
                        'field'    => 'slug',
                        'terms'    => $cat_product,
                    ),
                ),
            );
           }
       }elseif ( $type_product == 'feature-product' ) {
        $product_visibility_term_ids = wc_get_product_visibility_term_ids();
        if ( $cat_product == '' ) :
            $args = array(
                'post_type' => 'product',
                'post_status' => 'publish',
                'posts_per_page' => $items_show,
                'tax_query'      => array(
                    'relation' => 'AND',
                    array(
                        'taxonomy' => 'product_visibility',
                        'field'    => 'term_taxonomy_id',
                        'terms'    => array( $product_visibility_term_ids['featured'] ),
                    ),
                    array(
                        'taxonomy' => 'product_visibility',
                        'field'    => 'term_taxonomy_id',
                        'terms'    => array( $product_visibility_term_ids['exclude-from-catalog'] ),
                        'operator' => 'NOT IN',
                    ),
                ),
                'orderby'    => 'date',
            );
        else :
            $args = array(
                'post_type' => 'product',
                'post_status' => 'publish',
                'posts_per_page' => $items_show,
                'tax_query'      => array(
                    'relation' => 'AND',
                    array(
                        'taxonomy' => 'product_cat',
                        'field'    => 'slug',
                        'terms'    => $cat_product,
                    ),
                    array(
                        'taxonomy' => 'product_visibility',
                        'field'    => 'term_taxonomy_id',
                        'terms'    => array( $product_visibility_term_ids['featured'] ),
                    ),
                    array(
                        'taxonomy' => 'product_visibility',
                        'field'    => 'term_taxonomy_id',
                        'terms'    => array( $product_visibility_term_ids['exclude-from-catalog'] ),
                        'operator' => 'NOT IN',
                    ),
                )
            );
        endif;
    }elseif ( $type_product == 'sale-product' ){
        if ( $cat_product == '' ) :
            $args = array(
                'post_type' => 'product',
                'post_status' => 'publish',
                'posts_per_page' => $items_show,
                'meta_query'     => array(
                    'relation' => 'OR',
                        array( // Simple products type
                            'key'           => '_sale_price',
                            'value'         => 0,
                            'compare'       => '>',
                            'type'          => 'numeric'
                        ),
                        array( // Variable products type
                            'key'           => '_min_variation_sale_price',
                            'value'         => 0,
                            'compare'       => '>',
                            'type'          => 'numeric'
                        )
                    )
            );
        else :
            $args = array(
                'post_type' => 'product',
                'post_status' => 'publish',
                'posts_per_page' => $items_show,
                'tax_query' => array(
                    'relation' => 'AND',
                    array(
                        'taxonomy' => 'product_cat',
                        'field'    => 'slug',
                        'terms'    => $cat_product,
                    ),
                ),
                'meta_query'     => array(
                    'relation' => 'OR',
                        array( // Simple products type
                            'key'           => '_sale_price',
                            'value'         => 0,
                            'compare'       => '>',
                            'type'          => 'numeric'
                        ),
                        array( // Variable products type
                            'key'           => '_min_variation_sale_price',
                            'value'         => 0,
                            'compare'       => '>',
                            'type'          => 'numeric'
                        )
                    )
            );
        endif;
    } elseif ( $type_product == 'best-seller-product' ) {
        if ($new_line['cat_product'] == '') :
            $args = array(
                'post_type' => 'product',
                'meta_key' => 'total_sales',
                'orderby' => 'meta_value_num',
                'posts_per_page' => $items_show,
            );
        else :
            $args = array(
                'post_type' => 'product',
                'meta_key' => 'total_sales',
                'orderby' => 'meta_value_num',
                'posts_per_page' => $items_show,
                'tax_query' => array(
                    'relation' => 'AND',
                    array(
                        'taxonomy' => 'product_cat',
                        'field' => 'slug',
                        'terms' => $new_line['cat_product'],
                    ),
                ),
            );
        endif;
    } else{
        $args = '';
    };
    $rquery = new Wp_Query($args);
    if ( $type_product == 'new-product' || $type_product == 'feature-product' || $type_product == 'sale-product' ){
        ?>
        <div class="masonry-list modus_wrapper_ajax">
            <div class="grid-sizer"></div>
            <?php
            if ( $rquery -> have_posts() ) :
                while ( $rquery -> have_posts() ) : $rquery -> the_post();
                    $column_width = 'grid-item';
                    if ( get_post_meta( get_the_ID(), 'product_column_width', true) ) {
                        $column_width = 'grid-item grid-item--width2';
                    }elseif ( get_post_meta(get_the_ID(), 'banner_link_title', true) ) {
                        $column_width = 'grid-item grid-item--width2 banner-minimal';
                    }

                    ?>
                    <div class="<?php echo esc_attr( $column_width  );?>">
                        <?php
                        if ( $typecss == 'type1' )
                            wc_get_template_part( 'content', 'product-grid' );
                        if ( $typecss == 'type2' )
                            wc_get_template_part( 'content', 'product-grid-2' );
                        if ( $typecss == 'type3' )
                            wc_get_template_part( 'content', 'product-grid-3' );
                        if ( $typecss == 'type4' )
                            wc_get_template_part( 'content', 'product-grid-4');
                        if ( $typecss == 'type5' )
                            wc_get_template_part( 'content', 'product-grid-5' );
                        if ( $typecss == 'type6' )
                            wc_get_template_part( 'content', 'product-grid-6' );
                        if ( $typecss == 'type7' )
                            wc_get_template_part( 'content', 'product-grid-7' );
                        if ( $typecss == 'type8' )
                            wc_get_template_part( 'content', 'product-grid-8' );
                        if ( $typecss == 'type9' )
                            wc_get_template_part( 'content', 'product-grid-9' );
                        ?>
                    </div>
                    <?php
                endwhile;
                wp_reset_postdata();
            endif;
            ?>
        </div>
        <?php
    }
    if ( $type_product == 'top-rated-product' ):
        $query_args = array(
            'posts_per_page' => $items_show,
            'no_found_rows' => 1,
            'post_status' => 'publish',
            'post_type' => 'product',
            'meta_key'  => '_wc_average_rating',
            'orderby'   => 'meta_value_num',
            'order' => 'DESC',
        );
        $r = new WP_Query( $query_args );
        if ( $r->have_posts() ) {
            ?>
            <div class="masonry-list modus_wrapper_ajax">
                <div class="grid-sizer"></div>
                <?php
                while ( $r->have_posts() ) {
                    $r->the_post();
                    $column_width = 'grid-item';
                    if ( get_post_meta( get_the_ID(), 'product_column_width', true) ) {
                        $column_width = 'grid-item grid-item--width2';
                    }

                    ?>
                    <div class="<?php echo esc_attr( $column_width  );?>">
                        <?php
                        if ( $typecss == 'type1' )
                            wc_get_template_part( 'content', 'product-grid',array( 'show_rating' => true ));
                        if ( $typecss == 'type2' )
                            wc_get_template_part( 'content', 'product-grid-2',array( 'show_rating' => true ));
                        if ( $typecss == 'type3' )
                            wc_get_template_part( 'content', 'product-grid-3',array( 'show_rating' => true ));
                        if ( $typecss == 'type4' )
                            wc_get_template_part( 'content', 'product-grid-4',array( 'show_rating' => true ));
                        if ( $typecss == 'type5' )
                            wc_get_template_part( 'content', 'product-grid-5',array( 'show_rating' => true ));
                        if ( $typecss == 'type6' )
                            wc_get_template_part( 'content', 'product-grid-6',array( 'show_rating' => true ));
                        if ( $typecss == 'type7' )
                            wc_get_template_part( 'content', 'product-grid-7',array( 'show_rating' => true ));
                        ?>
                    </div>
                    <?php
                }
                wp_reset_postdata();
                ?>
            </div>
            <?php
        }
        wp_reset_postdata();
    endif;
    if ( $type_product == 'bestselling-product' ){
        if(class_exists('WC_Bestseller')){
            $WC_Bestseller= new WC_Bestseller();
            $args_id = $WC_Bestseller->list_product_bestseller();
            if(count($args_id)>0){
                $arg_bestseller = array();
                foreach ( $args_id as $value ){
                    $arg_bestseller[]= $value->product_id;
                }
                if($cat_product ==''){
                   $args = array(
                    'post_type' => 'product',
                    'post__in' => $arg_bestseller,
                    'posts_per_page' => $items_show
                );
               }else{
                $term_id = get_term_by('slug', $cat_product, 'product_cat');
                $term_id = $term_id  -> term_id;
                $modus_term_childs = get_term_children($term_id,'product_cat');
                $modus_term_childs[] = $term_id;
                $args = array(
                    'post_type' => 'product',
                    'post__in' => $arg_bestseller,
                    'posts_per_page' => $items_show,
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'product_cat',
                            'field'    => 'term_id',
                            'terms'    => $modus_term_childs,
                        ),
                    ),
                );
            }
            ?>
            <div class="masonry-list modus_wrapper_ajax">
                <div class="grid-sizer"></div>
                <?php
                $the_query = new WP_Query($args);
                while ( $the_query->have_posts() ) {
                    $the_query->the_post();
                    $id_post = get_the_ID();
                    $_pf = new WC_Product_Factory();
                    $_product = $_pf->get_product( $id_post );
                    $column_width = 'grid-item';
                    if ( get_post_meta( get_the_ID(), 'product_column_width', true) ) {
                        $column_width = 'grid-item grid-item--width2';
                    }

                    ?>
                    <div class="<?php echo esc_attr( $column_width  );?>">
                        <div class="product type-product">
                            <div class="item-product">
                                <div class="product-img">
                                    <a href="<?php echo get_the_permalink($id_post);?>" itemprop="image" title="<?php echo get_the_title( $id_post); ?>"><?php echo get_the_post_thumbnail( $id_post,'modus-slide-product'); ?></a>
                                </div>
                                <h3><a href="<?php echo get_the_permalink( $id_post); ?>"><?php echo get_the_title( $id_post); ?></a></h3>
                                <?php
                                $terms = get_the_terms( $id_post, 'product_cat' );
                                if(is_array($terms)){
                                    echo '<ul class="terms-product">';

                                    foreach ($terms as $term) {
                                        $term_link = get_term_link( $term );
                                        echo '<li><a href="' . esc_url( $term_link ) .'" title="'.$term->name.'">'.esc_attr( $term->name ).'</a></li>';
                                    }
                                    echo '</ul>';
                                }
                                ?>
                                <div class="format-price-addcart">
                                    <div class="price-product"><?php echo woocommerce_template_loop_price();?></div>
                                    <div class="btn-cart"><?php woocommerce_template_loop_add_to_cart();?></div>
                                </div>
                                <div class="share-yith">
                                    <?php
                                    if(class_exists( 'YITH_WOOCOMPARE' ) ) {
                                        echo '<div class="btn-share btn-compare">';
                                        printf('<div class="add-to"><a onclick="" data-toggle="tooltip" href="%s" class="%s" data-product_id="%d" title="%s"><i class="fa fa-retweet" aria-hidden="true"></i>'.esc_html__('Compare', 'modus_sc').'</a></div>', modus_add_compare_action($id_post), 'add_to_compare compare button', $id_post, esc_html__('Compare', 'modus_sc'));
                                        echo '</div>';
                                    }
                                    if (class_exists('YITH_WCWL')) {
                                        echo ' <div class="btn-share btn-wishlist">';
                                        echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                                        echo '<span class="wishlist-count"> &#40;'. YITH_WCWL()->count_products() .'&#41;</span>';
                                        echo '</div>';
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                }
                wp_reset_postdata();
                ?>
            </div>
            <?php
        }
    }
}
?>
</div>
<?php
return ob_get_clean();
}