<?php
/**
 * Portfolio Tab template
 */
add_shortcode( 'modus_portfolio_tab', 'modus_tp_portfolio_tab' );
function modus_tp_portfolio_tab( $atts ){
    extract( shortcode_atts(
        array(
            'title'             => '',
            'column' 	        => 2,
            'no_padding'        => 'padding',
            'values'            => '',
            'items_show'        => 6,
            'el_class' 		    => '',
            'css' 			    => '',
        ),$atts));
    ob_start();
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'modus_portfolio_tab', $atts );
    $el_class = modus_extract_class( $el_class );

    if ( $css_class != '' ){
        $el_class .= modus_extract_class( $css_class );
    }
    $cl_item = 'col-xs-12 col-sm-3 col-md-3';
    switch ( $column ) {
        case '2':
            $cl_item = 'col-xs-12 col-sm-6 col-md-6';
            break;
        case '3':
            $cl_item = 'col-xs-12 col-sm-4 col-md-4';
            break;
        case '4':
            $cl_item = 'col-xs-12 col-sm-6 col-md-3';
            break;
        case '6':
            $cl_item = 'col-xs-12 col-sm-4 col-md-2';
            break;
        case '6':
            $cl_item = 'col-xs-12 col-sm-4 col-md-2';
            break;    
        default:
            $cl_item = 'col-xs-12 col-sm-6 col-md-6';
            break;
    }
    $values = (array) vc_param_group_parse_atts( $values );
    ?>
    <div class="modus-portfolio-tab modus-portfolio-shortcode<?php echo $el_class; ?>">
         <?php if ( $title != '' ) : ?>
            <div class="heading-title">
                <h2><?php echo esc_html__( $title ); ?></h2>
            </div>
        <?php endif; ?>
            <ul class="list-inline md-portfolio-tt">
                <?php
                    $i = 0;
                    foreach ($values as $data) {
                        $i++;
                        $new_line = $data;
                        $new_line['title'] = isset( $data['title'] ) ? $data['title'] : '';
                        $new_line['portfolio_cat'] = isset( $data['portfolio_cat'] ) ? $data['portfolio_cat'] : '';
                        ?>
                        <li class="<?php if( $i == 1 ) echo 'active';?>"><a href="#" data-filter="portfolio-<?php echo esc_attr( $new_line['portfolio_cat'] ).'-'.esc_attr( $i );?>"><?php echo esc_attr( $new_line['title'] );?></a></li>
                        <?php
                    }
                ?>
            </ul>
        <div class="row <?php echo esc_html__($no_padding);?>">
            <div class="modus_wrapper_ajax md-port">
                <?php
                    $j=0;
                    foreach ($values as $data) {
                        $j++;
                        $new_line = $data;
                        $new_line['title'] = isset( $data['title'] ) ? $data['title'] : '';
                        $new_line['portfolio_cat'] = isset( $data['portfolio_cat'] ) ? $data['portfolio_cat'] : '';
                        if ( $new_line['portfolio_cat'] == '' ) :
                            $args = array(
                                'post_type' => 'portfolio',
                                'post_status' => 'publish',
                                'posts_per_page' => $items_show,
                            );
                        else :
                            $args = array(
                                'post_type' => 'portfolio',
                                'post_status' => 'publish',
                                'posts_per_page' => $items_show,
                                'tax_query' => array(
                                    'relation' => 'AND',
                                    array(
                                        'taxonomy' => 'portfolio_cat',
                                        'field'    => 'slug',
                                        'terms'    => $new_line['portfolio_cat'],
                                    ),
                                ),
                            );
                        endif;
                        $rquery_post = new Wp_Query( $args );
                        ?>
                        <div class="modus_portfolio_tab_content <?php if( $j == 1 ) echo 'active';?> portfolio-<?php echo esc_attr( $new_line['portfolio_cat'] ).'-'.esc_attr( $j );?>">
                            <div class="modus-portfolio-more ">
                            <?php
							$count = '';
                            while ( $rquery_post -> have_posts() ) : $rquery_post -> the_post();
                                $modus_portfolio_cat = get_the_terms( get_the_ID(),'portfolio_cat');
								if($modus_portfolio_cat){
									$count = count( $modus_portfolio_cat );
								}
                                $i = 0;
                                $filter_name = $filter_slug = '';
                                if ( $modus_portfolio_cat != '' ):
                                    foreach($modus_portfolio_cat as $term){
                                        $i++;
                                        $term_link = get_term_link( $term );
                                        $filter_slug .= $term-> slug.' ';
                                        $filter_name .= '<li><a href="'.$term_link.'">'.$term-> name.'</a></li>';
                                        if ( $count != $i ) {
                                            $filter_name .= '&sbquo; ';
                                        }
                                        else {
                                            $filter_name .= '';
                                        }
                                    }
                                endif;
                            ?>
                                <div class="<?php echo $cl_item; ?>">
                                    <div class="item-portfolio">
                                        <?php  the_post_thumbnail( 'full' );?>
                                        <div class="box-holder">
                                            <div class="box-holder-content">
                                                <span><?php the_title();?></span>
                                                <ul class="cat_portfolio">
                                                   <?php echo $filter_name; ?>
                                                </ul>
                                                <a class="md-linkto" href="<?php the_permalink();?>"><i class="Pe-icon-7-stroke-link"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            <?php
                            endwhile;
                             wp_reset_postdata();
                            ?>
                            </div>
                            <?php if($rquery_post -> max_num_pages > 1) { ?>
                            <div class="col-md-12 col-sm-12 col-xs-12">
                                <div class="text-center">
                                    <a href="#" class="view-more hvr-trim modus_ajax_load_more more-portfolio" data-posttype="portfolio"  data-column="<?php echo esc_html($column) ?>" data-tax="<?php echo esc_html($new_line['portfolio_cat']); ?>" data-perpage="<?php echo esc_html($items_show) ?>" data-currentpage="1" data-maxpage="<?php echo esc_html($rquery_post -> max_num_pages); ?>"><?php echo esc_html__( 'show more','modus_sc' );?></a>
                                </div>
                            </div>
                            <?php } ?>
                        </div>

                    <?php
                    }
                ?>
            </div>
        </div>

    </div>
    <?php
    return ob_get_clean();
}