<?php
/**
* Shortcode Portfolio
*/
add_shortcode( 'modus_portfolio', 'modus_template_portfolio' );
function modus_template_portfolio( $atts, $content){
    extract( shortcode_atts(
        array(
            'title' =>'',           
            'items_show' => -1,
            'cat_portfolio' => '',
            'column' => 4,
            'row' => 1,
            'show_nav' => '',
            'show_navbt' => '',
            'el_class' => '',
            'css' => '',
        ),$atts ));
    ob_start();
    $content = wpb_js_remove_wpautop( $content, true );
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_classs( $css, '' ), 'modus_portfolio', $atts );
    $el_class = modus_extract_class( $el_class );

    if ( $css_class != '' ){
        $el_class .= modus_extract_class( $css_class );
    }
    $cl_item = 'col-xs-12 col-sm-3 col-md-3';   
    switch ( $column ) {
        case '1':
            $cl_class = 'col-xs-12 col-sm-12 col-md-12';
            break;
        case '2':
            $cl_class = 'col-xs-12 col-sm-6 col-md-6';
            break;
        case '3':
            $cl_class = 'col-xs-12 col-sm-4 col-md-4';
            break;
        case '4':
            $cl_class = 'col-xs-12 col-sm-6 col-md-3';
            break;

        default:
            $cl_class = '';
            break;
    }
    $show_nav_cl = '';
    if ( $show_nav == 'enable_show_nav' ){
            $show_nav_cl .= 'show_nav ';
    }
    if ( $show_navbt == 'enable_show_navbt' ){
            $show_nav_cl .= 'show_navbt';
    }    
    ?>
    <div class="modus-portfolio-slider <?php echo esc_attr( $el_class ); ?>">
        <?php if ( $title != '' ) : ?>
            <div class="heading-title-port">
                <h2><?php echo esc_html__( $title ); ?></h2>
            </div>
        <?php endif; ?>
        <?php        
            if ( $cat_portfolio == '' ){
                $args = array(
                    'post_type' => 'portfolio',
                    'post_status' => 'publish',
                    'posts_per_page' => $items_show,
                );
            }else{
                 $args = array(
                    'post_type' => 'portfolio',
                    'post_status' => 'publish',
                    'posts_per_page' => $items_show,
                    'tax_query' => array(
                        'relation' => 'AND',
                        array(
                            'taxonomy' => 'portfolio_cat',
                            'field'    => 'slug',
                            'terms'    => $cat_portfolio,
                        ),
                    ),
                );
            }
        $rquery = new Wp_Query($args);
       ?>          
          
            <div class="initSlide_product modus_port_slider <?php echo esc_attr( $show_nav_cl );?>" data-columns="<?php echo esc_attr( $column ); ?>" data-rows="<?php echo esc_attr( $row );?>" >
                <div class="beans-stepslider" data-rotate="true">
                    <div class="beans-mask">
                        <div class="row">
                            <div class="beans-slideset wow fadeInUp" data-wow-duration="500ms" data-wow-delay="100ms">
                                <?php
                                if ( $rquery -> have_posts() ) :
                                    while ( $rquery -> have_posts() ) : $rquery -> the_post();
                                       ?>
                                        <div class="<?php echo $cl_item; ?>">
                                            <div class="beans-slide">                                        
                                                <div class="item-portfolio">
                                                    <div class="item-portfolio-sub">
                                                        <?php  the_post_thumbnail( 'full' );?>
                                                        <div class="box-holder">
                                                            <div class="box-holder-content">                           
                                                                <a class="md-linkto" href="<?php the_permalink();?>"><i class="Pe-icon-7-stroke-link"></i></a>
                                                            </div>
                                                        </div>
                                                    </div>                                                    
                                                    <span><?php the_title();?></span>   
                                                </div>                                        
                                            </div>
                                        </div>
                                       <?php
                                    endwhile;
                                    wp_reset_postdata();
                                endif;
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="beans-pagination"></div>
                    <a class="btn-prev" href="#"><i class="fa fa-angle-left"></i></a>
                    <a class="btn-next" href="#"><i class="fa fa-angle-right"></i></a>
                </div>
            </div>
    </div>
    <?php
    return ob_get_clean();
}