<?php
/**
 * Map template
 */

add_shortcode( 'modus_map', 'modus_tp_map' );
function modus_tp_map( $atts, $content=null ){
    extract( shortcode_atts(
        array(
            'google_map' => 'normal',
            'latitude' => 0,
            'longitude' => 0,
            'image'=>'',
            'name' => '',
            'content2' => '',
            'el_class' => '',
            'css' => '',
        ),$atts));
        $content = wpb_js_remove_wpautop( $content, true );
    ob_start();
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'modus_map', $atts );
    $url_img = wp_get_attachment_url($image);
    $el_class = modus_extract_class( $el_class );

    if ( $css_class != '' ){
        $el_class .= modus_extract_class( $css_class );
    }
    ?>
    <div class="google-map modus-map<?php echo $el_class;?>">
        <div class="row">
            <div class="col-xs-12">
            <?php
                switch ( $google_map ) {
                    case 'normal':
                        ?>
                        <?php echo $content; ?>
                        <?php
                        break;
                    case 'other':
                        ?>
						<div class="modus_map_api">
							<div class="map" data-lat="<?php echo $latitude; ?>" data-lng="<?php echo $longitude; ?>" data-zoom="15"></div>
							<div class="hide">
								<div class="map-info" data-image="<?php echo $url_img; ?>" >
									<h2><?php echo $name; ?></h2>
									<p><?php echo $content2; ?></p>
								</div>
                            </div>
                        </div>
                        <?php
                        break;
                    default:
                        # code...
                        break;
                }
            ?>
            </div>
        </div>
    </div>
    <?php
		$modus_settings = modus_settings();
		$modus__styles = modus_theme_styles();
		$modus__scripts = modus_theme_scripts();
		if(isset($modus_settings['mapapi']) && $modus_settings['mapapi']!=''){
			wp_enqueue_script('modus-map',$modus__scripts['map'] ,array( 'jquery' ), '1.0', true);
			wp_enqueue_script('maps-api', 'https://maps.googleapis.com/maps/api/js?key='.esc_attr($modus_settings['mapapi']).'&callback=initGoogleMap',array( 'jquery' ), '', true);
		}
    return ob_get_clean();
}