<?php
/**
 * Icon Advanced
 */

add_shortcode( 'modus_icon', 'tp_icon' );
function tp_icon( $atts, $content=null ){
    extract( shortcode_atts(
        array(
            'layout' => 'layout1',
            'values' => '',
            'column' => '1',
            'title' => '',
            'icon_font' => '',
            'size' => 'md',
            'align' => 'left',
            'text_link' => '#',
            'el_class' => '',
            'css' => '',
        ),$atts));
		
        $content = wpb_js_remove_wpautop( $content, true );
    ob_start();
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'modus_icon', $atts );
    $el_class = modus_extract_class( $el_class );
    if ( $css_class != '' ){
        $el_class .= modus_extract_class( $css_class );
    }
    $values = (array) vc_param_group_parse_atts( $values );
    switch ( $column ) {
        case '1':
            $cl_class = 'col-xs-12 col-sm-12 col-md-12';
            break;
        case '2':
            $cl_class = 'col-xs-12 col-sm-6 col-md-6';
            break;
        case '3':
            $cl_class = 'col-xs-12 col-sm-4 col-md-4';
            break;
        case '4':
            $cl_class = 'col-xs-12 col-sm-3 col-md-3';
            break;
        case '5':
            $cl_class = 'col-xs-15 col-sm-15 col-md-15';
            break;
        case '6':
            $cl_class = 'col-xs-12 col-sm-4 col-md-2';
            break;

        default:
            $cl_class = '';
            break;
    }
    ?>
    <?php if($layout == 'layout1'): ?>
        <div class="modus-icon<?php echo $el_class; ?>">
            <div class="sfc wow fadeInUp" data-wow-duration="300ms" data-wow-delay="100ms">
                <div class="modus-iconbox icon-align-<?php echo esc_attr($align).' size-'.$size;?>">
                    <div class="icon">
                        <i class="hvr-wobble-vertical <?php echo esc_attr( $icon_font );?>"></i>
                    </div>
                    <div class="box-content">
                        <h3 class="title"><?php echo esc_attr( $title );?></h3>
                        <div><?php echo $content; ?></div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif;
        if($layout == 'layout2'):
    ?>
        <div class="modus-icon modus-icon-2<?php echo $el_class; ?>">
            <div class="sfc wow fadeInUp" data-wow-duration="300ms" data-wow-delay="100ms">
                <?php
                    foreach ( $values as $data ) {
                        $new_line['title'] = isset( $data['title'] ) ? $data['title'] : '';
                        $new_line['content'] = isset( $data['content'] ) ? $data['content'] : '';
                        $new_line['icon_font'] = isset( $data['icon_font'] ) ? $data['icon_font'] : '';
                        $new_line['image'] = isset( $data['image'] ) ? $data['image'] : '';
                        $new_line['image_2'] = isset( $data['image_2'] ) ? $data['image_2'] : '';
                        $new_line['text_link'] = isset( $data['text_link'] ) ? $data['text_link'] : '';
                        ?>
                        <div class="<?php echo esc_attr( $cl_class ); ?>">
                            <div class="modus-iconbox icon-align-<?php echo esc_attr($align).' size-'.$size;?>">
                                <img src="<?php echo wp_get_attachment_url( $new_line['image'] ); ?>" alt="<?php echo esc_html( $new_line['title'] );?>">
                                <div class="box-icon">
                                    <div class="midle">
                                        <div class="icon">
                                            <?php if ($new_line['image_2'] != '') {
                                                echo '<img class="modus-img-icon" src="' . wp_get_attachment_url( $new_line['image_2'] ) . '" alt="">';
                                            } else {?>
                                                <i class="hvr-wobble-vertical <?php echo $new_line['icon_font']; ?>"></i>
                                            <?php } ?>
                                        </div>
                                        <div class="box-content">
                                            <a href="<?php echo esc_attr($new_line['text_link']); ?>" class="title"><?php echo esc_html( $new_line['title'] );?></a>
                                            <?php if ( $new_line['content'] != '' ) : ?>
                                                <div><?php echo esc_html( $new_line['content'] ); ?></div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php
                    }
                ?>
            </div>
        </div>
     <?php endif;
        if($layout == 'layout3'):
    ?>
        <div class="modus-icon modus-icon-3<?php echo $el_class; ?>">
            <div class="sfc wow fadeInUp" data-wow-duration="300ms" data-wow-delay="100ms">
                <?php
                    foreach ( $values as $data ) {
                        $new_line['title'] = isset( $data['title'] ) ? $data['title'] : '';
                        $new_line['content'] = isset( $data['content'] ) ? $data['content'] : '';
                        $new_line['icon_font'] = isset( $data['icon_font'] ) ? $data['icon_font'] : '';
                        $new_line['image'] = isset( $data['image'] ) ? $data['image'] : '';
                        $new_line['image_2'] = isset( $data['image_2'] ) ? $data['image_2'] : '';
                        $new_line['text_link'] = isset( $data['text_link'] ) ? $data['text_link'] : '';
                        ?>
                        <div class="<?php echo esc_attr( $cl_class ); ?>">
                            <div class="modus-iconbox icon-align-<?php echo esc_attr($align).' size-'.$size;?>">   
                                <div class="box-icon">
                                    <div class="midle">
                                        <div class="icon">
                                            <?php if ($new_line['image_2'] != '') {
                                                echo '<img class="modus-img-icon" src="' . wp_get_attachment_url( $new_line['image_2'] ) . '" alt="">';
                                            } else {?>
                                                <i class="hvr-wobble-vertical <?php echo $new_line['icon_font']; ?>"></i>
                                            <?php } ?>
                                        </div>
                                        <div class="box-content">
                                            <a href="<?php echo esc_attr($new_line['text_link']); ?>" class="title"><?php echo esc_html( $new_line['title'] );?></a>
                                            <?php if ( $new_line['content'] != '' ) : ?>
                                                <div><?php echo esc_html( $new_line['content'] ); ?></div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php
                    }
                ?>
            </div>
        </div>
     <?php endif; ?>
    <?php
    return ob_get_clean();
}