<?php
add_shortcode( 'modus_pagetitle', 'modus_template_pagetitle' );
function modus_template_pagetitle( $atts, $content=null){
    extract( shortcode_atts(
        array(
            'layout'=>'default',
            'title'=>'',
            'sub_title'=>'',
            'align'=>'left',
            'size' => 'md',
            'show_line' => '',
            'el_class' => '',
            'css' => '',
        ),$atts ));
    ob_start();
    $content = wpb_js_remove_wpautop( $content, true );
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, '' ), 'modus_pagetitle', $atts );

    $el_class = modus_extract_class( $el_class );
    if ( $css_class != '' ){
        $el_class .= modus_extract_class( $css_class );
    }
    $aligntxt = 'text-center';
    switch ( $align ) {
        case 'left':
            $aligntxt = 'text-left';
            break;
        case 'right':
            $aligntxt = 'text-right';
            break;
        case 'center':
            $aligntxt = 'text-center';
            break;

        default:
            # code...
            break;
    }
    ?>

    <div class="modus-headingtitle <?php echo (esc_attr( $el_class ) . ' ' . esc_attr($layout) . ' ' . esc_attr($size) ) ;?> sfc wow fadeInUp" data-wow-duration="300ms" data-wow-delay="100ms">
        <div class="shortcode-title wpb_bottom-to-top <?php echo esc_attr ( $aligntxt ); ?>">
            <?php if ( $layout == 'head-4' ) : ?>
                <?php if ( $title != '' ) : ?>
                    <div class="box-table">
                        <div class="inline-left"></div>
                        <div class="inline-center">
                            <h2>
                                <?php echo wp_kses_post( $title );?>
                                <?php if ( $layout == 'head-1') echo '<span class="span"></span>'; ?>
                            </h2>
                        </div>
                        <div class="inline-right"></div>
                    </div>
                <?php endif; ?>
            <?php else: ?>
                <?php if ( $title != '' ) : ?>
                    <h2>
                        <?php echo wp_kses_post( $title );?>
                        <?php if ( $layout == 'head-1') echo '<span class="span"></span>'; ?>
                    </h2>
                <?php endif; ?>
                <?php if ( $sub_title != '' ) : ?>
                      <h3 class="<?php echo esc_attr ( $aligntxt ); ?>">
                        <span class="md-sub-title">
                            <?php echo wp_kses_post( $sub_title );?>
                        </span>
                    </h3>
                <?php endif; ?>
                <?php if ( $content != '' ) : ?>
                    <div class="txt-heading">
                        <?php echo  $content ; ?>
                    </div>
                <?php endif; ?>
                <?php if ( $show_line == 'enable_show_line' ) : ?>
                    <div class="line-headingtitle"></div>
                <?php endif; 
            endif;
            ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
?>