<?php
/**
* Counter
*/

add_action("wp_enqueue_scripts", "modus_counter_assets" );
// Shortcode handler function for stats counter
add_shortcode( 'modus_start_counter', 'modus_tp_counter' );

function modus_counter_assets(){
    wp_enqueue_script("modus-stats-counter-js-apear",get_template_directory_uri().'/assets/counter/jquery-appear.min.js', array('jquery'), '1.0',true);
    wp_enqueue_style("modus-stats-counter-style",get_template_directory_uri().'/assets/counter/stats-counter.min.css',array(), false);
}

function modus_tp_counter($atts, $content = null)
{
    extract(shortcode_atts( array(
        'title' => '',
        'layout' => 'one-counter',
        'values' => '',
        'icon_font' => '',
        'counter_value' => '',
        'counter_sep' => ',',
        'counter_decimal' => '.',
        'speed'=>'3',
        'el_class' => '',
        'css' => ''
    ),$atts));
    $content = wpb_js_remove_wpautop( $content, true );
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'modus_start_counter', $atts );
    $el_class = modus_extract_class( $el_class );
    if ( $css_class != '' ){
        $el_class .= modus_extract_class( $css_class );
    }
    ob_start();
    $values = (array) vc_param_group_parse_atts( $values );
    ?>
    <div class="modus-counter<?php echo esc_attr( $el_class ); ?>">
        <div class="sfc wow fadeInUp" data-wow-duration="300ms" data-wow-delay="100ms">
            <?php if ( $layout == 'one-counter' ) : ?>
                <div class="relative item_counter">
                    <div class="icon">
                        <i class="<?php echo esc_attr( $icon_font );?>"></i>
                    </div>
                    <?php
                    $id = 'counter_'.uniqid(rand());
                    if($counter_sep == ""){
                        $counter_sep = 'none';
                    }
                    if($counter_decimal == ""){
                        $counter_decimal = 'none';
                    }
                    echo '<div id="'.esc_attr( $id ).'" data-id="'.esc_attr( $id ).'" class="stats-number num" data-speed="'.esc_attr( $speed ).'" data-counter-value="'.esc_attr( $counter_value ).'" data-separator="'.esc_attr( $counter_sep ).'" data-decimal="'.esc_attr( $counter_decimal ).'">0</div>';
                    ?>
                    <span class="text"><?php echo esc_html__( $title );?></span>
                </div>
            <?php endif ; ?>
            <?php if ( $layout == 'list-counter' ) :
                echo '<div class="list-counter">';
                $i=0;
                foreach ( $values as $data ) {
                    $i++;
                    $title = isset( $data['title'] ) ? $data['title'] : '';
                    $font = isset( $data['icon_font'] ) ? $data['icon_font'] : '';
                    $modus_image = isset( $data['image'] ) ? $data['image'] : '';
                    $index = isset( $data['counter_value'] ) ? $data['counter_value'] : '';
                    ?>
                    <div class="relative item_counter column-<?php echo esc_attr( count($values) );?>">
                        <?php if ($modus_image != '') {
                            echo '<div class="icon modus-img-counter"><img class="modus-img-icon" src="' . wp_get_attachment_url( $modus_image ) . '" alt=""></div>';
                        } else {?>
                             <div class="icon"><i class="<?php echo esc_attr( $font );?>"></i> </div>
                        <?php } ?>

                        <?php
                        $id = 'counter_'.uniqid(rand());
                        if($counter_sep == ""){
                            $counter_sep = 'none';
                        }
                        if($counter_decimal == ""){
                            $counter_decimal = 'none';
                        }
                        echo '<div id="'.esc_attr( $id ).'" data-id="'.esc_attr( $id ).'" class="stats-number num" data-speed="'.esc_attr( $speed ).'" data-counter-value="'.esc_attr( $index ).'" data-separator="'.esc_attr( $counter_sep ).'" data-decimal="'.esc_attr( $counter_decimal ).'">0</div>';
                        ?>
                        <span class="text"><?php echo esc_html__( $title );?></span>
                    </div>
                    <?php
                }
                echo '</div>';
                ?>
            <?php endif ; ?>
            <?php if ( $layout == 'list-counter-2' ) :
                echo '<div class="list-counter-2">';
                $i=0;
                foreach ( $values as $data ) {
                    $i++;
                    $title = isset( $data['title'] ) ? $data['title'] : '';
                    $font = isset( $data['icon_font'] ) ? $data['icon_font'] : '';
                    $modus_image = isset( $data['image'] ) ? $data['image'] : '';
                    $index = isset( $data['counter_value'] ) ? $data['counter_value'] : '';
                    ?>
                    <div class="relative item_counter column-<?php echo esc_attr( count($values) );?>">
                        <?php if ($modus_image != '') {
                            echo '<div class="icon modus-img-counter"><img class="modus-img-icon" src="' . wp_get_attachment_url( $modus_image ) . '" alt=""></div>';
                        } else {?>
                            <div class="icon"><i class="<?php echo esc_attr( $font );?>"></i> </div>
                        <?php } ?>

                        <span class="text"><?php echo esc_html__( $title );?></span>
                        <?php
                        $id = 'counter_'.uniqid(rand());
                        if($counter_sep == ""){
                            $counter_sep = 'none';
                        }
                        if($counter_decimal == ""){
                            $counter_decimal = 'none';
                        }
                        echo '<div id="'.esc_attr( $id ).'" data-id="'.esc_attr( $id ).'" class="stats-number num" data-speed="'.esc_attr( $speed ).'" data-counter-value="'.esc_attr( $index ).'" data-separator="'.esc_attr( $counter_sep ).'" data-decimal="'.esc_attr( $counter_decimal ).'">0</div>';
                        ?>
                    </div>
                    <?php
                }
                echo '</div>';
                ?>
            <?php endif ; ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
