<?php
/**
 *  Contact Info
 */
add_shortcode( 'modus_contactinfo', 'modus_tp_contactinfo' );

function modus_tp_contactinfo( $atts, $content = null ) { // New function parameter $content is added!
    extract( shortcode_atts( array(
        'title' => '',
        'phone' => '',
        'email' => '',
        'address' => '',
        'align_heading' => 'text-left',
        'css_animation' => '',
        'el_class' => '',
        'css' => '',
    ), $atts ) );

    ob_start();
    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'modus_contactinfo', $atts );
    $css_class_anm = modus_getCSSAnimation( $css_animation );
    $el_class = modus_extract_class( $el_class );
    if ( $css_class != '' ){
        $el_class .= modus_extract_class( $css_class );
    }
    if ( $css_class_anm != '' ){
        $el_class .= ' '.$css_class_anm;
    }
    $el_class .= ' '.$align_heading;
    ?>

    <div class="modus-contactinfo <?php echo $el_class; ?>">
        <?php if ( $title != '' ) : ?>
            <div class="modus-headingtitle md">
                <div class="shortcode-title text-left">
                    <h2><?php echo wp_kses_post( $title );?></h2>
                </div>
            </div>
        <?php endif; ?>
        <?php if ( $phone != '' || $email != '' || $address != '' ) : ?>
            <ul>
                <?php if ( $address != '' ) : ?><li><em class="fa fa-map-marker"></em><span class="text"><?php echo esc_attr( $address );?></span></li><?php endif; ?>
                <?php if ( $email != '' ) : ?><li><em class="fa fa-envelope"></em><span class="label-contact"><?php echo esc_html__('Email: '); ?></span><a href="mailto:<?php echo esc_attr( $email );?>"><span class="text"><?php echo esc_attr( $email );?></span></a></li><?php endif; ?>
                <?php if ( $phone != '' ) : ?><li><em class="fa fa-phone"></em><span class="label-contact"><?php echo esc_html__('Hotline: '); ?></span><a href="callto:<?php echo esc_attr( $phone );?>"><span class="text"><?php echo esc_attr( $phone );?></span></a></li><?php endif; ?>
            </ul>
        <?php endif; ?>
    </div>

    <?php
    return ob_get_clean();
}