<?php
add_action('vc_before_init', 'wedding_shortcode_countdown');

function wedding_shortcode_countdown(){
    vc_map( array(
      "name" => esc_html__( "[Wedding] Countdown", "wedding-sc" ),
      "base" => "wedding_countdown",
      "icon" => "wedding_vc_icon",
      "category" => esc_html__( "Wedding", "wedding-sc"),
      'description' => 'Wedding countdown',
      "params" => array(
        array(
        "type" => "textfield",
        "holder" => "div",
        "class" => "",
        "heading" => esc_html__( "Title", "wedding-sc" ),
        "param_name" => "title",
        "value" => '',
        ),
        array(
            "type" => "datetimepicker",
            "class" => "",
            "heading" => esc_html__("Target Time For Countdown", "wedding-sc"),
            "param_name" => "datetime",
            "value" => "",
            "description" => esc_html__("Date and time format (yyyy/mm/dd hh:mm:ss).", "wedding-sc"),
        ),
        array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Countdown Timer Depends on", "wedding-sc"),
            "param_name" => "ult_tz",
            "value" => array(
                    esc_html__("WordPress Defined Timezone","wedding-sc") => "ult-wptz",
                    esc_html__("User System Timezone","wedding-sc") => "ult-usrtz",
                ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Extra class name', 'wedding-sc' ),
            'param_name' => 'el_class',
            'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'wedding-sc' )
        ),
        array(
            'type' => 'css_editor',
            'heading' => esc_html__( 'CSS box', 'wedding-sc' ),
            'param_name' => 'css',
            'group' => esc_html__( 'Design Options', 'wedding-sc' ),
        )
      )
    ) );
}