<?php
add_action('vc_build_admin_page', 'modus_shortcode_timeline');
add_action( 'vc_before_init', 'modus_shortcode_timeline' );

function modus_shortcode_timeline() {

    vc_map( array(
        "name" => esc_html__( "[Modus] Time Line", 'modus_sc' ),
        "base" => "modus_time_line",
        'icon' => 'modus_vc_icon',
        "category" => 'Modus',
        "description" => esc_html__( 'Show time line about us.','modus_sc' ),
        "params" => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'modus_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Widget Title.', 'modus_sc' ),
                'admin_label' => true,
            ),
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Values', 'modus_sc' ),
                'param_name' => 'values',
                'description' => esc_html__( 'Enter icon, title and color.', 'modus_sc' ),
                'value' => urlencode( json_encode( array(
                    array(
                        'label' => esc_html__( 'Label 1', 'modus_sc' ),
                    ),
                    array(
                        'label' => esc_html__( 'Label 2', 'modus_sc' ),
                    ),
                    array(
                        'label' => esc_html__( 'Label 3', 'modus_sc' ),
                    ),
                ) ) ),
                'params' => array(
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Time', 'modus_sc' ),
                        'param_name' => 'index',
                        'description' => esc_html__( 'Time line event.', 'modus_sc' ),
                        'admin_label' => true,
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Label', 'modus_sc' ),
                        'param_name' => 'label',
                        'description' => esc_html__( 'Label tab.', 'modus_sc' ),
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Sub Label', 'modus_sc' ),
                        'param_name' => 'sub_label',
                        'description' => esc_html__( 'Sub label.', 'modus_sc' ),
                    ),
                    array(
                        "type" => "textarea",
                        "heading" => esc_html__( "Description", 'modus_sc' ),
                        "param_name" => "content",
                        "value" => esc_html__( "", 'modus_sc' ),
                        "description" => esc_html__( "add content.", 'modus_sc' ),
                    ),
                    array(
                        'type' => 'attach_image',
                        'heading' => esc_html__( 'Image', 'modus_sc' ),
                        'param_name' => 'image',
                        'description' => esc_html__( 'Select image from media library.', 'modus_sc' ),
                    ),
                    array(
                        'type' => 'vc_link',
                        'heading' => esc_html__( 'URL (Link)', 'automatic_sc' ),
                        'param_name' => 'link',
                        'description' => esc_html__( 'Add link to button..', 'automatic_sc' ),
                    ),
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'modus_sc' )
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','modus_sc' ),
            )
        )
    ));
}
