<?php
add_action('vc_build_admin_page', 'modus_shortcode_testimonial');
add_action( 'vc_before_init', 'modus_shortcode_testimonial' );

function modus_shortcode_testimonial() {
    $link_category = array( esc_html__( 'Select...', 'js_composer' ) => '' );
    $link_cats = get_terms( 'testimonial_cat' );
    if ( is_array( $link_cats ) && ! empty( $link_cats ) ) {
        foreach ( $link_cats as $link_cat ) {
            if ( is_object( $link_cat ) && isset( $link_cat->name, $link_cat->term_id ) ) {
                $link_category[ $link_cat->name ] = $link_cat->term_id;
            }
        }
    }
    vc_map( array(
        'name' => esc_html__( '[Modus] Testimonial', 'modus_sc' ),
        'base' => 'modus_testimonial',
        'icon' => 'modus_vc_icon',
        'category' =>'Modus',
        'description' => esc_html__( 'List item(s) testimonial', 'modus_sc' ),
        'params' => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'modus_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Widget Title.', 'modus_sc' ),
                'admin_label' => true,
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Layout', 'modus_sc' ),
                'param_name' => 'layout',
                'value' => array(
                    esc_html__( 'Layout 1', 'modus_sc' ) => 'layout1',
                    esc_html__( 'Layout 2', 'modus_sc' ) => 'layout2',
                    esc_html__( 'Layout 3', 'modus_sc' ) => 'layout3',
                    esc_html__( 'Layout 4', 'modus_sc' ) => 'layout4',
                    esc_html__( 'Layout 5', 'modus_sc' ) => 'layout5',
                    esc_html__( 'Layout 6', 'modus_sc' ) => 'layout6',
                    esc_html__( 'Layout 7', 'modus_sc' ) => 'layout7',
                    esc_html__( 'Layout 8', 'modus_sc' ) => 'layout8',
                    esc_html__( 'Layout 9', 'modus_sc' ) => 'layout9',
                    esc_html__( 'Layout 10', 'modus_sc' ) => 'layout10',
                ),
                'description' => esc_html__( 'Select layout slide testionial.', 'modus_sc' ),
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Number item", 'modus_sc'),
                "param_name" => "items_show",
                "value" => -1,
                "suffix" => "item(s)",
                "description" => esc_html__("select item show. note: value -1 if show all item.", 'modus_sc'),
            ),
            array(
                "type" => "ult_switch",
                "heading" => esc_html__( "Hidden Job", "modus_sc" ),
                "param_name" => "hidden_job",
                'value' => '',
                'options' => array(
                    'enable_hidden_job' => array(
                        'label' => '',
                        'on' => esc_html__('Yes','ultimate_vc'),
                        'off' => esc_html__('No','ultimate_vc')
                    )
                ),
                'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
                'description' =>esc_html__( 'if enable, hidden job team.','modus_sc' ),
                'dependency' => array(
                    'element' => 'layout',
                    'value' => array('layout1','layout4')
                )
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'modus_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'modus_sc' ),
            ),
        )
    ) );
}