<?php
/**
 * Team
 */
add_action( 'vc_before_init', 'modus_shortcode_team' );

function modus_shortcode_team() {
    $link_group = array( esc_html__( 'Select...', 'modus_sc' ) => '' );
    $link_cats = get_terms( 'team_group' );
    if ( is_array( $link_cats ) && ! empty( $link_cats ) ) {
        foreach ( $link_cats as $link_cat ) {
            if ( is_object( $link_cat ) && isset( $link_cat->name, $link_cat->term_id ) ) {
                $link_group[ $link_cat->name ] = $link_cat->slug;
            }
        }
    }
    vc_map( array(
        "name" => esc_html__( "[Modus] Team", 'modus_sc' ),
        "base" => "modus_team",
        'icon' => 'modus_vc_icon',
        "category" => "Modus",
        "description" => esc_html__( 'Show item team.','modus_sc' ),
        "params" => array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Layout', 'modus_sc' ),
                'param_name' => 'layout',
                'value' => array(
                    esc_html__( 'Layout 1', 'modus_sc' ) => 'layout1',
                    esc_html__( 'Layout 2', 'modus_sc' ) => 'layout2',
                     esc_html__( 'Layout 3', 'modus_sc' ) => 'layout3',
                     esc_html__( 'Layout 4', 'modus_sc' ) => 'layout4',
                ),
                'description' => esc_html__( 'Select layout slide testionial.', 'modus_sc' ),
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Group", "modus_sc"),
                "param_name" => "team_group",
                "value" => $link_group,
                'description' => esc_html__( 'Select team group you would like to use', 'modus_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Column', 'modus_sc' ),
                'param_name' => 'column',
                'value' => array(
                    esc_html__( '1 Column', 'modus_sc' ) => '1',
                    esc_html__( '2 Column', 'modus_sc' ) => '2',
                    esc_html__( '3 Column', 'modus_sc' ) => '3',
                    esc_html__( '4 Column', 'modus_sc' ) => '4',
                ),
                'description' => esc_html__( 'Select column show item.', 'modus_sc' ),
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__( "Show item", 'modus_sc' ),
                "param_name" => "items_show",
                "value" => -1,
                "description" => esc_html__( "Number item show.", 'modus_sc' )
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'modus_sc' )
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','modus_sc' ),
            )
        )
    ));
}