<?php

add_action( 'vc_before_init', 'modus_shortcode_tab_custom' );
function modus_shortcode_tab_custom(){
    vc_map( array(
        "name" => esc_html__( "[Modus] Tab Custom", 'modus_sc' ),
        "base" => "modus_tab_custom",
        "icon" => "modus_vc_icon",
        "category" => "Modus",
        "description" => esc_html__( 'Tab content','modus_sc' ),
        "params" => array(
            array(
                'type' => 'textfield',
                'param_name' => 'title',
                'heading' => esc_html__( 'Title', 'modus_sc' ),
                'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'modus_sc' ),
                'admin_label' => true,
            ),
           array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Values', 'modus_sc' ),
                'param_name' => 'values',
                'description' => esc_html__( 'Enter title and content.', 'modus_sc' ),
                'params' => array(
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Title', 'modus_sc' ),
                        'param_name' => 'title',
                        'description' => esc_html__( 'Title item.', 'modus_sc' ),
                        'admin_label' => true,
                    ),
                    array(
                        "type" => "textarea",
                        "heading" => esc_html__( "Description", 'modus_sc' ),
                        "param_name" => "content",
                        "value" => esc_html__( "", 'modus_sc' ),
                        "description" => esc_html__( "Add description.", 'modus_sc' ),
                    ),
                ),
            ),

            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'modus_sc' )
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','modus_sc'),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','modus_sc' ),
            )

        ),
    ));
}