<?php
add_shortcode('modus_static_block', 'modus_shortcode_static_block');
add_action('vc_build_admin_page', 'modus_load_static_block_shortcode');
add_action('vc_after_init', 'modus_load_static_block_shortcode');

function modus_shortcode_static_block($atts, $content = null) {
    ob_start();
    if ($template = modus_shortcode_template('modus_static_block'))
        include $template;
    return ob_get_clean();
}

function modus_load_static_block_shortcode() {
    $custom_class = modus_vc_custom_class();
    $block_options = array();
    $block_options[0] = __('Choose a block to display', 'modus_sc');
    $args = array(
        'numberposts'       => -1,
        'post_type'         => 'block',
        'post_status'       => 'publish',
    );
    $posts = get_posts($args);
    foreach( $posts as $_post ){
        $block_options[$_post->post_title] = $_post->post_title;
    }
    vc_map( array(
        'name' => "[Modus] " . __('Static Block', 'modus_sc'),
        'base' => 'modus_static_block',
        'category' => 'Modus',
        'icon' => 'modus_vc_icon',
        'weight' => - 50,
        "params" => array(
            array(
                "type" => "dropdown",
                "heading" => __("Static Block", 'modus_sc'),
                "param_name" => "static",
                'value' =>  $block_options,
                "admin_label" => true
            ),
            $custom_class
        )
    ));

    if (!class_exists('WPBakeryShortCode_modus_Static_Block')) {
        class WPBakeryShortCode_modus_Static_Block extends WPBakeryShortCode {
        }
    }
}