<?php
/**
 * Shortcode Social
 */
add_action('vc_build_admin_page', 'modus_shortcode_social');
add_action( 'vc_before_init', 'modus_shortcode_social' );

function modus_shortcode_social() {
    vc_map( array(
        'name' => esc_html__( '[Modus] Social', 'modus_sc' ),
        'base' => 'modus_social',
        'icon' => 'modus_vc_icon',
        'category' =>'Modus',
        'description' => esc_html__( 'List item social', 'modus_sc' ),
        'params' => array(
            array(
                'type' => 'textfield',
                'param_name' => 'title',
                'heading' => esc_html__( 'Title', 'modus_sc' ),
                'description' => esc_html__( 'Enter text used as widget title (Note: located above content element).', 'modus_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'modus_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'modus_sc' ),
            ),
        )
    ) );
}