<?php
add_action('vc_build_admin_page', 'modus_shortcode_services');
add_action( 'vc_before_init', 'modus_shortcode_services' );

function modus_shortcode_services() {
    $layout = array( esc_html__( 'Select category', 'modus_sc' ) => '' );
    $link_cats = get_terms( 'services_cat' );
    if ( is_array( $link_cats ) && ! empty( $link_cats ) ) {
        foreach ( $link_cats as $link_cat ) {
            if ( is_object( $link_cat ) && isset( $link_cat->name, $link_cat->term_id ) ) {
                $layout[ $link_cat->name ] = $link_cat->slug;
            }
        }
    }
    vc_map( array(
        'name' => esc_html__( '[Modus] Services', 'modus_sc' ),
        'base' => 'modus_services',
        'icon' => 'modus_vc_icon',
        'category' =>'Modus',
        'description' => esc_html__( 'List item services', 'modus_sc' ),
        'params' => array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Layout', 'modus_sc' ),
                'param_name' => 'layout',
                'value' => array(
                    esc_html__( 'Layout 1', 'modus_sc' ) => 'layout1',
                    esc_html__( 'Layout 2', 'modus_sc' ) => 'layout2',
                    esc_html__( 'Layout 3', 'modus_sc' ) => 'layout3',
                    esc_html__( 'Layout 4', 'modus_sc' ) => 'layout4',
                ),
                'description' => esc_html__( 'Select type for box.', 'modus_sc' ),
            ),
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Group Layout", "modus"),
                "param_name" => "group_layout",
                "value" => $layout,
                'description' => esc_html__( 'Select category layout you would like to use', 'modus_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Column', 'modus_sc' ),
                'param_name' => 'column',
                'value' => array(
                    esc_html__( '1 Column', 'modus_sc' ) => '1',
                    esc_html__( '2 Column', 'modus_sc' ) => '2',
                    esc_html__( '3 Column', 'modus_sc' ) => '3',
                    esc_html__( '4 Column', 'modus_sc' ) => '4',
                ),
                'description' => esc_html__( 'Select column show item.', 'modus_sc' ),
            ),
            array(
                "type" => "number",
                "class" => "",
                "heading" => esc_html__("Number item", "modus"),
                "param_name" => "items_show",
                "value" => -1,
                "suffix" => "item(s)",
                "description" => esc_html__("select item show. note: value -1 if show all item.", "modus"),
            ),
            array(
                "type" => "number",
                "class" => "",
                "heading" => esc_html__("Words display", "modus"),
                "param_name" => "word_show",
                "value" => 20,
                "suffix" => "word(s)",
                "description" => esc_html__("Enter number of displayed words", "modus"),
            ),
            array(
                "type" => "ult_switch",
                "heading" => esc_html__( "Show Button View All Items", "modus_sc" ),
                "param_name" => "show_btnview",
                'value' => '',
                'options' => array(
                    'enable_show_btnview' => array(
                        'label' => '',
                        'on' => esc_html__('Yes','ultimate_vc'),
                        'off' => esc_html__('No','ultimate_vc')
                    )
                ),
                'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
                'description' =>esc_html__( 'if enable, show button view all.','modus_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'modus_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'modus_sc' ),
            ),
        )
    ) );
}