<?php
add_action('vc_build_admin_page', 'modus_shortcode_tab_slider');
add_action( 'vc_before_init', 'modus_shortcode_tab_slider' );

function modus_shortcode_tab_slider() {
    $layout = array( esc_html__( 'All Links', 'modus_sc' ) => '' );
    $link_cats = get_terms( 'product_cat' );
    if ( is_array( $link_cats ) && ! empty( $link_cats ) ) {
        foreach ( $link_cats as $link_cat ) {
            if ( is_object( $link_cat ) && isset( $link_cat->name, $link_cat->term_id ) ) {
                $layout[ $link_cat->name ] = $link_cat->slug;
            }
        }
    }
    vc_map( array(
        "name" => esc_html__( "[Modus] Product Tab", 'modus_sc' ),
        "base" => "modus_product_tab_slider",
        'icon' => 'modus_vc_icon',
        "category" => 'Modus',
        "description" => esc_html__( 'Tab product.','modus_sc' ),
        "params" => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'modus_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( 'Widget Title.', 'modus_sc' ),
                'admin_label' => true,
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Layout Tab Filter', 'modus_sc' ),
                'param_name' => 'layout_nav',
                'group' => esc_html__( 'Other Setting', 'modus_sc' ),
                'value' => array(
                    esc_html__( 'Default', 'modus_sc' ) => 'default',
                    esc_html__( 'Layout Tab 1', 'modus_sc' ) => 'type1',
                    esc_html__( 'Layout Tab 2', 'modus_sc' ) => 'type2',
                    esc_html__( 'Layout Tab 3', 'modus_sc' ) => 'type3',
                    esc_html__( 'Layout Tab 4', 'modus_sc' ) => 'type4',
                ),
                'description' => esc_html__( 'Select type for tab nagigation shortcode.', 'modus_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Product Show', 'modus_sc' ),
                'param_name' => 'type_product',
                'value' => array(
                    esc_html__( 'New Product', 'modus_sc' ) => 'new-product',
                    esc_html__( 'Sale Product', 'modus_sc' ) => 'sale-product',
                    esc_html__( 'Featured Product', 'modus_sc' ) => 'feature-product',
					esc_html__( 'Best Seller Product', 'modus_sc' ) => 'best-seller-product'
                ),
                'description' => esc_html__( 'Type product show.ex:porpular,best sale...', 'modus_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Layout Tab', 'modus_sc' ),
                'param_name' => 'filter',
                'value' => array(
                    esc_html__( 'Tab Slider', 'modus_sc' ) => 'custom',
                    esc_html__( 'Tab Load More', 'modus_sc' ) => 'tab-loadmore',
                ),
                'description' => esc_html__( 'Select layout for shortcode tab.', 'modus_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Icon Title', 'modus_sc' ),
                'param_name' => 'icon_title',
                'value' => array(
                    esc_html__( 'Image', 'modus_sc' ) => 'icon-image',
                    esc_html__( 'Icon font', 'modus_sc' ) => 'icon-font',
                ),
                'description' => esc_html__( 'Select type icon, use image or font icont.', 'modus_sc' ),
                'dependency' => array(
                    'element' => 'filter',
                    'value' => 'custom',
                )
            ),
            array(
                'type' => 'attach_image',
                'heading' => esc_html__( 'Image', 'modus_sc' ),
                'param_name' => 'image',
                'description' => esc_html__( 'Select image from media library.', 'modus_sc' ),
                'dependency' => array(
                    'element' => 'icon_title',
                    'value' => 'icon-image'
                ),
                'dependency' => array(
                    'element' => 'filter',
                    'value' => 'custom',
                )
            ),
            array(
                "type" => "icon_manager",
                "class" => "",
                "heading" => esc_html__("Select Icon ","modus_sc"),
                "param_name" => "icon_font",
                "value" => "",
                "description" => esc_html__("Click and select icon of your choice. If you can't find the one that suits for your purpose","modus_sc").", ".__("you can","modus_sc")." <a href='admin.php?page=bsf-font-icon-manager' target='_blank'>".__("add new here","modus_sc")."</a>.",
                'dependency' => array(
                    'element' => 'icon_title',
                    'value' => 'icon-font',
                ),
            ),
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Values', 'modus_sc' ),
                'param_name' => 'values',
                'description' => esc_html__( 'Enter icon, title and color.', 'modus_sc' ),
                'value' => urlencode( json_encode( array(
                    array(
                        'label' => esc_html__( 'Tab 1', 'modus_sc' ),
                    ),
                    array(
                        'label' => esc_html__( 'Tab 2', 'modus_sc' ),
                    ),
                    array(
                        'label' => esc_html__( 'Tab 3', 'modus_sc' ),
                    ),
                ) ) ),
                'params' => array(
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Label', 'modus_sc' ),
                        'param_name' => 'label',
                        'description' => esc_html__( 'Label tab.', 'modus_sc' ),
                        'admin_label' => true,
                    ),
                    array(
                        "type" => "dropdown",
                        "heading" => esc_html__("Group", 'modus_sc'),
                        "param_name" => "cat_product",
                        "value" => $layout,
                        'description' => esc_html__( 'Select taxonomy layout you would like to use', 'modus_sc' ),
                    ),
                    array(
                        'type' => 'attach_image',
                        'heading' => esc_html__( 'Image', 'modus_sc' ),
                        'param_name' => 'image',
                        'description' => esc_html__( 'Select image from media library.', 'modus_sc' ),
                    ),
                ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Type', 'modus_sc' ),
                'param_name' => 'type_layout',
                'value' => array(
                    esc_html__( 'Slide type grid', 'modus_sc' ) => 'grid',
                    esc_html__( 'Slide type list', 'modus_sc' ) => 'list',
                ),
                'description' => esc_html__( 'Select type show item product. Default type is slider.', 'modus_sc' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Layout for type grid', 'modus_sc' ),
                'param_name' => 'typegrid',
                'value' => array(
                    esc_html__( 'Type 1', 'modus_sc' ) => 'type1',
                    esc_html__( 'Type 2', 'modus_sc' ) => 'type2',
                    esc_html__( 'Type 3', 'modus_sc' ) => 'type3',
                    esc_html__( 'Type 4', 'modus_sc' ) => 'type4',
                    esc_html__( 'Type 5', 'modus_sc' ) => 'type5',
                    esc_html__( 'Type 6', 'modus_sc' ) => 'type6',
                    esc_html__( 'Type 7', 'modus_sc' ) => 'type7',
                    esc_html__( 'Type 8', 'modus_sc' ) => 'type8',
                    esc_html__( 'Type 9', 'modus_sc' ) => 'type9',
                ),
                'description' => esc_html__( 'Select type css item product.', 'modus_sc' ),
                'dependency' => array(
                    'element' => 'type_layout',
                    'value' => 'grid',
                ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Layout for type list', 'modus_sc' ),
                'param_name' => 'typelist',
                'value' => array(
                    esc_html__( 'Type 1', 'modus_sc' ) => 'type1',
                    esc_html__( 'Type 2', 'modus_sc' ) => 'type2',
                ),
                'description' => esc_html__( 'Select type css item product.', 'modus_sc' ),
                'dependency' => array(
                    'element' => 'type_layout',
                    'value' => 'list',
                ),
            ),
            array(
                "type" => "number",
                "heading" => esc_html__("Number item", 'modus_sc'),
                "param_name" => "items_show",
                "value" => -1,
                "suffix" => "item(s)",
                "description" => esc_html__("select item show in one tab. note: value -1 if show all item.", 'modus_sc'),
            ),
            array(
                'type' => 'number',
                'heading' => esc_html__( 'Column', 'modus_sc' ),
                'param_name' => 'column',
                'value' => 1,
                'min'   => 1,
                'max'   => 6,
                'description' => esc_html__( 'Layout column product slider one tab.', 'modus_sc' ),
            ),
            array(
                'type' => 'number',
                'heading' => esc_html__( 'Row', 'modus_sc' ),
                'param_name' => 'row',
                'value' => 1,
                'min'   => 1,
                'max'   => 6,
                'description' => esc_html__( 'Layout row slide product slider one tab.', 'modus_sc' ),
                'dependency' => array(
                    'element' => 'filter',
                    'value' => 'custom',
                )
            ),
            array(
                "type" => "ult_switch",
                "heading" => esc_html__( "Hidden Load More Button", "modus_sc" ),
                "param_name" => "hidden_loadmore",
                'value' => '',
                'options' => array(
                    'enable_hidden_loadmore' => array(
                        'label' => '',
                        'on' => esc_html__('Yes','ultimate_vc'),
                        'off' => esc_html__('No','ultimate_vc')
                    )
                ),
                'edit_field_class' => 'uvc-divider last-uvc-divider vc_column vc_col-sm-12',
                'description' =>esc_html__( 'if enable, Hidden button load more items.','modus_sc' ),
            ),
			array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Layout button load more', 'modus_sc' ),
                'param_name' => 'type_nav',
                'value' => array(
                    esc_html__( 'Type 1', 'modus_sc' ) => 'nav_default',
                    esc_html__( 'Type 2', 'modus_sc' ) => 'nav_type1',
                    esc_html__( 'Type 3', 'modus_sc' ) => 'nav_type2',
                    esc_html__( 'Type 4', 'modus_sc' ) => 'nav_type3',
                ),
                'description' => esc_html__( 'Select type button load more.', 'modus_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'modus_sc' )
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'Css','modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Option','modus_sc' ),
            )
        )
    ));
}