<?php
add_action('vc_build_admin_page', 'modus_shortcode_product_single_image');
add_action( 'vc_before_init', 'modus_shortcode_product_single_image' );

function modus_shortcode_product_single_image() {
    vc_map( array(
        'name' => esc_html__( '[Modus] Single Image Product', 'modus_sc' ),
        'base' => 'modus_single_image_product',
        'icon' => 'modus_vc_icon',
        'category' =>'Modus',
        'description' => esc_html__( 'Modus advanced with images for product', 'modus_sc' ),
        'params' => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'modus_sc' ),
                'param_name' => 'title',
                'description' => esc_html__( '', 'modus_sc' ),
                'admin_label' => true,
            ),
            array(
                'type' => 'attach_image',
                'heading' => esc_html__( 'Image', 'modus_sc' ),
                'param_name' => 'image',
                'description' => esc_html__( 'Select image from media library.', 'modus_sc' ),
            ),
            array(
                'type' => 'vc_link',
                'heading' => esc_html__( 'URL (Link)', 'modus_sc' ),
                'param_name' => 'link',
                'description' => esc_html__( 'Add link to button..', 'modus_sc' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Extra class name', 'modus_sc' ),
                'param_name' => 'el_class',
                'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'modus_sc' ),
            ),
            array(
                'type' => 'css_editor',
                'heading' => esc_html__( 'CSS box', 'modus_sc' ),
                'param_name' => 'css',
                'group' => esc_html__( 'Design Options', 'modus_sc' ),
            ),
        )
    ) );
}